/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    private final TIntObjectHashMap<IndexData> myDataMap = new TIntObjectHashMap();

    public MavenIndexerWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    @Override
    protected synchronized void onError() {
        super.onError();
        for (int each : this.myDataMap.keys()) {
            ((IndexData)this.myDataMap.get(each)).remoteId = -1;
        }
    }

    public synchronized int createIndex(@NotNull String indexId, @NotNull String repositoryId, @Nullable File file, @Nullable String url, @NotNull File indexDir) throws MavenServerIndexerException {
        if (indexId == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(0);
        }
        if (repositoryId == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(1);
        }
        if (indexDir == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(2);
        }
        IndexData data = new IndexData(indexId, repositoryId, file, url, indexDir);
        int localId = System.identityHashCode(data);
        this.myDataMap.put(localId, (Object)data);
        this.perform(() -> this.getRemoteId(localId));
        return localId;
    }

    public synchronized void releaseIndex(int localId) throws MavenServerIndexerException {
        IndexData data = (IndexData)this.myDataMap.remove(localId);
        if (data == null) {
            MavenLog.LOG.warn("index " + localId + " not found");
            return;
        }
        if (data.remoteId == -1) {
            return;
        }
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(data.remoteId, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public synchronized boolean indexExists(File dir) {
        try {
            return ((MavenServerIndexer)this.getOrCreateWrappee()).indexExists(dir, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public int getIndexCount() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getIndexCount(ourToken));
    }

    public void updateIndex(int localId, MavenGeneralSettings settings, MavenProgressIndicator indicator) throws MavenProcessCanceledException, MavenServerIndexerException {
        this.performCancelable(() -> {
            MavenServerProgressIndicator indicatorWrapper = MavenIndexerWrapper.wrapAndExport(indicator);
            try {
                ((MavenServerIndexer)this.getOrCreateWrappee()).updateIndex(this.getRemoteId(localId), MavenServerManager.convertSettings(settings), indicatorWrapper, ourToken);
            }
            finally {
                UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
            }
            return null;
        });
    }

    public void processArtifacts(int indexId, MavenIndicesProcessor processor) throws MavenServerIndexerException {
        this.perform(() -> {
            MavenServerIndicesProcessor processorWrapper = this.wrapAndExport(processor);
            try {
                ((MavenServerIndexer)this.getOrCreateWrappee()).processArtifacts(this.getRemoteId(indexId), processorWrapper, ourToken);
            }
            finally {
                UnicastRemoteObject.unexportObject((Remote)processorWrapper, true);
            }
            return null;
        });
    }

    public IndexedMavenId addArtifact(int localId, File artifactFile) throws MavenServerIndexerException {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).addArtifact(this.getRemoteId(localId), artifactFile, ourToken));
    }

    public Set<MavenArtifactInfo> search(int localId, Query query, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).search(this.getRemoteId(localId), query, maxResult, ourToken));
    }

    private synchronized int getRemoteId(int localId) throws RemoteException, MavenServerIndexerException {
        IndexData result = (IndexData)this.myDataMap.get(localId);
        MavenLog.LOG.assertTrue(result != null, (Object)("index " + localId + " not found"));
        if (result.remoteId == -1) {
            result.remoteId = ((MavenServerIndexer)this.getOrCreateWrappee()).createIndex(result.indexId, result.repositoryId, result.file, result.url, result.indexDir, MavenIndexerWrapper.ourToken);
        }
        return result.remoteId;
    }

    public Collection<MavenArchetype> getArchetypes() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getArchetypes(ourToken));
    }

    public void releaseInTests() {
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private MavenServerIndicesProcessor wrapAndExport(MavenIndicesProcessor processor) {
        return MavenIndexerWrapper.doWrapAndExport(new RemoteMavenServerIndicesProcessor(processor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indexId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "repositoryId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "indexDir";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
        objectArray[2] = "createIndex";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoteMavenServerIndicesProcessor
    extends MavenRemoteObject
    implements MavenServerIndicesProcessor {
        private final MavenIndicesProcessor myProcessor;

        private RemoteMavenServerIndicesProcessor(MavenIndicesProcessor processor) {
            this.myProcessor = processor;
        }

        public void processArtifacts(Collection<IndexedMavenId> artifacts) {
            this.myProcessor.processArtifacts(artifacts);
        }
    }

    private static class IndexData {
        private int remoteId;
        @NotNull
        private final String indexId;
        @NotNull
        private final String repositoryId;
        @Nullable
        private final File file;
        @Nullable
        private final String url;
        @NotNull
        private final File indexDir;

        IndexData(@NotNull String indexId, @NotNull String repositoryId, @Nullable File file, @Nullable String url, @NotNull File indexDir) {
            if (indexId == null) {
                IndexData.$$$reportNull$$$0(0);
            }
            if (repositoryId == null) {
                IndexData.$$$reportNull$$$0(1);
            }
            if (indexDir == null) {
                IndexData.$$$reportNull$$$0(2);
            }
            this.remoteId = -1;
            this.indexId = indexId;
            this.repositoryId = repositoryId;
            this.file = file;
            this.url = url;
            this.indexDir = indexDir;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexDir";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper$IndexData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

