/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class MavenGeneralPanel
implements PanelWithAnchor {
    private JCheckBox checkboxWorkOffline;
    private JPanel panel;
    private JComboBox outputLevelCombo;
    private JCheckBox checkboxProduceExceptionErrorMessages;
    private JComboBox checksumPolicyCombo;
    private JComboBox failPolicyCombo;
    private JCheckBox checkboxUsePluginRegistry;
    private JCheckBox checkboxRecursive;
    private MavenEnvironmentForm mavenPathsForm;
    private JBLabel myMultiProjectBuildFailPolicyLabel;
    private JCheckBox alwaysUpdateSnapshotsCheckBox;
    private JTextField threadsEditor;
    private final DefaultComboBoxModel outputLevelComboModel;
    private final DefaultComboBoxModel checksumPolicyComboModel;
    private final DefaultComboBoxModel failPolicyComboModel;
    private final DefaultComboBoxModel pluginUpdatePolicyComboModel;
    private JComponent anchor;

    public MavenGeneralPanel() {
        this.$$$setupUI$$$();
        this.outputLevelComboModel = new DefaultComboBoxModel();
        this.checksumPolicyComboModel = new DefaultComboBoxModel();
        this.failPolicyComboModel = new DefaultComboBoxModel();
        this.pluginUpdatePolicyComboModel = new DefaultComboBoxModel();
        this.fillOutputLevelCombobox();
        this.fillChecksumPolicyCombobox();
        this.fillFailureBehaviorCombobox();
        this.setAnchor((JComponent)this.myMultiProjectBuildFailPolicyLabel);
    }

    private void fillOutputLevelCombobox() {
        ComboBoxUtil.setModel(this.outputLevelCombo, this.outputLevelComboModel, Arrays.asList(MavenExecutionOptions.LoggingLevel.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    private void fillFailureBehaviorCombobox() {
        ComboBoxUtil.setModel(this.failPolicyCombo, this.failPolicyComboModel, Arrays.asList(MavenExecutionOptions.FailureMode.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    private void fillChecksumPolicyCombobox() {
        ComboBoxUtil.setModel(this.checksumPolicyCombo, this.checksumPolicyComboModel, Arrays.asList(MavenExecutionOptions.ChecksumPolicy.values()), each -> Pair.create((Object)each.getDisplayString(), (Object)each));
    }

    public JComponent createComponent() {
        this.mavenPathsForm.createComponent();
        return this.panel;
    }

    protected void setData(MavenGeneralSettings data) {
        data.beginUpdate();
        data.setWorkOffline(this.checkboxWorkOffline.isSelected());
        this.mavenPathsForm.setData(data);
        data.setPrintErrorStackTraces(this.checkboxProduceExceptionErrorMessages.isSelected());
        data.setUsePluginRegistry(this.checkboxUsePluginRegistry.isSelected());
        data.setNonRecursive(!this.checkboxRecursive.isSelected());
        data.setOutputLevel((MavenExecutionOptions.LoggingLevel)((Object)ComboBoxUtil.getSelectedValue(this.outputLevelComboModel)));
        data.setChecksumPolicy((MavenExecutionOptions.ChecksumPolicy)((Object)ComboBoxUtil.getSelectedValue(this.checksumPolicyComboModel)));
        data.setFailureBehavior((MavenExecutionOptions.FailureMode)((Object)ComboBoxUtil.getSelectedValue(this.failPolicyComboModel)));
        data.setPluginUpdatePolicy((MavenExecutionOptions.PluginUpdatePolicy)((Object)ComboBoxUtil.getSelectedValue(this.pluginUpdatePolicyComboModel)));
        data.setAlwaysUpdateSnapshots(this.alwaysUpdateSnapshotsCheckBox.isSelected());
        data.setThreads(this.threadsEditor.getText());
        data.endUpdate();
    }

    protected void getData(MavenGeneralSettings data) {
        this.checkboxWorkOffline.setSelected(data.isWorkOffline());
        this.mavenPathsForm.getData(data);
        this.checkboxProduceExceptionErrorMessages.setSelected(data.isPrintErrorStackTraces());
        this.checkboxUsePluginRegistry.setSelected(data.isUsePluginRegistry());
        this.checkboxRecursive.setSelected(!data.isNonRecursive());
        this.alwaysUpdateSnapshotsCheckBox.setSelected(data.isAlwaysUpdateSnapshots());
        this.threadsEditor.setText(StringUtil.notNullize((String)data.getThreads()));
        ComboBoxUtil.select(this.outputLevelComboModel, (Object)data.getOutputLevel());
        ComboBoxUtil.select(this.checksumPolicyComboModel, (Object)data.getChecksumPolicy());
        ComboBoxUtil.select(this.failPolicyComboModel, (Object)data.getFailureBehavior());
        ComboBoxUtil.select(this.pluginUpdatePolicyComboModel, (Object)data.getPluginUpdatePolicy());
    }

    @Nls
    public String getDisplayName() {
        return CommonBundle.message((String)"tab.title.general", (Object[])new Object[0]);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myMultiProjectBuildFailPolicyLabel.setAnchor(anchor);
        this.mavenPathsForm.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        MavenEnvironmentForm mavenEnvironmentForm;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.output.level"));
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(66, 23), null));
        this.outputLevelCombo = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(5, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.checksum.policy"));
        jPanel.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checksumPolicyCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(6, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myMultiProjectBuildFailPolicyLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.multiproject.build.policy"));
        jPanel.add((Component)jBLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.failPolicyCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(7, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.checkboxWorkOffline = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.work.offline"));
        jCheckBox5.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.work.offline.tooltip"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxUsePluginRegistry = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.use.plugin.registry"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.use.plugin.registry.tooltip"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.checkboxRecursive = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.execute.recursively"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.execute.recursively.tooltip"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, new Dimension(185, 22), null));
        this.checkboxProduceExceptionErrorMessages = jCheckBox2 = new JCheckBox();
        jCheckBox2.setAlignmentY(0.5f);
        jCheckBox2.setMargin(new Insets(2, 0, 2, 0));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.print.stacktraces"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.print.stacktraces.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mavenPathsForm = mavenEnvironmentForm = new MavenEnvironmentForm();
        JComponent jComponent = mavenEnvironmentForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(9, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.alwaysUpdateSnapshotsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.update.snapshots"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.update.snapshots.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(10);
        jBLabel2.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.thread.count"));
        jBLabel2.setToolTipText(ResourceBundle.getBundle("messages/MavenConfigurableBundle").getString("maven.settings.general.thread.count.tooltip"));
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.threadsEditor = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(8, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenGeneralPanel.class).getString("maven.settings.general.thread.count.note"));
        jPanel.add((Component)jBLabel3, new GridConstraints(8, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel2.setLabelFor(jComboBox2);
        jBLabel.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

