/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.PropertiesUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public final class MavenJUnitPatcher
extends JUnitPatcher {
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)}");
    public static final Pattern ARG_LINE_PATTERN = Pattern.compile("@\\{(.+?)}");
    private static final Logger LOG = Logger.getInstance(MavenJUnitPatcher.class);
    private static final Set<String> EXCLUDE_SUBTAG_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"classpathDependencyExclude", "classpathDependencyExcludes", "dependencyExclude"});
    private static final Map<String, List<String>> SCOPE_FILTER = ContainerUtil.immutableMapBuilder().put((Object)"compile", Arrays.asList("system", "provided", "compile")).put((Object)"runtime", Arrays.asList("compile", "runtime")).put((Object)"compile+runtime", Arrays.asList("system", "provided", "compile", "runtime")).put((Object)"runtime+system", Arrays.asList("system", "compile", "runtime")).put((Object)"test", Arrays.asList("system", "provided", "compile", "runtime", "test")).build();

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        if (module == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return;
        }
        UnaryOperator<String> runtimeProperties = MavenJUnitPatcher.getDynamicConfigurationProperties(module, mavenProject, javaParameters);
        MavenJUnitPatcher.configureFromPlugin(module, javaParameters, mavenProject, runtimeProperties, "maven-surefire-plugin", "surefire");
        MavenJUnitPatcher.configureFromPlugin(module, javaParameters, mavenProject, runtimeProperties, "maven-failsafe-plugin", "failsafe");
    }

    private static void configureFromPlugin(@NotNull Module module, JavaParameters javaParameters, MavenProject mavenProject, UnaryOperator<String> runtimeProperties, String pluginArtifact, String pluginName) {
        MavenPlugin plugin;
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(0);
        }
        if ((plugin = mavenProject.findPlugin("org.apache.maven.plugins", pluginArtifact)) != null) {
            Element config = mavenProject.getPluginGoalConfiguration(plugin, null);
            if (config == null) {
                config = new Element("configuration");
            }
            MavenJUnitPatcher.patchJavaParameters(module, javaParameters, mavenProject, pluginName, config, runtimeProperties);
        }
    }

    private static UnaryOperator<String> getDynamicConfigurationProperties(Module module, MavenProject mavenProject, JavaParameters javaParameters) {
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        if (domModel == null) {
            return s -> s;
        }
        Properties staticProperties = MavenPropertyResolver.collectPropertiesFromDOM(mavenProject, domModel);
        String jaCoCoConfigProperty = MavenJUnitPatcher.getJaCoCoArgLineProperty(mavenProject);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        return name -> {
            String vmPropertyValue = vmParameters.getPropertyValue(name);
            if (vmPropertyValue != null) {
                return vmPropertyValue;
            }
            String staticPropertyValue = staticProperties.getProperty((String)name);
            if (staticPropertyValue != null) {
                return MavenPropertyResolver.resolve(staticPropertyValue, domModel);
            }
            if (name.equals(jaCoCoConfigProperty)) {
                return "";
            }
            return null;
        };
    }

    private static String getJaCoCoArgLineProperty(MavenProject mavenProject) {
        Element propertyName;
        Element jaCoCoGoalConfig;
        Element propertyName2;
        String jaCoCoConfigProperty = "argLine";
        Element jaCoCoConfig = mavenProject.getPluginConfiguration("org.jacoco", "jacoco-maven-plugin");
        if (jaCoCoConfig != null && (propertyName2 = jaCoCoConfig.getChild("propertyName")) != null) {
            jaCoCoConfigProperty = propertyName2.getTextTrim();
        }
        if ((jaCoCoGoalConfig = mavenProject.getPluginGoalConfiguration("org.jacoco", "jacoco-maven-plugin", "prepare-agent")) != null && (propertyName = jaCoCoGoalConfig.getChild("propertyName")) != null) {
            jaCoCoConfigProperty = propertyName.getTextTrim();
        }
        return jaCoCoConfigProperty;
    }

    private static void patchJavaParameters(@NotNull Module module, @NotNull JavaParameters javaParameters, @NotNull MavenProject mavenProject, @NotNull String plugin, @NotNull Element config, @NotNull UnaryOperator<String> runtimeProperties) {
        Element environmentVariables;
        String value;
        if (module == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(1);
        }
        if (javaParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(2);
        }
        if (mavenProject == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(3);
        }
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(4);
        }
        if (config == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(5);
        }
        if (runtimeProperties == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(6);
        }
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        MavenTestRunningSettings testRunningSettings = MavenProjectSettings.getInstance(module.getProject()).getTestRunningSettings();
        List<String> paths = MavenJDOMUtil.findChildrenValuesByPath(config, "additionalClasspathElements", "additionalClasspathElement");
        if (paths.size() > 0) {
            for (String pathLine : paths) {
                for (String path : pathLine.split(",")) {
                    javaParameters.getClassPath().add(MavenJUnitPatcher.resolvePluginProperties(plugin, path.trim(), domModel));
                }
            }
        }
        List<String> excludes = MavenJUnitPatcher.getExcludedArtifacts(config);
        String scopeExclude = MavenJDOMUtil.findChildValueByPath(config, "classpathDependencyScopeExclude");
        if (scopeExclude != null || !excludes.isEmpty()) {
            for (MavenArtifact dependency : mavenProject.getDependencies()) {
                if (!SCOPE_FILTER.getOrDefault(scopeExclude, Collections.emptyList()).contains(dependency.getScope()) && !excludes.contains(dependency.getGroupId() + ":" + dependency.getArtifactId())) continue;
                File file = dependency.getFile();
                javaParameters.getClassPath().remove(file.getAbsolutePath());
            }
        }
        if (testRunningSettings.isPassSystemProperties()) {
            Element systemPropertiesFile;
            Element systemPropertyVariables;
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertyVariables") && (systemPropertyVariables = config.getChild("systemPropertyVariables")) != null) {
                for (Element element : systemPropertyVariables.getChildren()) {
                    String propertyName = element.getName();
                    if (javaParameters.getVMParametersList().hasProperty(propertyName)) continue;
                    value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                    value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                    if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                    javaParameters.getVMParametersList().addProperty(propertyName, value);
                }
            }
            if (MavenJUnitPatcher.isEnabled(plugin, "systemPropertiesFile") && (systemPropertiesFile = config.getChild("systemPropertiesFile")) != null) {
                String systemPropertiesFilePath = systemPropertiesFile.getTextTrim();
                if (StringUtil.isNotEmpty((String)systemPropertiesFilePath) && !FileUtil.isAbsolute((String)systemPropertiesFilePath)) {
                    systemPropertiesFilePath = mavenProject.getDirectory() + '/' + systemPropertiesFilePath;
                }
                if (StringUtil.isNotEmpty((String)systemPropertiesFilePath) && new File(systemPropertiesFilePath).exists()) {
                    try (BufferedReader fis = Files.newBufferedReader(Paths.get(systemPropertiesFilePath, new String[0]), StandardCharsets.ISO_8859_1);){
                        Map properties = PropertiesUtil.loadProperties((Reader)fis);
                        properties.forEach((pName, pValue) -> javaParameters.getVMParametersList().addProperty(pName, pValue));
                    }
                    catch (IOException e) {
                        LOG.warn("Can't read property file '" + systemPropertiesFilePath + "': " + e.getMessage());
                    }
                }
            }
        }
        if (testRunningSettings.isPassEnvironmentVariables() && MavenJUnitPatcher.isEnabled(plugin, "environmentVariables") && (environmentVariables = config.getChild("environmentVariables")) != null) {
            for (Element element : environmentVariables.getChildren()) {
                String variableName = element.getName();
                if (javaParameters.getEnv().containsKey(variableName)) continue;
                value = MavenJUnitPatcher.resolvePluginProperties(plugin, element.getValue(), domModel);
                value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                if (!MavenJUnitPatcher.isResolved(plugin, value)) continue;
                javaParameters.addEnv(variableName, value);
            }
        }
        if (testRunningSettings.isPassArgLine() && MavenJUnitPatcher.isEnabled(plugin, "argLine")) {
            Element argLine = config.getChild("argLine");
            String propertyText = argLine != null ? argLine.getTextTrim() : "${argLine}";
            String value2 = MavenJUnitPatcher.resolvePluginProperties(plugin, propertyText, domModel);
            value2 = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value2);
            if (StringUtil.isNotEmpty((String)value2) && MavenJUnitPatcher.isResolved(plugin, value2)) {
                value2 = MavenJUnitPatcher.resolveRuntimeProperties(value2, runtimeProperties);
                javaParameters.getVMParametersList().addParametersString(value2);
            }
        }
    }

    private static String resolveRuntimeProperties(String value, UnaryOperator<String> runtimeProperties) {
        Matcher matcher = ARG_LINE_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = (String)runtimeProperties.apply(matcher.group(1));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement == null ? matcher.group() : replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @NotNull
    private static List<String> getExcludedArtifacts(@NotNull Element config) {
        Element excludesElement;
        if (config == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(7);
        }
        if ((excludesElement = config.getChild("classpathDependencyExcludes")) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenJUnitPatcher.$$$reportNull$$$0(8);
            }
            return list;
        }
        String rawText = excludesElement.getTextTrim();
        ArrayList<String> excludes = new ArrayList<String>();
        if (!rawText.isEmpty()) {
            StreamEx.split((CharSequence)rawText, (char)',').map(String::trim).into(excludes);
        }
        for (Element child : excludesElement.getChildren()) {
            String excludeItem;
            if (!EXCLUDE_SUBTAG_NAMES.contains(child.getName()) || (excludeItem = child.getTextTrim()).isEmpty()) continue;
            StreamEx.split((CharSequence)excludeItem, (char)',').map(String::trim).into(excludes);
        }
        ArrayList<String> arrayList = excludes;
        if (arrayList == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static String resolvePluginProperties(@NotNull String plugin, @NotNull String value, @Nullable MavenDomProjectModel domModel) {
        if (plugin == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(10);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(11);
        }
        if (domModel != null) {
            value = MavenPropertyResolver.resolve(value, domModel);
        }
        return value.replaceAll("\\$\\{" + plugin + "\\.(forkNumber|threadNumber)}", "1");
    }

    private static String resolveVmProperties(@NotNull ParametersList vmParameters, @NotNull String value) {
        if (vmParameters == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(12);
        }
        if (value == null) {
            MavenJUnitPatcher.$$$reportNull$$$0(13);
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        HashMap<String, String> toReplace = new HashMap<String, String>();
        while (matcher.find()) {
            String finding = matcher.group();
            String propertyValue = vmParameters.getPropertyValue(finding.substring(2, finding.length() - 1));
            if (propertyValue == null) continue;
            toReplace.put(finding, propertyValue);
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return value;
    }

    private static boolean isEnabled(String plugin, String s) {
        return Boolean.valueOf(System.getProperty("idea.maven." + plugin + ".disable." + s)) == false;
    }

    private static boolean isResolved(String plugin, String s) {
        return !s.contains("${") || Boolean.valueOf(System.getProperty("idea.maven." + plugin + ".allPropertiesAreResolved")) != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenJUnitPatcher";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenJUnitPatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureFromPlugin";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchJavaParameters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedArtifacts";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolvePluginProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveVmProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

