/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.externalSystem.service.execution.cmd.CommandLineCompletionProvider;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenArgumentsCompletionProvider
extends CommandLineCompletionProvider {
    private static final Options ourOptions;
    private volatile List<LookupElement> myCachedElements;
    private final Project myProject;

    public MavenArgumentsCompletionProvider(@NotNull Project project) {
        if (project == null) {
            MavenArgumentsCompletionProvider.$$$reportNull$$$0(0);
        }
        super(ourOptions);
        this.myProject = project;
    }

    protected void addArgumentVariants(@NotNull CompletionResultSet result) {
        List<LookupElement> cachedElements;
        if (result == null) {
            MavenArgumentsCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((cachedElements = this.myCachedElements) == null) {
            this.myCachedElements = cachedElements = MavenUtil.getPhaseVariants(MavenProjectsManager.getInstance(this.myProject));
        }
        result.addAllElements(cachedElements);
    }

    static {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display help information");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Force the use of an alternate POM file (or directory with pom.xml).");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"offline");
        OptionBuilder.withDescription((String)"Work offline");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Display version information");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"Quiet output - only show errors");
        options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output");
        options.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"non-recursive");
        OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
        options.addOption(OptionBuilder.create((char)'N'));
        OptionBuilder.withLongOpt((String)"update-snapshots");
        OptionBuilder.withDescription((String)"Forces a check for updated releases and snapshots on remote repositories");
        options.addOption(OptionBuilder.create((char)'U'));
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"batch-mode");
        OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
        options.addOption(OptionBuilder.create((char)'B'));
        OptionBuilder.withLongOpt((String)"no-snapshot-updates");
        OptionBuilder.withDescription((String)"Suppress SNAPSHOT updates");
        options.addOption(OptionBuilder.create((String)"nsu"));
        OptionBuilder.withLongOpt((String)"strict-checksums");
        OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
        options.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"lax-checksums");
        OptionBuilder.withDescription((String)"Warn if checksums don't match");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"settings");
        OptionBuilder.withDescription((String)"Alternate path for the user settings file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"global-settings");
        OptionBuilder.withDescription((String)"Alternate path for the global settings file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"gs"));
        OptionBuilder.withLongOpt((String)"toolchains");
        OptionBuilder.withDescription((String)"Alternate path for the user toolchains file");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"fail-fast");
        OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
        options.addOption(OptionBuilder.create((String)"ff"));
        OptionBuilder.withLongOpt((String)"fail-at-end");
        OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
        options.addOption(OptionBuilder.create((String)"fae"));
        OptionBuilder.withLongOpt((String)"fail-never");
        OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
        options.addOption(OptionBuilder.create((String)"fn"));
        OptionBuilder.withLongOpt((String)"resume-from");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Resume reactor from specified project");
        options.addOption(OptionBuilder.create((String)"rf"));
        OptionBuilder.withLongOpt((String)"projects");
        OptionBuilder.withDescription((String)"Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path.");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"pl"));
        OptionBuilder.withLongOpt((String)"also-make");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects required by the list");
        options.addOption(OptionBuilder.create((String)"am"));
        OptionBuilder.withLongOpt((String)"also-make-dependents");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects that depend on projects on the list");
        options.addOption(OptionBuilder.create((String)"amd"));
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Log file to where all build output will go.");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"show-version");
        OptionBuilder.withDescription((String)"Display version information WITHOUT stopping build");
        options.addOption(OptionBuilder.create((char)'V'));
        OptionBuilder.withLongOpt((String)"encrypt-master-password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Encrypt master security password");
        options.addOption(OptionBuilder.create((String)"emp"));
        OptionBuilder.withLongOpt((String)"encrypt-password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Encrypt server password");
        options.addOption(OptionBuilder.create((String)"ep"));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Thread count, for instance 2.0C where C is core multiplied");
        options.addOption(OptionBuilder.create((String)"T"));
        ourOptions = options;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenArgumentsCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addArgumentVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

