/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ExceptionUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.idea.maven.server.security.TokenReader;

public class MavenServerUtil {
    private static final Properties mySystemPropertiesCache;
    private static MavenToken ourToken;

    public static Properties collectSystemProperties() {
        return mySystemPropertiesCache;
    }

    @NotNull
    public static File findMavenBasedir(@NotNull File workingDir) {
        File file;
        if (workingDir == null) {
            MavenServerUtil.$$$reportNull$$$0(0);
        }
        File baseDir = workingDir;
        File dir = workingDir;
        while ((dir = dir.getParentFile()) != null) {
            if (!new File(dir, ".mvn").exists()) continue;
            baseDir = dir;
            break;
        }
        try {
            file = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = baseDir.getAbsoluteFile();
            if (file2 == null) {
                MavenServerUtil.$$$reportNull$$$0(2);
            }
            return file2;
        }
        if (file == null) {
            MavenServerUtil.$$$reportNull$$$0(1);
        }
        return file;
    }

    private static boolean isMagicalProperty(String key) {
        return key.startsWith("=");
    }

    public static void registerShutdownTask(Runnable task) {
        Runtime.getRuntime().addShutdownHook(new Thread(task, "Maven-server-shutdown-hook"));
    }

    public static void addProperty(String propertyName, String value) {
        mySystemPropertiesCache.setProperty(propertyName, value);
    }

    public static void removeProperty(String propertyName) {
        mySystemPropertiesCache.remove(propertyName);
    }

    public static void checkToken(MavenToken token) throws SecurityException {
        if (ourToken == null || !ourToken.equals(token)) {
            throw new SecurityException();
        }
    }

    public static MavenToken getToken() {
        return ourToken;
    }

    public static void readToken() {
        try {
            ourToken = new TokenReader(new Scanner(System.in), 10000).getToken();
        }
        catch (Throwable e) {
            ExceptionUtilRt.rethrowUnchecked((Throwable)e);
        }
    }

    static {
        Properties res = new Properties();
        res.putAll((Map<?, ?>)((Properties)System.getProperties().clone()));
        Iterator<Object> itr = res.keySet().iterator();
        while (itr.hasNext()) {
            String propertyName = itr.next().toString();
            if (!propertyName.startsWith("idea.")) continue;
            itr.remove();
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (MavenServerUtil.isMagicalProperty(key)) continue;
            if (SystemInfoRt.isWindows) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            res.setProperty("env." + key, entry.getValue());
        }
        mySystemPropertiesCache = res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findMavenBasedir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMavenBasedir";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

