/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.impl.AntBeforeRunTask;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AntIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntBeforeRunTaskProvider
extends BeforeRunTaskProvider<AntBeforeRunTask> {
    public static final Key<AntBeforeRunTask> ID = Key.create((String)"AntTarget");
    private final Project myProject;

    public AntBeforeRunTaskProvider(Project project) {
        this.myProject = project;
    }

    public Key<AntBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return AntBundle.message("ant.target.before.run.description.empty", new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Target;
    }

    public Icon getTaskIcon(AntBeforeRunTask task) {
        AntBuildTarget antTarget = this.findTargetToExecute(task);
        return antTarget instanceof MetaTarget ? AntIcons.MetaTarget : AllIcons.Nodes.Target;
    }

    public String getDescription(AntBeforeRunTask task) {
        String targetName = task.getTargetName();
        if (targetName == null) {
            return AntBundle.message("ant.target.before.run.description.empty", new Object[0]);
        }
        return AntBundle.message("ant.target.before.run.description", targetName);
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull AntBeforeRunTask task) {
        AntBuildTarget buildTarget;
        TargetChooserDialog dlg;
        if (runConfiguration == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if (task == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((dlg = new TargetChooserDialog(this.myProject, buildTarget = this.findTargetToExecute(task))).showAndGet()) {
            VirtualFile vFile;
            task.setTargetName(null);
            task.setAntFileUrl(null);
            buildTarget = dlg.getSelectedTarget();
            if (buildTarget != null && (vFile = buildTarget.getModel().getBuildFile().getVirtualFile()) != null) {
                task.setAntFileUrl(vFile.getUrl());
                task.setTargetName(buildTarget.getName());
            }
            return true;
        }
        return false;
    }

    public AntBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        return new AntBeforeRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull AntBeforeRunTask task) {
        if (configuration == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        return this.findTargetToExecute(task) != null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull AntBeforeRunTask task) {
        AntBuildTarget target;
        if (context == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if ((target = this.findTargetToExecute(task)) != null) {
            return AntConfigurationImpl.executeTargetSynchronously(context, target);
        }
        return true;
    }

    @Nullable
    private AntBuildTarget findTargetToExecute(@NotNull AntBeforeRunTask task) {
        if (task == null) {
            AntBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        return GlobalAntConfiguration.getInstance().findTarget(this.myProject, task.getAntFileUrl(), task.getTargetName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ant/config/impl/AntBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetToExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

