/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.MessageNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MultilineTreeCellRenderer;
import icons.AntIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;

final class MessageTreeRenderer
extends MultilineTreeCellRenderer {
    private boolean myUseAnsiColor = false;
    private Color myDefaultForeground;

    private MessageTreeRenderer() {
    }

    public void setUseAnsiColor(boolean useAnsiColor) {
        this.myUseAnsiColor = useAnsiColor;
    }

    public static JScrollPane install(JTree tree) {
        JScrollPane scrollPane = MultilineTreeCellRenderer.installRenderer((JTree)tree, (MultilineTreeCellRenderer)new MessageTreeRenderer());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        return scrollPane;
    }

    protected void initComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof MessageNode) {
            MessageNode messageNode = (MessageNode)value;
            this.setText(messageNode.getText(), messageNode.getTypeString() + messageNode.getPositionString());
        } else {
            String[] text = new String[]{value.toString()};
            if (text[0] == null) {
                text[0] = "";
            }
            this.setText(text, null);
        }
        Icon icon = null;
        Color foreground = this.myDefaultForeground;
        if (foreground == null) {
            this.myDefaultForeground = foreground = this.getForeground();
        }
        if (value instanceof MessageNode) {
            MessageNode node = (MessageNode)value;
            AntBuildMessageView.MessageType type = node.getType();
            if (type == AntBuildMessageView.MessageType.BUILD) {
                icon = AntIcons.Build;
            } else if (type == AntBuildMessageView.MessageType.TARGET) {
                icon = AllIcons.Nodes.Target;
            } else if (type == AntBuildMessageView.MessageType.TASK) {
                icon = AntIcons.Task;
            } else if (type == AntBuildMessageView.MessageType.MESSAGE) {
                if (node.getPriority() == 1) {
                    icon = AllIcons.General.Warning;
                    foreground = ConsoleViewContentType.LOG_WARNING_OUTPUT.getAttributes().getForegroundColor();
                } else if (node.getPriority() == 2) {
                    icon = AllIcons.General.Information;
                    foreground = ConsoleViewContentType.LOG_INFO_OUTPUT.getAttributes().getForegroundColor();
                } else if (node.getPriority() == 3) {
                    icon = AntIcons.LogVerbose;
                    foreground = ConsoleViewContentType.LOG_VERBOSE_OUTPUT.getAttributes().getForegroundColor();
                } else {
                    icon = AntIcons.LogDebug;
                    foreground = ConsoleViewContentType.LOG_DEBUG_OUTPUT.getAttributes().getForegroundColor();
                }
            } else if (type == AntBuildMessageView.MessageType.ERROR) {
                icon = AllIcons.General.Error;
                foreground = ConsoleViewContentType.LOG_ERROR_OUTPUT.getAttributes().getForegroundColor();
            }
        }
        if (this.myUseAnsiColor) {
            this.setForeground(foreground);
        }
        this.setIcon(icon);
    }
}

