/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class TestDataGuessByExistingFilesUtil {
    private static final Logger LOG = Logger.getInstance(TestDataGuessByExistingFilesUtil.class);

    private TestDataGuessByExistingFilesUtil() {
    }

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiMethod psiMethod, @Nullable String testDataPath) {
        Application application;
        if (psiMethod == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(0);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode() && application.isHeadlessEnvironment()) {
            LOG.warn("Collecting testdata by existing files called in headless environment and not-unit testing mode");
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod, testDataPath).restoreFiles());
        if (list == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    static List<TestDataFile> guessTestDataName(PsiMethod method) {
        String testName = TestDataGuessByExistingFilesUtil.getTestName(method);
        if (testName == null) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        String testDataBasePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
        int count = 5;
        PsiMethod prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)method, PsiMethod.class);
        while (prev != null && count-- > 0) {
            List<TestDataFile> testData = TestDataGuessByExistingFilesUtil.guessTestDataBySiblingTest(prev, testDataBasePath, testName);
            if (!testData.isEmpty()) {
                List<TestDataFile> list = testData;
                if (list == null) {
                    TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
            prev = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiMethod.class);
        }
        count = 5;
        PsiMethod next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)method, PsiMethod.class);
        while (next != null && count-- > 0) {
            List<TestDataFile> testData = TestDataGuessByExistingFilesUtil.guessTestDataBySiblingTest(next, testDataBasePath, testName);
            if (!testData.isEmpty()) {
                List<TestDataFile> list = testData;
                if (list == null) {
                    TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(6);
                }
                return list;
            }
            next = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiMethod.class);
        }
        List<TestDataFile> list = Collections.emptyList();
        if (list == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<TestDataFile> guessTestDataBySiblingTest(PsiMethod psiMethod, String testDataBasePath, String testName) {
        List<TestDataFile> list = TestDataGuessByExistingFilesUtil.buildDescriptorFromExistingTestData(psiMethod, testDataBasePath).generateByTemplates(testName, null);
        if (list == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static String getTestName(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(9);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class)) == null) {
            return null;
        }
        TestFramework framework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (framework == null || TestDataGuessByExistingFilesUtil.isUtilityMethod(method, psiClass, framework)) {
            return null;
        }
        return TestDataGuessByExistingFilesUtil.getTestName(method.getName());
    }

    private static boolean isUtilityMethod(@NotNull PsiMethod method, @NotNull PsiClass psiClass, @NotNull TestFramework framework) {
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(10);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(11);
        }
        if (framework == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(12);
        }
        if (method == framework.findSetUpMethod((PsiElement)psiClass) || method == framework.findTearDownMethod((PsiElement)psiClass)) {
            return true;
        }
        if (framework.getClass().getName().contains("JUnit3")) {
            return !method.getName().startsWith("test");
        }
        if (framework.getClass().getName().contains("JUnit4")) {
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (int)0);
        }
        return false;
    }

    @NotNull
    public static String getTestName(@NotNull String methodName) {
        if (methodName == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(13);
        }
        String string = StringUtil.trimStart((String)methodName, (String)"test");
        if (string == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static TestDataDescriptor buildDescriptorFromExistingTestData(@NotNull PsiMethod method, @Nullable String testDataPath) {
        if (method == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(15);
        }
        TestDataDescriptor testDataDescriptor = (TestDataDescriptor)CachedValuesManager.getCachedValue((PsiElement)method, () -> new CachedValueProvider.Result((Object)TestDataGuessByExistingFilesUtil.buildDescriptor(method, testDataPath), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (testDataDescriptor == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(16);
        }
        return testDataDescriptor;
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull PsiMethod psiMethod, @Nullable String testDataPath) {
        if (psiMethod == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(17);
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class);
        String testName = TestDataGuessByExistingFilesUtil.getTestName(psiMethod);
        if (testName == null || psiClass == null) {
            TestDataDescriptor testDataDescriptor = TestDataDescriptor.NOTHING_FOUND;
            if (testDataDescriptor == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(18);
            }
            return testDataDescriptor;
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass, testDataPath);
    }

    public static List<TestDataFile> suggestTestDataFiles(@NotNull String testName, String testDataPath, @NotNull PsiClass psiClass) {
        if (testName == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(19);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(20);
        }
        return TestDataGuessByExistingFilesUtil.buildDescriptor(testName, psiClass, testDataPath).restoreFiles();
    }

    @NotNull
    private static TestDataDescriptor buildDescriptor(@NotNull String test, @NotNull PsiClass psiClass, @Nullable String testDataPath) {
        if (test == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(21);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(22);
        }
        String normalizedTestDataPath = testDataPath == null ? null : StringUtil.trimEnd((String)StringUtil.trimEnd((String)testDataPath, (String)"/"), (String)"\\");
        String possibleFileName = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)test, (String)"$"), (Object)test);
        assert (possibleFileName != null);
        if (possibleFileName.isEmpty()) {
            TestDataDescriptor testDataDescriptor = TestDataDescriptor.NOTHING_FOUND;
            if (testDataDescriptor == null) {
                TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(23);
            }
            return testDataDescriptor;
        }
        Project project = psiClass.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        GotoFileModel gotoModel = new GotoFileModel(project);
        String possibleFilePath = test.replace('$', '/');
        HashMap<String, SmartList> descriptorsByFileNames = new HashMap<String, SmartList>();
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        Collection<String> fileNames = TestDataGuessByExistingFilesUtil.getAllFileNames(possibleFileName, gotoModel);
        ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        indicator.setText("Searching for '" + test + "' test data files...");
        indicator.setIndeterminate(false);
        int fileNamesCount = fileNames.size();
        double currentIndex = 0.0;
        for (String name : fileNames) {
            Object[] elements;
            ProgressManager.checkCanceled();
            for (Object element : elements = gotoModel.getElementsByName(name, false, name)) {
                String fileName;
                int i;
                String filePath;
                VirtualFile file;
                VirtualFile directoryVirtualFile;
                String normalizedDirPath;
                PsiFileSystemItem containingDirectory;
                if (!(element instanceof PsiFileSystemItem)) continue;
                PsiFileSystemItem psiFile = (PsiFileSystemItem)element;
                if (normalizedTestDataPath != null && (containingDirectory = psiFile.getParent()) != null && !(normalizedDirPath = StringUtil.trimEnd((String)StringUtil.trimEnd((String)(directoryVirtualFile = containingDirectory.getVirtualFile()).getPath(), (String)"/"), (String)"\\")).startsWith(normalizedTestDataPath) || (file = psiFile.getVirtualFile()) == null || fileIndex.isInSource(file) && !fileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.RESOURCES) || !StringUtil.containsIgnoreCase((String)(filePath = file.getPath()), (String)possibleFilePath) && !StringUtil.containsIgnoreCase((String)filePath, (String)test) || (i = (fileName = StringUtil.toLowerCase((String)PathUtil.getFileName((String)filePath))).indexOf(StringUtil.toLowerCase((String)possibleFileName))) < 0 || i + possibleFileName.length() < fileName.length() && Character.isDigit(fileName.charAt(i + possibleFileName.length()))) continue;
                SmartList currentDescriptors = new SmartList();
                VfsUtilCore.processFilesRecursively((VirtualFile)file, arg_0 -> TestDataGuessByExistingFilesUtil.lambda$buildDescriptor$3(possibleFileName, project, module, (List)currentDescriptors, arg_0));
                if (currentDescriptors.isEmpty()) continue;
                List previousDescriptors = (List)descriptorsByFileNames.get(name);
                if (previousDescriptors == null) {
                    descriptorsByFileNames.put(name, currentDescriptors);
                    continue;
                }
                if (!TestDataGuessByExistingFilesUtil.moreRelevantPath((TestLocationDescriptor)currentDescriptors.get(0), (TestLocationDescriptor)previousDescriptors.get(0), psiClass)) continue;
                descriptorsByFileNames.put(name, currentDescriptors);
            }
            indicator.setFraction((currentIndex += 1.0) / (double)fileNamesCount);
        }
        List descriptors = ContainerUtil.flatten(descriptorsByFileNames.values());
        TestDataGuessByExistingFilesUtil.filterDirsFromOtherModules(descriptors);
        return new TestDataDescriptor(descriptors);
    }

    private static Collection<String> getAllFileNames(final String testName, GotoFileModel model) {
        CommonProcessors.CollectProcessor<String> processor = new CommonProcessors.CollectProcessor<String>(){

            public boolean accept(String name) {
                ProgressManager.checkCanceled();
                return StringUtil.containsIgnoreCase((String)name, (String)testName);
            }
        };
        model.processNames((Processor)processor, FindSymbolParameters.simple((Project)model.getProject(), (boolean)false));
        return processor.getResults();
    }

    private static void filterDirsFromOtherModules(List<TestLocationDescriptor> descriptorsByFileNames) {
        if (descriptorsByFileNames.size() < 2) {
            return;
        }
        if (descriptorsByFileNames.stream().noneMatch(descriptor -> descriptor.isFromCurrentModule)) {
            return;
        }
        descriptorsByFileNames.removeIf(d -> !d.isFromCurrentModule);
    }

    @Nullable
    private static String getSimpleClassName(@NotNull PsiClass psiClass) {
        String result;
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(24);
        }
        if ((result = psiClass.getQualifiedName()) == null) {
            return null;
        }
        int i = (result = StringUtil.trimEnd((String)result, (String)"Test")).lastIndexOf(46);
        if (i >= 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    private static boolean moreRelevantPath(@NotNull TestLocationDescriptor candidate, @NotNull TestLocationDescriptor current, @NotNull PsiClass psiClass) {
        boolean currentMatched;
        String packageAsPath;
        boolean candidateMatched;
        String className;
        if (candidate == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(25);
        }
        if (current == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(26);
        }
        if (psiClass == null) {
            TestDataGuessByExistingFilesUtil.$$$reportNull$$$0(27);
        }
        if ((className = psiClass.getQualifiedName()) == null) {
            return false;
        }
        int lastDotIndex = className.lastIndexOf(".");
        String candidateLcDir = StringUtil.toLowerCase((String)candidate.pathPrefix);
        String currentLcDir = StringUtil.toLowerCase((String)current.pathPrefix);
        if (lastDotIndex >= 0 && (candidateMatched = candidateLcDir.contains(packageAsPath = StringUtil.toLowerCase((String)className.substring(0, lastDotIndex).replace('.', '/')))) ^ (currentMatched = currentLcDir.contains(packageAsPath))) {
            return candidateMatched;
        }
        String simpleName = TestDataGuessByExistingFilesUtil.getSimpleClassName(psiClass);
        if (simpleName == null) {
            return false;
        }
        String pattern = StringUtil.toLowerCase((String)simpleName);
        candidateMatched = candidateLcDir.contains(pattern);
        if (candidateMatched ^ (currentMatched = currentLcDir.contains(pattern))) {
            return candidateMatched;
        }
        String[] words = NameUtil.nameToWords((String)simpleName);
        int candidateWordsMatched = 0;
        int currentWordsMatched = 0;
        int candidateMatchPosition = -1;
        int currentMatchPosition = -1;
        StringBuilder currentNameSubstringSb = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            int currentWordsIndex;
            currentNameSubstringSb.append(words[i]);
            String currentNameLcSubstring = StringUtil.toLowerCase((String)currentNameSubstringSb.toString());
            int candidateWordsIndex = candidateLcDir.lastIndexOf(currentNameLcSubstring);
            if (candidateWordsIndex > 0) {
                candidateWordsMatched = i + 1;
                candidateMatchPosition = candidateWordsIndex;
            }
            if ((currentWordsIndex = currentLcDir.lastIndexOf(currentNameLcSubstring)) > 0) {
                currentWordsMatched = i + 1;
                currentMatchPosition = currentWordsIndex;
            }
            if (candidateWordsMatched != currentWordsMatched) break;
        }
        if (candidateWordsMatched != currentWordsMatched) {
            return candidateWordsMatched > currentWordsMatched;
        }
        return candidateMatchPosition > currentMatchPosition;
    }

    private static /* synthetic */ boolean lambda$buildDescriptor$3(String possibleFileName, Project project, Module module, List currentDescriptors, VirtualFile f) {
        if (f.isDirectory()) {
            return true;
        }
        TestLocationDescriptor current = TestLocationDescriptor.create(possibleFileName, f, project, module);
        if (current != null) {
            currentDescriptors.add(current);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil";
                break;
            }
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataByExistingFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTestDataName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTestDataBySiblingTest";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescriptorFromExistingTestData";
                break;
            }
            case 18: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataByExistingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUtilityMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptorFromExistingTestData";
                break;
            }
            case 17: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestTestDataFiles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleClassName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moreRelevantPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestDataDescriptor {
        private static final TestDataDescriptor NOTHING_FOUND = new TestDataDescriptor(Collections.emptyList());
        private final List<TestLocationDescriptor> myDescriptors = new ArrayList<TestLocationDescriptor>();

        TestDataDescriptor(Collection<TestLocationDescriptor> descriptors) {
            this.myDescriptors.addAll(descriptors);
        }

        @NotNull
        public List<TestDataFile> restoreFiles() {
            List list = ContainerUtil.mapNotNull(this.myDescriptors, d -> {
                VirtualFile file = (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileById(d.matchedVFileId));
                return file == null ? null : new TestDataFile.Existing(file);
            });
            if (list == null) {
                TestDataDescriptor.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<TestDataFile> generateByTemplates(@NotNull String testName, @Nullable String root) {
            if (testName == null) {
                TestDataDescriptor.$$$reportNull$$$0(1);
            }
            ArrayList<TestDataFile> result = new ArrayList<TestDataFile>();
            if (StringUtil.isEmpty((String)testName)) {
                ArrayList<TestDataFile> arrayList = result;
                if (arrayList == null) {
                    TestDataDescriptor.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
            for (TestLocationDescriptor descriptor : this.myDescriptors) {
                if (root != null && !descriptor.pathPrefix.startsWith(root)) continue;
                result.add(new TestDataFile.NonExisting(descriptor.pathPrefix + (descriptor.startWithLowerCase ? StringUtil.decapitalize((String)testName) : StringUtil.capitalize((String)testName)) + descriptor.pathSuffix));
            }
            ArrayList<TestDataFile> arrayList = result;
            if (arrayList == null) {
                TestDataDescriptor.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        public String toString() {
            return this.myDescriptors.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "restoreFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestDataDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateByTemplates";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "generateByTemplates";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestLocationDescriptor {
        final String pathPrefix;
        final String pathSuffix;
        final boolean startWithLowerCase;
        final boolean isFromCurrentModule;
        final int matchedVFileId;

        private TestLocationDescriptor(String pathPrefix, String pathSuffix, boolean startWithLowerCase, boolean isFromCurrentModule, int id) {
            this.pathPrefix = pathPrefix;
            this.pathSuffix = pathSuffix;
            this.startWithLowerCase = startWithLowerCase;
            this.isFromCurrentModule = isFromCurrentModule;
            this.matchedVFileId = id;
        }

        static TestLocationDescriptor create(@NotNull String testName, @NotNull VirtualFile matched, @NotNull Project project, @Nullable Module module) {
            boolean startWithLowerCase;
            if (testName == null) {
                TestLocationDescriptor.$$$reportNull$$$0(0);
            }
            if (matched == null) {
                TestLocationDescriptor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                TestLocationDescriptor.$$$reportNull$$$0(2);
            }
            if (testName.isEmpty()) {
                return null;
            }
            String path = matched.getPath();
            int idx = StringUtil.indexOf((CharSequence)path, (CharSequence)testName);
            boolean capitalized = StringUtil.isCapitalized((String)testName);
            if (idx < 0) {
                testName = capitalized ? StringUtil.decapitalize((String)testName) : StringUtil.capitalize((String)testName);
                idx = StringUtil.indexOf((CharSequence)path, (CharSequence)testName);
                if (idx < 0) {
                    return null;
                }
                startWithLowerCase = capitalized;
            } else {
                startWithLowerCase = !capitalized;
            }
            String pathPrefix = path.substring(0, idx);
            String pathSuffix = path.substring(idx + testName.length());
            boolean isFromCurrentModule = false;
            if (module != null) {
                isFromCurrentModule = module.equals(ModuleUtilCore.findModuleForFile((VirtualFile)matched, (Project)project));
            }
            int matchedVFileId = ((VirtualFileWithId)matched).getId();
            return new TestLocationDescriptor(pathPrefix, pathSuffix, startWithLowerCase, isFromCurrentModule, matchedVFileId);
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.pathPrefix != null ? this.pathPrefix.hashCode() : 0);
            result = 31 * result + (this.pathSuffix != null ? this.pathSuffix.hashCode() : 0);
            result = 31 * result + (this.startWithLowerCase ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestLocationDescriptor that = (TestLocationDescriptor)o;
            if (this.startWithLowerCase != that.startWithLowerCase) {
                return false;
            }
            if (!Objects.equals(this.pathPrefix, that.pathPrefix)) {
                return false;
            }
            return Objects.equals(this.pathSuffix, that.pathSuffix);
        }

        public String toString() {
            return String.format("%s[...]%s", this.pathPrefix, this.pathSuffix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matched";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByExistingFilesUtil$TestLocationDescriptor";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

