/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public class ExtensionPointBinding {
    private final PsiClass myPsiClass;

    public ExtensionPointBinding(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExtensionPointBinding.$$$reportNull$$$0(0);
        }
        this.myPsiClass = psiClass;
    }

    public void visit(BindingVisitor visitor) {
        UClass beanClassNavigationClass = (UClass)UastContextKt.toUElement((PsiElement)this.myPsiClass.getNavigationElement(), UClass.class);
        PsiField[] fields = beanClassNavigationClass != null ? beanClassNavigationClass.getAllFields() : this.myPsiClass.getAllFields();
        for (PsiField field : fields) {
            String tagName;
            if (field.hasModifierProperty("static")) continue;
            PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)field);
            PsiMethod setter = PropertyUtilBase.findSetterForField((PsiField)field);
            if ((getter == null || setter == null) && !field.hasModifierProperty("public")) continue;
            boolean required = PsiUtil.findAnnotation(RequiredElement.class, new PsiMember[]{field, getter, setter}) != null;
            PsiAnnotation attributeAnnotation = PsiUtil.findAnnotation(Attribute.class, new PsiMember[]{field, getter, setter});
            if (attributeAnnotation != null) {
                String fieldName = PsiUtil.getAnnotationStringAttribute(attributeAnnotation, "value", field.getName());
                if (fieldName == null) continue;
                visitor.visitAttribute(field, fieldName, required);
                continue;
            }
            PsiAnnotation tagAnno = PsiUtil.findAnnotation(Tag.class, new PsiMember[]{field, getter, setter});
            PsiAnnotation collectionAnnotation = PsiUtil.findAnnotation(XCollection.class, new PsiMember[]{field, getter, setter});
            String fieldName = field.getName();
            if (tagAnno != null) {
                tagName = PsiUtil.getAnnotationStringAttribute(tagAnno, "value", fieldName);
            } else {
                PsiAnnotation propAnno = PsiUtil.findAnnotation(Property.class, new PsiMember[]{field, getter, setter});
                String string = tagName = propAnno != null && PsiUtil.getAnnotationBooleanAttribute(propAnno, "surroundWithTag") ? "option" : null;
            }
            if (tagName != null && collectionAnnotation == null) {
                visitor.visitTagOrProperty(field, tagName, required);
                continue;
            }
            if (collectionAnnotation == null) continue;
            visitor.visitXCollection(field, tagName, collectionAnnotation, required);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/references/extensions/ExtensionPointBinding", "<init>"));
    }

    public static interface BindingVisitor {
        public void visitAttribute(@NotNull PsiField var1, @NotNull String var2, boolean var3);

        public void visitTagOrProperty(@NotNull PsiField var1, @NotNull String var2, boolean var3);

        public void visitXCollection(@NotNull PsiField var1, @Nullable String var2, @NotNull PsiAnnotation var3, boolean var4);
    }
}

