/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.navigation.LineMarkerInfoHelper;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (element == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiField) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process((PsiField)element, result);
        }
    }

    private static void process(PsiField psiField, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        ExtensionPointType epType = ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(psiField);
        if (epType == ExtensionPointType.NONE) {
            return;
        }
        PsiClass epClass = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveExtensionPointClass(psiField, epType);
        if (epClass == null) {
            return;
        }
        String epName = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpName(psiField);
        if (epName == null) {
            return;
        }
        ExtensionPointLocator locator = new ExtensionPointLocator(epClass);
        List targets = ContainerUtil.filter(locator.findDirectCandidates(), candidate -> epName.equals(candidate.epName));
        if (targets.isEmpty()) {
            return;
        }
        RelatedItemLineMarkerInfo<PsiElement> info = LineMarkerInfoHelper.createExtensionPointLineMarkerInfo(targets, (PsiElement)psiField.getNameIdentifier());
        result.add(info);
    }

    @Nullable
    private static PsiClass resolveExtensionPointClass(PsiField psiField, ExtensionPointType epType) {
        PsiType epNameType = PsiUtil.substituteTypeParameter((PsiType)psiField.getType(), (String)epType.qualifiedClassName, (int)0, (boolean)false);
        if (!(epNameType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)epNameType;
        PsiClass typePsiClass = PsiTypesUtil.getPsiClass((PsiType)classType);
        if (classType.getParameterCount() != 1) {
            return typePsiClass;
        }
        if (typePsiClass == null || !KeyedLazyInstance.class.getName().equals(typePsiClass.getQualifiedName())) {
            return null;
        }
        PsiType keyedLazyInstanceType = PsiUtil.substituteTypeParameter((PsiType)epNameType, (PsiClass)typePsiClass, (int)0, (boolean)false);
        return PsiTypesUtil.getPsiClass((PsiType)keyedLazyInstanceType);
    }

    private static String resolveEpName(PsiField psiField) {
        PsiExpression initializer = psiField.getInitializer();
        PsiExpressionList expressionList = null;
        if (initializer instanceof PsiMethodCallExpression) {
            expressionList = ((PsiMethodCallExpression)initializer).getArgumentList();
        } else if (initializer instanceof PsiNewExpression) {
            expressionList = ((PsiNewExpression)initializer).getArgumentList();
        }
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression epNameExpression = expressions[0];
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        Object o = helper.computeConstantExpression((PsiElement)epNameExpression);
        return o instanceof String ? (String)o : null;
    }

    private static ExtensionPointType isExtensionPointNameDeclarationField(PsiField psiField) {
        if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("static") || psiField.hasModifierProperty("abstract")) {
            return ExtensionPointType.NONE;
        }
        if (!psiField.hasInitializer()) {
            return ExtensionPointType.NONE;
        }
        PsiExpression initializer = psiField.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression) && !(initializer instanceof PsiNewExpression)) {
            return ExtensionPointType.NONE;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)psiField.getType());
        if (fieldClass == null) {
            return ExtensionPointType.NONE;
        }
        String qualifiedClassName = fieldClass.getQualifiedName();
        return ExtensionPointType.find(qualifiedClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ExtensionPointType {
        NONE(""),
        APPLICATION(ExtensionPointName.class.getName()),
        PROJECT(ProjectExtensionPointName.class.getName());

        private final String qualifiedClassName;

        private ExtensionPointType(String qualifiedClassName) {
            this.qualifiedClassName = qualifiedClassName;
        }

        static ExtensionPointType find(String qualifiedClassName) {
            if (ExtensionPointType.APPLICATION.qualifiedClassName.equals(qualifiedClassName)) {
                return APPLICATION;
            }
            if (ExtensionPointType.PROJECT.qualifiedClassName.equals(qualifiedClassName)) {
                return PROJECT;
            }
            return NONE;
        }
    }
}

