/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NotNull;

public class ConvertToJBColorQuickFix
implements LocalQuickFix {
    public @IntentionFamilyName @NotNull String getFamilyName() {
        return "Convert to JBColor";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ConvertToJBColorQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            ConvertToJBColorQuickFix.$$$reportNull$$$0(1);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newJBColor = String.format("new %s(%s, new java.awt.Color())", JBColor.class.getName(), element.getText());
        PsiExpression expression = factory.createExpressionFromText(newJBColor, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
        int offset = el.getTextOffset() + el.getText().length() - 2;
        Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBColorQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

