/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ModelFactory;
import org.jetbrains.plugins.gradle.tooling.util.BiFunction;
import org.jetbrains.plugins.gradle.tooling.util.BooleanBiFunction;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public abstract class AbstractExternalDependency
implements ExternalDependency {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final DefaultExternalDependencyId myId;
    private String myScope;
    private final Collection<ExternalDependency> myDependencies;
    private String mySelectionReason;
    private int myClasspathOrder;
    private boolean myExported;

    public AbstractExternalDependency() {
        this((ExternalDependencyId)new DefaultExternalDependencyId(), null, null);
    }

    public AbstractExternalDependency(ExternalDependencyId id, String selectionReason, Collection<? extends ExternalDependency> dependencies) {
        this.myId = new DefaultExternalDependencyId(id);
        this.mySelectionReason = selectionReason;
        this.myDependencies = dependencies == null ? new ArrayList(0) : ModelFactory.createCopy(dependencies);
    }

    public AbstractExternalDependency(ExternalDependency dependency) {
        this(dependency.getId(), dependency.getSelectionReason(), dependency.getDependencies());
        this.myScope = dependency.getScope();
        this.myClasspathOrder = dependency.getClasspathOrder();
        this.myExported = dependency.getExported();
    }

    @NotNull
    public ExternalDependencyId getId() {
        DefaultExternalDependencyId defaultExternalDependencyId = this.myId;
        if (defaultExternalDependencyId == null) {
            AbstractExternalDependency.$$$reportNull$$$0(0);
        }
        return defaultExternalDependencyId;
    }

    public String getName() {
        return this.myId.getName();
    }

    public void setName(String name) {
        this.myId.setName(name);
    }

    public String getGroup() {
        return this.myId.getGroup();
    }

    public void setGroup(String group) {
        this.myId.setGroup(group);
    }

    public String getVersion() {
        return this.myId.getVersion();
    }

    public void setVersion(String version) {
        this.myId.setVersion(version);
    }

    @NotNull
    public String getPackaging() {
        String string = this.myId.getPackaging();
        if (string == null) {
            AbstractExternalDependency.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setPackaging(@NotNull String packaging) {
        if (packaging == null) {
            AbstractExternalDependency.$$$reportNull$$$0(2);
        }
        this.myId.setPackaging(packaging);
    }

    @Nullable
    public String getClassifier() {
        return this.myId.getClassifier();
    }

    public void setClassifier(@Nullable String classifier) {
        this.myId.setClassifier(classifier);
    }

    @Nullable
    public String getSelectionReason() {
        return this.mySelectionReason;
    }

    public int getClasspathOrder() {
        return this.myClasspathOrder;
    }

    public void setClasspathOrder(int order) {
        this.myClasspathOrder = order;
    }

    public void setSelectionReason(String selectionReason) {
        this.mySelectionReason = selectionReason;
    }

    public String getScope() {
        return this.myScope;
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    @NotNull
    public Collection<ExternalDependency> getDependencies() {
        Collection<ExternalDependency> collection = this.myDependencies;
        if (collection == null) {
            AbstractExternalDependency.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean getExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExternalDependency)) {
            return false;
        }
        AbstractExternalDependency that = (AbstractExternalDependency)o;
        return Objects.equal((Object)this.myId, (Object)that.myId) && Objects.equal((Object)this.myScope, (Object)that.myScope) && this.myClasspathOrder == that.myClasspathOrder && AbstractExternalDependency.equal(this.myDependencies, that.myDependencies);
    }

    private static boolean equal(@NotNull Collection<ExternalDependency> dependencies1, @NotNull Collection<ExternalDependency> dependencies2) {
        if (dependencies1 == null) {
            AbstractExternalDependency.$$$reportNull$$$0(4);
        }
        if (dependencies2 == null) {
            AbstractExternalDependency.$$$reportNull$$$0(5);
        }
        final DependenciesIterator iterator1 = new DependenciesIterator(dependencies1);
        final DependenciesIterator iterator2 = new DependenciesIterator(dependencies2);
        return GradleContainerUtil.match((Iterator)iterator1, (Iterator)iterator2, (BooleanBiFunction)new BooleanBiFunction<AbstractExternalDependency, AbstractExternalDependency>(){

            public Boolean fun(AbstractExternalDependency o1, AbstractExternalDependency o2) {
                if (!Objects.equal((Object)iterator1.myProcessedStructure, (Object)iterator2.myProcessedStructure)) {
                    return false;
                }
                return Objects.equal((Object)o1.myId, (Object)o2.myId) && Objects.equal((Object)o1.myScope, (Object)o2.myScope);
            }
        });
    }

    public int hashCode() {
        return 31 + Objects.hashCode((Object[])new Object[]{this.myId, this.myScope, this.myClasspathOrder});
    }

    protected static int calcFilesPathsHashCode(@NotNull Iterable<File> iterable) {
        if (iterable == null) {
            AbstractExternalDependency.$$$reportNull$$$0(6);
        }
        return (Integer)GradleContainerUtil.reduce(iterable, (Object)0, (BiFunction)new BiFunction<Integer, Integer, File>(){

            public Integer fun(Integer currentResult, File item) {
                return 31 * currentResult + (item == null ? 0 : item.getPath().hashCode());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/AbstractExternalDependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packaging";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackaging";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/AbstractExternalDependency";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPackaging";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcFilesPathsHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependenciesIterator
    implements Iterator<AbstractExternalDependency> {
        private final Set<AbstractExternalDependency> mySeenDependencies;
        private final LinkedList<ExternalDependency> myToProcess;
        private final LinkedList<Integer> myProcessedStructure;

        private DependenciesIterator(@NotNull Collection<ExternalDependency> dependencies) {
            if (dependencies == null) {
                DependenciesIterator.$$$reportNull$$$0(0);
            }
            this.mySeenDependencies = new THashSet(TObjectHashingStrategy.IDENTITY);
            this.myToProcess = new LinkedList<ExternalDependency>(dependencies);
            this.myProcessedStructure = new LinkedList();
        }

        @Override
        public boolean hasNext() {
            AbstractExternalDependency dependency = (AbstractExternalDependency)this.myToProcess.peekFirst();
            if (dependency == null) {
                return false;
            }
            if (this.mySeenDependencies.contains(dependency)) {
                this.myToProcess.removeFirst();
                return this.hasNext();
            }
            return !this.myToProcess.isEmpty();
        }

        @Override
        public AbstractExternalDependency next() {
            AbstractExternalDependency dependency = (AbstractExternalDependency)this.myToProcess.removeFirst();
            if (this.mySeenDependencies.add(dependency)) {
                this.myToProcess.addAll(dependency.myDependencies);
                this.myProcessedStructure.add(dependency.myDependencies.size());
                return dependency;
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/plugins/gradle/model/AbstractExternalDependency$DependenciesIterator", "<init>"));
        }
    }
}

