/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrAllVarsInitializedPolicy;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.FragmentVariableInfos;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsCollector;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public final class GroovyExtractChooser {
    private static final Logger LOG = Logger.getInstance(GroovyExtractChooser.class);

    public static InitialInfo invoke(Project project, Editor editor, PsiFile file, int start, int end, boolean forceStatements) throws GrRefactoringError {
        GrExpression initializer;
        GrVariable variable;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!(file instanceof GroovyFileBase)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("only.in.groovy.files", new Object[0]));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            throw new GrRefactoringError(RefactoringBundle.message((String)"readonly.occurences.found"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        StringPartInfo stringPart = StringPartInfo.findStringPart(file, start, end);
        if (stringPart != null) {
            return new InitialInfo(VariableInfo.EMPTY_ARRAY, VariableInfo.EMPTY_ARRAY, PsiElement.EMPTY_ARRAY, GrStatement.EMPTY_ARRAY, new ArrayList<GrStatement>(), stringPart, project, null);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!forceStatements && (variable = GrIntroduceHandlerBase.findVariable(file, start, end)) != null && (initializer = variable.getInitializerGroovy()) != null) {
            TextRange range = initializer.getTextRange();
            return GroovyExtractChooser.buildInfo(project, file, range.getStartOffset(), range.getEndOffset(), forceStatements, selectionModel, variable);
        }
        return GroovyExtractChooser.buildInfo(project, file, start, end, forceStatements, selectionModel, null);
    }

    @NotNull
    private static InitialInfo buildInfo(@NotNull Project project, @NotNull PsiFile file, int start, int end, boolean forceStatements, @NotNull SelectionModel selectionModel, @Nullable GrVariable variable) throws GrRefactoringError {
        PsiElement[] elements;
        GrStatement[] statements2;
        if (project == null) {
            GroovyExtractChooser.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GroovyExtractChooser.$$$reportNull$$$0(1);
        }
        if (selectionModel == null) {
            GroovyExtractChooser.$$$reportNull$$$0(2);
        }
        if ((statements2 = GroovyExtractChooser.getStatementsByElements(elements = GroovyExtractChooser.getElementsInOffset(file, start, end, forceStatements))).length == 0) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.block.should.represent.a.statement.set", new Object[0]));
        }
        for (GrStatement statement : statements2) {
            if (!GroovyRefactoringUtil.isSuperOrThisCall(statement, true, true)) continue;
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.block.contains.invocation.of.another.class.constructor", new Object[0]));
        }
        GrStatement statement0 = statements2[0];
        PsiClass owner = PsiUtil.getContextClass(statement0);
        GrStatementOwner declarationOwner = GroovyRefactoringUtil.getDeclarationOwner(statement0);
        if (owner == null || declarationOwner == null && !ExtractUtil.isSingleExpression(statements2)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.in.the.current.context", new Object[0]));
        }
        if (declarationOwner == null && ExtractUtil.isSingleExpression(statements2) && statement0 instanceof GrExpression && PsiType.VOID.equals((Object)((GrExpression)statement0).getType())) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.expression.has.void.type", new Object[0]));
        }
        if (ExtractUtil.isSingleExpression(statements2) && GrIntroduceHandlerBase.expressionIsIncorrect((GrExpression)statement0, true)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.block.should.represent.an.expression", new Object[0]));
        }
        if (ExtractUtil.isSingleExpression(statements2) && statement0.getParent() instanceof GrAssignmentExpression && ((GrAssignmentExpression)statement0.getParent()).getLValue() == statement0) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.expression.should.not.be.lvalue", new Object[0]));
        }
        HashSet<GrStatement> allReturnStatements = new HashSet<GrStatement>();
        GrControlFlowOwner controlFlowOwner = ControlFlowUtils.findControlFlowOwner(statement0);
        LOG.assertTrue(controlFlowOwner != null);
        Instruction[] flow = new ControlFlowBuilder(GrAllVarsInitializedPolicy.getInstance()).buildControlFlow(controlFlowOwner);
        allReturnStatements.addAll(ControlFlowUtils.collectReturns(flow, true));
        ArrayList<GrStatement> returnStatements = new ArrayList<GrStatement>();
        block1: for (GrStatement returnStatement : allReturnStatements) {
            for (GrStatement statement : statements2) {
                if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)returnStatement, (boolean)false)) continue;
                returnStatements.add(returnStatement);
                continue block1;
            }
        }
        FragmentVariableInfos fragmentVariableInfos = ReachingDefinitionsCollector.obtainVariableFlowInformation(statement0, statements2[statements2.length - 1], controlFlowOwner, flow);
        VariableInfo[] inputInfos = fragmentVariableInfos.getInputVariableNames();
        VariableInfo[] outputInfos = fragmentVariableInfos.getOutputVariableNames();
        if (outputInfos.length == 1 && !returnStatements.isEmpty()) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("multiple.output.values", new Object[0]));
        }
        boolean hasInterruptingStatements = false;
        for (GrStatement statement : statements2) {
            boolean bl = hasInterruptingStatements = GroovyRefactoringUtil.hasWrongBreakStatements(statement) || GroovyRefactoringUtil.hasWrongContinueStatements(statement);
            if (hasInterruptingStatements) break;
        }
        boolean hasReturns = !returnStatements.isEmpty();
        ArrayList<GrStatement> returnStatementsCopy = new ArrayList<GrStatement>(returnStatements.size());
        returnStatementsCopy.addAll(returnStatements);
        boolean isReturnStatement = GroovyExtractChooser.isReturnStatement(statements2[statements2.length - 1], returnStatementsCopy);
        boolean isLastStatementOfMethod = GroovyExtractChooser.isLastStatementOfMethodOrClosure(statements2);
        if (hasReturns && !isLastStatementOfMethod && !isReturnStatement || hasInterruptingStatements) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", new Object[0]));
        }
        return new InitialInfo(inputInfos, outputInfos, elements, statements2, returnStatements, null, project, variable);
    }

    private static boolean isLastStatementOfMethodOrClosure(GrStatement[] statements2) {
        GrStatement statement0 = statements2[0];
        PsiElement returnFrom = PsiTreeUtil.getParentOfType((PsiElement)statement0, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class, GroovyFile.class});
        if (returnFrom instanceof GrMethod) {
            returnFrom = ((GrMethod)returnFrom).getBlock();
        }
        LOG.assertTrue(returnFrom instanceof GrStatementOwner);
        Object[] blockStatements = ((GrStatementOwner)returnFrom).getStatements();
        GrStatement lastFromBlock = (GrStatement)ArrayUtil.getLastElement((Object[])blockStatements);
        GrStatement lastStatement = (GrStatement)ArrayUtil.getLastElement((Object[])statements2);
        return statement0.getManager().areElementsEquivalent((PsiElement)lastFromBlock, (PsiElement)lastStatement);
    }

    private static GrStatement[] getStatementsByElements(PsiElement[] elements) {
        ArrayList<GrStatement> statementList = new ArrayList<GrStatement>();
        for (PsiElement element : elements) {
            if (!(element instanceof GrStatement)) continue;
            statementList.add((GrStatement)element);
        }
        return statementList.toArray(GrStatement.EMPTY_ARRAY);
    }

    private static PsiElement[] getElementsInOffset(PsiFile file, int startOffset, int endOffset, boolean forceStatements) {
        GrExpression expr = PsiImplUtil.findElementInRange(file, startOffset, endOffset, GrExpression.class);
        if (!forceStatements && expr != null) {
            return new PsiElement[]{expr};
        }
        if (expr == null) {
            return GroovyRefactoringUtil.findStatementsInRange(file, startOffset, endOffset, true);
        }
        if (expr.getParent() instanceof GrMethodCallExpression) {
            expr = (GrExpression)expr.getParent();
        }
        return new PsiElement[]{expr};
    }

    private static boolean isReturnStatement(GrStatement statement, Collection<GrStatement> returnStatements) {
        if (statement instanceof GrReturnStatement) {
            return true;
        }
        if (statement instanceof GrIfStatement) {
            boolean checked = GroovyInlineMethodUtil.checkTailIfStatement((GrIfStatement)statement, returnStatements);
            return checked & returnStatements.isEmpty();
        }
        if (statement instanceof GrExpression) {
            return returnStatements.contains(statement);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "selectionModel";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/extract/GroovyExtractChooser";
        objectArray[2] = "buildInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

