/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ArgumentListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.LocalVarAnalyzer;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public final class GenerationUtil {
    private static final Logger LOG = Logger.getInstance(GenerationUtil.class);
    private static final Map<IElementType, Pair<String, IElementType>> binOpTypes = new HashMap<IElementType, Pair<String, IElementType>>();

    private GenerationUtil() {
    }

    public static void writeTypeParameters(StringBuilder builder, PsiType[] parameters2, PsiElement context, ClassNameProvider classNameProvider) {
        if (parameters2.length == 0) {
            return;
        }
        builder.append('<');
        for (PsiType parameter : parameters2) {
            if (parameter instanceof PsiPrimitiveType) {
                parameter = TypesUtil.boxPrimitiveType(parameter, context.getManager(), context.getResolveScope(), true);
            }
            TypeWriter.writeType(builder, parameter, context, classNameProvider);
            builder.append(", ");
        }
        builder.delete(builder.length() - 2, builder.length()).append('>');
    }

    static String suggestVarName(GrExpression expr, ExpressionContext expressionContext) {
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(expr, expressionContext.myUsedVarNames, true);
        String[] varNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, nameValidator);
        LOG.assertTrue(varNames.length > 0);
        expressionContext.myUsedVarNames.add(varNames[0]);
        return varNames[0];
    }

    static String suggestVarName(PsiType type2, GroovyPsiElement context, ExpressionContext expressionContext) {
        String[] varNames;
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(context, expressionContext.myUsedVarNames, true, true);
        if (type2 instanceof PsiPrimitiveType) {
            type2 = TypesUtil.boxPrimitiveType(type2, context.getManager(), context.getResolveScope());
        }
        LOG.assertTrue((varNames = GroovyNameSuggestionUtil.suggestVariableNameByType(type2, nameValidator)).length > 0);
        expressionContext.myUsedVarNames.add(varNames[0]);
        return varNames[0];
    }

    public static String validateName(String name, GroovyPsiElement context, ExpressionContext expressionContext) {
        return new DefaultGroovyVariableNameValidator(context, expressionContext.myUsedVarNames, true).validateName(name, true);
    }

    public static void writeCodeReferenceElement(StringBuilder builder, GrCodeReferenceElement referenceElement) {
        GroovyResolveResult resolveResult2 = referenceElement.advancedResolve();
        PsiElement resolved = resolveResult2.getElement();
        if (resolved == null) {
            builder.append(referenceElement.getText());
            return;
        }
        LOG.assertTrue(resolved instanceof PsiClass || resolved instanceof PsiPackage);
        if (resolved instanceof PsiClass) {
            builder.append(((PsiClass)resolved).getQualifiedName());
        } else {
            builder.append(((PsiPackage)resolved).getQualifiedName());
        }
        GenerationUtil.writeTypeParameters(builder, referenceElement.getTypeArguments(), referenceElement, new GeneratorClassNameProvider());
    }

    public static void invokeMethodByName(@Nullable GrExpression caller, @NotNull String methodName, GrExpression @NotNull [] exprs, GrNamedArgument @NotNull [] namedArgs, GrClosableBlock @NotNull [] closureArgs, @NotNull ExpressionGenerator expressionGenerator, @NotNull GroovyPsiElement psiContext) {
        if (methodName == null) {
            GenerationUtil.$$$reportNull$$$0(0);
        }
        if (expressionGenerator == null) {
            GenerationUtil.$$$reportNull$$$0(1);
        }
        if (psiContext == null) {
            GenerationUtil.$$$reportNull$$$0(2);
        }
        if (exprs == null) {
            GenerationUtil.$$$reportNull$$$0(3);
        }
        if (namedArgs == null) {
            GenerationUtil.$$$reportNull$$$0(4);
        }
        if (closureArgs == null) {
            GenerationUtil.$$$reportNull$$$0(5);
        }
        GroovyResolveResult call = GenerationUtil.resolveMethod(caller, methodName, exprs, namedArgs, closureArgs, psiContext);
        GenerationUtil.invokeMethodByResolveResult(caller, call, methodName, exprs, namedArgs, closureArgs, expressionGenerator, psiContext);
    }

    @NotNull
    public static GroovyResolveResult resolveMethod(@Nullable GrExpression caller, @NotNull String methodName, GrExpression @NotNull [] exprs, GrNamedArgument @NotNull [] namedArgs, GrClosableBlock @NotNull [] closureArgs, @NotNull GroovyPsiElement psiContext) {
        if (methodName == null) {
            GenerationUtil.$$$reportNull$$$0(6);
        }
        if (psiContext == null) {
            GenerationUtil.$$$reportNull$$$0(7);
        }
        if (exprs == null) {
            GenerationUtil.$$$reportNull$$$0(8);
        }
        if (namedArgs == null) {
            GenerationUtil.$$$reportNull$$$0(9);
        }
        if (closureArgs == null) {
            GenerationUtil.$$$reportNull$$$0(10);
        }
        GroovyResolveResult call = EmptyGroovyResolveResult.INSTANCE;
        PsiType type2 = caller == null ? GroovyPsiElementFactory.getInstance(psiContext.getProject()).createExpressionFromText("this", psiContext).getType() : caller.getType();
        if (type2 != null) {
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(namedArgs, exprs, closureArgs, false, null);
            GroovyResolveResult[] candidates = ResolveUtil.getMethodCandidates(type2, methodName, (PsiElement)psiContext, argumentTypes);
            call = PsiImplUtil.extractUniqueResult(candidates);
        }
        EmptyGroovyResolveResult emptyGroovyResolveResult = call;
        if (emptyGroovyResolveResult == null) {
            GenerationUtil.$$$reportNull$$$0(11);
        }
        return emptyGroovyResolveResult;
    }

    public static void invokeMethodByResolveResult(@Nullable GrExpression caller, @NotNull GroovyResolveResult resolveResult2, @NotNull String methodName, GrExpression @NotNull [] exprs, GrNamedArgument @NotNull [] namedArgs, GrClosableBlock @NotNull [] closureArgs, @NotNull ExpressionGenerator expressionGenerator, @NotNull GroovyPsiElement psiContext) {
        PsiElement resolved;
        if (resolveResult2 == null) {
            GenerationUtil.$$$reportNull$$$0(12);
        }
        if (methodName == null) {
            GenerationUtil.$$$reportNull$$$0(13);
        }
        if (expressionGenerator == null) {
            GenerationUtil.$$$reportNull$$$0(14);
        }
        if (psiContext == null) {
            GenerationUtil.$$$reportNull$$$0(15);
        }
        if (exprs == null) {
            GenerationUtil.$$$reportNull$$$0(16);
        }
        if (namedArgs == null) {
            GenerationUtil.$$$reportNull$$$0(17);
        }
        if (closureArgs == null) {
            GenerationUtil.$$$reportNull$$$0(18);
        }
        if ((resolved = resolveResult2.getElement()) instanceof PsiMethod) {
            PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
            expressionGenerator.invokeMethodOn((PsiMethod)resolved, caller, exprs, namedArgs, closureArgs, substitutor, psiContext);
            return;
        }
        StringBuilder builder = expressionGenerator.getBuilder();
        ExpressionContext expressionContext = expressionGenerator.getContext();
        if (caller != null) {
            caller.accept(expressionGenerator);
            builder.append('.');
        }
        builder.append(methodName);
        ArgumentListGenerator argumentListGenerator = new ArgumentListGenerator(builder, expressionContext);
        argumentListGenerator.generate(null, exprs, namedArgs, closureArgs, psiContext);
    }

    static void writeStatement(@NotNull StringBuilder codeBlockBuilder, @NotNull StringBuilder statementBuilder, @Nullable GrStatement statement, @Nullable ExpressionContext context) {
        boolean addParentheses;
        PsiElement parent2;
        if (codeBlockBuilder == null) {
            GenerationUtil.$$$reportNull$$$0(19);
        }
        if (statementBuilder == null) {
            GenerationUtil.$$$reportNull$$$0(20);
        }
        PsiElement psiElement = parent2 = statement == null ? null : statement.getParent();
        if (statement == null) {
            addParentheses = context != null && context.shouldInsertCurlyBrackets();
        } else {
            boolean bl = addParentheses = context != null && (context.shouldInsertCurlyBrackets() || !context.myStatements.isEmpty()) && parent2 instanceof GrControlStatement;
        }
        if (addParentheses) {
            codeBlockBuilder.append("{\n");
        }
        if (context != null) {
            GenerationUtil.insertStatementFromContextBefore(codeBlockBuilder, context);
        }
        codeBlockBuilder.append((CharSequence)statementBuilder);
        if (addParentheses) {
            codeBlockBuilder.append("}\n");
        }
    }

    public static void insertStatementFromContextBefore(StringBuilder codeBlockBuilder, ExpressionContext context) {
        for (String st : context.myStatements) {
            codeBlockBuilder.append(st).append('\n');
        }
    }

    public static void writeStatement(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrStatement statement, @NotNull StatementWriter writer) {
        if (builder == null) {
            GenerationUtil.$$$reportNull$$$0(21);
        }
        if (context == null) {
            GenerationUtil.$$$reportNull$$$0(22);
        }
        if (writer == null) {
            GenerationUtil.$$$reportNull$$$0(23);
        }
        StringBuilder statementBuilder = new StringBuilder();
        ExpressionContext statementContext = context.copy();
        writer.writeStatement(statementBuilder, statementContext);
        GenerationUtil.writeStatement(builder, statementBuilder, statement, statementContext);
    }

    @Nullable
    static PsiClass findAccessibleSuperClass(@NotNull PsiElement context, @NotNull PsiClass initialClass) {
        if (context == null) {
            GenerationUtil.$$$reportNull$$$0(24);
        }
        if (initialClass == null) {
            GenerationUtil.$$$reportNull$$$0(25);
        }
        HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
        PsiClass curClass = initialClass;
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
        while (curClass != null && !resolveHelper.isAccessible((PsiMember)curClass, context, null)) {
            if (visitedClasses.contains(curClass = curClass.getSuperClass())) {
                return null;
            }
            visitedClasses.add(curClass);
        }
        return curClass;
    }

    static void writeTypeParameters(StringBuilder text, PsiTypeParameterListOwner typeParameterListOwner, ClassNameProvider classNameProvider) {
        if (!typeParameterListOwner.hasTypeParameters()) {
            return;
        }
        text.append('<');
        PsiTypeParameter[] parameters2 = typeParameterListOwner.getTypeParameters();
        PsiTypeParameterList typeParameterList = typeParameterListOwner.getTypeParameterList();
        for (int i = 0; i < parameters2.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            PsiTypeParameter parameter = parameters2[i];
            text.append(parameter.getName());
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length <= 0) continue;
            text.append(" extends ");
            for (int j = 0; j < extendsListTypes.length; ++j) {
                if (j > 0) {
                    text.append(" & ");
                }
                TypeWriter.writeType(text, (PsiType)extendsListTypes[j], (PsiElement)typeParameterList, classNameProvider);
            }
        }
        text.append('>');
    }

    static void writeParameterList(@NotNull StringBuilder text, PsiParameter @NotNull [] parameters2, @NotNull ClassNameProvider classNameProvider, @Nullable ExpressionContext context) {
        if (text == null) {
            GenerationUtil.$$$reportNull$$$0(26);
        }
        if (classNameProvider == null) {
            GenerationUtil.$$$reportNull$$$0(27);
        }
        if (parameters2 == null) {
            GenerationUtil.$$$reportNull$$$0(28);
        }
        HashSet<String> usedNames = new HashSet<String>();
        text.append('(');
        int i = 0;
        while (i < parameters2.length) {
            PsiParameter parameter = parameters2[i];
            if (parameter == null) continue;
            if (parameter instanceof PsiCompiledElement) {
                parameter = (PsiParameter)((PsiCompiledElement)parameter).getMirror();
            }
            if (i > 0) {
                text.append(", ");
            }
            if (!classNameProvider.forStubs()) {
                ModifierListGenerator.writeModifiers(text, parameter.getModifierList(), ModifierListGenerator.JAVA_MODIFIERS, true);
            }
            if (context != null) {
                if (context.analyzedVars.toMakeFinal((PsiVariable)parameter) && !parameter.hasModifierProperty("final")) {
                    text.append("final").append(' ');
                }
                TypeWriter.writeType(text, context.typeProvider.getParameterType(parameter), (PsiElement)parameter, classNameProvider);
            } else {
                TypeWriter.writeType(text, parameter.getType(), (PsiElement)parameter, classNameProvider);
            }
            text.append(' ');
            text.append(GenerationUtil.generateUniqueName(usedNames, parameter.getName()));
            ++i;
        }
        text.append(')');
        text.append(' ');
    }

    private static String generateUniqueName(Set<String> usedNames, String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            name = "p";
        }
        while (!usedNames.add(name)) {
            name = name + "x";
        }
        return name;
    }

    static void writeThrowsList(StringBuilder text, PsiReferenceList throwsList, PsiClassType[] exceptions, ClassNameProvider classNameProvider) {
        if (exceptions.length <= 0) {
            return;
        }
        text.append("throws ");
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType exception = exceptions[i];
            if (i != 0) {
                text.append(',');
            }
            TypeWriter.writeType(text, (PsiType)exception, (PsiElement)throwsList, classNameProvider);
            text.append(' ');
        }
    }

    static String getTypeText(PsiType varType, PsiElement context) {
        StringBuilder builder = new StringBuilder();
        TypeWriter.writeType(builder, varType, context);
        return builder.toString();
    }

    public static void writeSimpleVarDeclaration(GrVariableDeclaration variableDeclaration, StringBuilder builder, ExpressionContext expressionContext) {
        GrVariable[] variables = variableDeclaration.getVariables();
        if (variables.length > 1 && variableDeclaration.getParent() instanceof GrControlStatement) {
            expressionContext.setInsertCurlyBrackets();
        }
        for (GrVariable variable : variables) {
            GenerationUtil.writeVariableSeparately(variable, builder, expressionContext);
            builder.append(";\n");
        }
        builder.delete(builder.length() - 1, builder.length());
    }

    static void writeVariableWithoutType(StringBuilder builder, ExpressionContext expressionContext, GrVariable variable, boolean wrapped, PsiType original) {
        builder.append(variable.getName());
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            builder.append(" = ");
            if (wrapped) {
                builder.append("new ").append("groovy.lang.Reference");
                if (original != null) {
                    builder.append('<');
                    TypeWriter.writeType(builder, original, variable, new GeneratorClassNameProvider());
                    builder.append('>');
                }
                builder.append('(');
            }
            if (GenerationUtil.isCastNeeded(original, initializer, expressionContext)) {
                builder.append('(');
                TypeWriter.writeType(builder, original, initializer);
                builder.append(')');
            }
            initializer.accept(new ExpressionGenerator(builder, expressionContext, original));
            if (wrapped) {
                builder.append(')');
            }
        }
    }

    private static boolean isCastNeeded(PsiType target, GrExpression initializer, ExpressionContext expressionContext) {
        if (target == null) {
            return false;
        }
        PsiType iType = GenerationUtil.getDeclaredType(initializer, expressionContext);
        if (iType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable((PsiType)target, (PsiType)iType)) {
            return false;
        }
        if (initializer instanceof GrLiteral) {
            Object value = ((GrLiteral)initializer).getValue();
            if (value instanceof BigDecimal && Double.isFinite(((BigDecimal)value).doubleValue())) {
                return !TypeConversionUtil.isAssignable((PsiType)target, (PsiType)PsiType.DOUBLE);
            }
            if (value instanceof String && ((String)value).length() == 1) {
                return !PsiType.CHAR.equals((Object)PsiPrimitiveType.getOptionallyUnboxedType((PsiType)target));
            }
        } else if (initializer instanceof GrListOrMap && target instanceof PsiArrayType) {
            GrListOrMap listOrMap = (GrListOrMap)initializer;
            return listOrMap.isMap();
        }
        return true;
    }

    static void writeVariableSeparately(GrVariable variable, StringBuilder builder, ExpressionContext expressionContext) {
        PsiType type2 = expressionContext.typeProvider.getVarType(variable);
        ModifierListGenerator.writeModifiers(builder, variable.getModifierList());
        PsiType originalType = type2;
        LocalVarAnalyzer.Result analyzedVars = expressionContext.analyzedVars;
        boolean wrapped = false;
        if (analyzedVars != null) {
            if (analyzedVars.toMakeFinal(variable) && !variable.hasModifierProperty("final")) {
                builder.append("final").append(' ');
            } else if (analyzedVars.toWrap(variable)) {
                builder.append("final").append(' ');
                type2 = JavaPsiFacade.getElementFactory((Project)expressionContext.project).createTypeFromText("groovy.lang.Reference<" + GenerationUtil.getTypeText(originalType, variable) + ">", (PsiElement)variable);
                wrapped = true;
            }
        }
        TypeWriter.writeType(builder, type2, variable);
        builder.append(' ');
        GenerationUtil.writeVariableWithoutType(builder, expressionContext, variable, wrapped, originalType);
    }

    public static Pair<String, IElementType> getBinaryOperatorType(IElementType op_assign) {
        return binOpTypes.get(op_assign);
    }

    public static String suggestMethodName(GroovyPsiElement place, String initialName, ExpressionContext context) {
        int count = 0;
        String name = initialName;
        Class[] classes2 = new Class[]{PsiMethod.class};
        Map<PsiMethod, String> setters = context.getSetters();
        while (setters.containsValue(name) || ResolveUtil.resolveExistingElement(place, new MethodResolverProcessor(name, place, false, null, null, null, true), classes2) != null) {
            name = initialName + count;
            ++count;
        }
        return name;
    }

    public static boolean isCastNeeded(@NotNull GrExpression qualifier, @NotNull PsiMember member, ExpressionContext context) {
        PsiType type2;
        PsiType declared;
        if (qualifier == null) {
            GenerationUtil.$$$reportNull$$$0(29);
        }
        if (member == null) {
            GenerationUtil.$$$reportNull$$$0(30);
        }
        if ((declared = GenerationUtil.getDeclaredType(qualifier, context)) == null) {
            return false;
        }
        CheckProcessElement checker = new CheckProcessElement((PsiElement)member);
        if (ResolveUtil.resolvesToClass(qualifier) && (type2 = ResolveUtil.unwrapClassType(declared)) != null) {
            ResolveUtil.processAllDeclarations(type2, (PsiScopeProcessor)checker, false, (PsiElement)qualifier);
            if (checker.isFound()) {
                return false;
            }
        }
        ResolveUtil.processAllDeclarations(declared, (PsiScopeProcessor)checker, false, (PsiElement)qualifier);
        return !checker.isFound();
    }

    @Nullable
    public static PsiType getDeclaredType(@Nullable GrExpression expression, ExpressionContext context) {
        if (expression instanceof GrReferenceExpression) {
            GroovyResolveResult resolveResult2 = ((GrReferenceExpression)expression).advancedResolve();
            PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
            PsiElement resolved = resolveResult2.getElement();
            if (resolved instanceof PsiVariable) {
                return substitutor.substitute(context.typeProvider.getVarType((PsiVariable)resolved));
            }
            if (resolved instanceof PsiMethod) {
                return GenerationUtil.getDeclaredType((PsiMethod)resolved, substitutor, context);
            }
        } else {
            if (expression instanceof GrMethodCall) {
                GrExpression invokedExpression = ((GrMethodCall)expression).getInvokedExpression();
                return GenerationUtil.getDeclaredType(invokedExpression, context);
            }
            if (expression instanceof GrIndexProperty) {
                GroovyResolveResult result2 = GroovyIndexPropertyUtil.advancedResolve((GrIndexProperty)expression);
                if (result2.getElement() instanceof PsiMethod) {
                    return GenerationUtil.getDeclaredType((PsiMethod)result2.getElement(), result2.getSubstitutor(), context);
                }
            } else {
                if (expression instanceof GrAssignmentExpression) {
                    return GenerationUtil.getDeclaredType(((GrAssignmentExpression)expression).getRValue(), context);
                }
                if (expression instanceof GrConditionalExpression) {
                    return TypesUtil.getLeastUpperBoundNullable(GenerationUtil.getDeclaredType(((GrConditionalExpression)expression).getThenBranch(), context), GenerationUtil.getDeclaredType(((GrConditionalExpression)expression).getElseBranch(), context), expression.getManager());
                }
                if (expression instanceof GrParenthesizedExpression) {
                    return GenerationUtil.getDeclaredType(((GrParenthesizedExpression)expression).getOperand(), context);
                }
                if (expression == null) {
                    return null;
                }
            }
        }
        return expression.getType();
    }

    public static PsiType getDeclaredType(PsiMethod method, PsiSubstitutor substitutor, ExpressionContext context) {
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        if (context.isClassConverted(method.getContainingClass())) {
            return substitutor.substitute(PsiUtil.getSmartReturnType(method));
        }
        return substitutor.substitute(method.getReturnType());
    }

    public static void wrapInCastIfNeeded(StringBuilder builder, @NotNull PsiType expected, @Nullable PsiType actual, GroovyPsiElement context, ExpressionContext expressionContext, StatementWriter writer) {
        if (expected == null) {
            GenerationUtil.$$$reportNull$$$0(31);
        }
        if (actual != null && TypesUtil.isAssignable(expected, actual, context) || expected.equalsToText("java.lang.Object")) {
            writer.writeStatement(builder, expressionContext);
        } else {
            GenerationUtil.wrapInCast(builder, expected, context, expressionContext, writer);
        }
    }

    private static void wrapInCast(StringBuilder builder, @NotNull PsiType expected, PsiElement context, ExpressionContext expressionContext, StatementWriter writer) {
        if (expected == null) {
            GenerationUtil.$$$reportNull$$$0(32);
        }
        builder.append("((");
        TypeWriter.writeType(builder, expected, context);
        builder.append(")(");
        writer.writeStatement(builder, expressionContext);
        builder.append("))");
    }

    static PsiType getNotNullType(PsiElement context, PsiType type2) {
        return type2 != null ? type2 : TypesUtil.getJavaLangObject(context);
    }

    public static void writeThisReference(@Nullable PsiClass targetClass, StringBuilder buffer, ExpressionContext context) {
        if (targetClass != null && !(targetClass instanceof PsiAnonymousClass)) {
            GrCodeReferenceElement ref = GroovyPsiElementFactory.getInstance(context.project).createCodeReferenceElementFromClass(targetClass);
            GenerationUtil.writeCodeReferenceElement(buffer, ref);
            buffer.append('.');
        }
        buffer.append("this");
    }

    public static void writeSuperReference(@Nullable PsiClass targetClass, StringBuilder buffer, ExpressionContext context) {
        if (targetClass != null && !(targetClass instanceof PsiAnonymousClass)) {
            GrCodeReferenceElement ref = GroovyPsiElementFactory.getInstance(context.project).createCodeReferenceElementFromClass(targetClass);
            GenerationUtil.writeCodeReferenceElement(buffer, ref);
            buffer.append('.');
        }
        buffer.append("super");
    }

    @Nullable
    static PsiElement getWrappingImplicitClass(@NotNull PsiElement place) {
        if (place == null) {
            GenerationUtil.$$$reportNull$$$0(33);
        }
        for (PsiElement parent2 = place.getParent(); parent2 != null; parent2 = parent2.getContext()) {
            if (parent2 instanceof PsiClass) {
                return null;
            }
            if (parent2 instanceof GroovyFile && !PsiUtil.isInDummyFile(parent2)) {
                return null;
            }
            if (!(parent2 instanceof GrClosableBlock)) continue;
            return parent2;
        }
        return null;
    }

    static void writeDocComment(StringBuilder buffer, PsiMember member, boolean addLineFeed) {
        PsiDocComment comment;
        if (member instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)member).getDocComment()) != null) {
            String text = comment.getText();
            buffer.append(text);
            if (addLineFeed) {
                buffer.append('\n');
            }
        }
    }

    static {
        binOpTypes.put(GroovyTokenTypes.mPLUS_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"+", (Object)GroovyTokenTypes.mPLUS));
        binOpTypes.put(GroovyTokenTypes.mMINUS_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"-", (Object)GroovyTokenTypes.mMINUS));
        binOpTypes.put(GroovyTokenTypes.mSTAR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"*", (Object)GroovyTokenTypes.mSTAR));
        binOpTypes.put(GroovyTokenTypes.mDIV_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"/", (Object)GroovyTokenTypes.mDIV));
        binOpTypes.put(GroovyTokenTypes.mMOD_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"%", (Object)GroovyTokenTypes.mMOD));
        binOpTypes.put(GroovyTokenTypes.mSL_ASSIGN, (Pair<String, IElementType>)new Pair((Object)"<<", (Object)GroovyElementTypes.COMPOSITE_LSHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mSR_ASSIGN, (Pair<String, IElementType>)new Pair((Object)">>", (Object)GroovyElementTypes.COMPOSITE_RSHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mBSR_ASSIGN, (Pair<String, IElementType>)new Pair((Object)">>>", (Object)GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mBAND_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"&", (Object)GroovyTokenTypes.mBAND));
        binOpTypes.put(GroovyTokenTypes.mBOR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"|", (Object)GroovyTokenTypes.mBOR));
        binOpTypes.put(GroovyTokenTypes.mBXOR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"^", (Object)GroovyTokenTypes.mBXOR));
        binOpTypes.put(GroovyTokenTypes.mSTAR_STAR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"**", (Object)GroovyTokenTypes.mSTAR_STAR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionGenerator";
                break;
            }
            case 2: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiContext";
                break;
            }
            case 3: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprs";
                break;
            }
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 5: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureArgs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/GenerationUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlockBuilder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementBuilder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameProvider";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/GenerationUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethodByName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethod";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethodByResolveResult";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeStatement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findAccessibleSuperClass";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeParameterList";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isCastNeeded";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCastIfNeeded";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCast";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingImplicitClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CheckProcessElement
    implements PsiScopeProcessor {
        private final PsiElement myMember;
        private final PsiManager myManager;
        private boolean myResult;

        CheckProcessElement(@NotNull PsiElement member) {
            if (member == null) {
                CheckProcessElement.$$$reportNull$$$0(0);
            }
            this.myResult = false;
            this.myMember = member;
            this.myManager = member.getManager();
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                CheckProcessElement.$$$reportNull$$$0(1);
            }
            if (state == null) {
                CheckProcessElement.$$$reportNull$$$0(2);
            }
            if (this.myManager.areElementsEquivalent(element, this.myMember)) {
                this.myResult = true;
                return false;
            }
            if (this.myMember instanceof PsiMethod) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = ((PsiMethod)this.myMember).findSuperMethods()) {
                    if (!this.myManager.areElementsEquivalent(element, (PsiElement)method)) continue;
                    this.myResult = true;
                    return false;
                }
            }
            return true;
        }

        public boolean isFound() {
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/GenerationUtil$CheckProcessElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

