/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.AccessorResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GenericAccessorResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.processors.BaseMethodProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/BaseMethodProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "propertyName", "", "propertyKind", "Lcom/intellij/lang/java/beans/PropertyKind;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "place", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/lang/java/beans/PropertyKind;Ljava/util/List;Lcom/intellij/psi/PsiElement;)V", "results", "getResults", "()Ljava/util/List;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "element", "Lcom/intellij/psi/PsiMethod;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.groovy.psi"})
public final class AccessorProcessor
extends BaseMethodProcessor
implements GrResolverProcessor<GroovyResolveResult> {
    private final PropertyKind propertyKind;
    private final List<Argument> arguments;
    private final PsiElement place;

    @Override
    @NotNull
    public List<GroovyResolveResult> getResults() {
        return (List)this.getMyCandidates();
    }

    @Override
    @Nullable
    protected GroovyMethodResult candidate(@NotNull PsiMethod element, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!PropertyUtilKt.checkKind(element, this.propertyKind)) {
            return null;
        }
        return element.hasTypeParameters() ? (GroovyMethodResult)new GenericAccessorResolveResult(element, this.place, state, this.arguments) : (GroovyMethodResult)new AccessorResolveResult(element, this.place, state, this.arguments);
    }

    public AccessorProcessor(@NotNull String propertyName, @NotNull PropertyKind propertyKind, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull((Object)propertyKind, (String)"propertyKind");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        super(PropertyUtilKt.getAccessorName(propertyKind, propertyName));
        this.propertyKind = propertyKind;
        this.arguments = arguments2;
        this.place = place;
        this.hint(ElementClassHint.KEY, new ElementClassHint(){

            public final boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it == ElementClassHint.DeclarationKind.METHOD && this.getAcceptMore();
            }
        });
        this.hint(GroovyResolveKind.HINT_KEY, new GroovyResolveKind.Hint(){

            @Override
            public final boolean shouldProcess(@NotNull GroovyResolveKind it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return it == GroovyResolveKind.METHOD && this.getAcceptMore();
            }
        });
    }
}

