/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrCallSignatureAdapter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrDelegatingClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrFunctionalExpressionSignature;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrMethodSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

public final class GrClosureSignatureUtil {
    private static final Logger LOG = Logger.getInstance(GrClosureSignatureUtil.class);

    private GrClosureSignatureUtil() {
    }

    @Nullable
    public static GrSignature createSignature(GrCall call) {
        Collection<CallSignature<?>> signatures2;
        GrExpression invokedExpression;
        PsiType type2;
        if (call instanceof GrMethodCall && (type2 = (invokedExpression = ((GrMethodCall)call).getInvokedExpression()).getType()) instanceof GroovyClosureType && (signatures2 = ((GroovyClosureType)type2).applicableSignatures(ArgumentsKt.getArguments(call))).size() == 1) {
            return new GrCallSignatureAdapter((CallSignature)ContainerUtil.getFirstItem(signatures2));
        }
        GroovyResolveResult resolveResult2 = call.advancedResolve();
        PsiElement element = resolveResult2.getElement();
        if (element instanceof PsiMethod) {
            return GrClosureSignatureUtil.createSignature((PsiMethod)element, resolveResult2.getSubstitutor());
        }
        return null;
    }

    @NotNull
    public static GrSignature createSignature(@NotNull MethodSignature signature) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(0);
        }
        Object[] types = signature.getParameterTypes();
        GrClosureParameter[] parameters2 = (GrClosureParameter[])ContainerUtil.map((Object[])types, type2 -> new GrImmediateClosureParameterImpl((PsiType)type2, null, false, null), (Object[])new GrClosureParameter[types.length]);
        return new GrImmediateClosureSignatureImpl(parameters2, null, false, false);
    }

    @NotNull
    public static GrSignature createSignature(@NotNull GrFunctionalExpression expression) {
        if (expression == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(1);
        }
        return new GrFunctionalExpressionSignature(expression);
    }

    @NotNull
    public static GrSignature createSignature(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(3);
        }
        return GrClosureSignatureUtil.createSignature(method, substitutor, false);
    }

    @NotNull
    public static GrSignature createSignature(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean eraseParameterTypes) {
        if (method == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(5);
        }
        return GrClosureSignatureUtil.createSignature(method, substitutor, eraseParameterTypes, (PsiElement)method);
    }

    @NotNull
    public static GrSignature createSignature(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean types, @NotNull PsiElement place) {
        if (method == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(6);
        }
        if (substitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(7);
        }
        if (place == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(8);
        }
        return new GrMethodSignatureImpl(method, substitutor, types, place);
    }

    @NotNull
    public static GrSignature createSignature(PsiParameter[] parameters2, @Nullable PsiType returnType2) {
        return new GrImmediateClosureSignatureImpl(parameters2, returnType2);
    }

    @Nullable
    public static PsiType getReturnType(@NotNull List<? extends GrSignature> signatures2, @NotNull GrMethodCall expr) {
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(9);
        }
        if (expr == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(10);
        }
        return GrClosureSignatureUtil.getReturnType(signatures2, PsiUtil.getArgumentTypes(expr.getInvokedExpression(), true), expr);
    }

    @Nullable
    public static PsiType getReturnType(@NotNull List<? extends GrSignature> signatures2, PsiType @Nullable [] args, @NotNull PsiElement context) {
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(12);
        }
        if (signatures2.size() == 1) {
            return signatures2.get(0).getReturnType();
        }
        PsiManager manager = context.getManager();
        if (args == null) {
            return TypesUtil.getLeastUpperBoundNullable(ContainerUtil.map(signatures2, GrSignature::getReturnType), manager);
        }
        List<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>> results = GrClosureSignatureUtil.getSignatureApplicabilities(signatures2, args, context);
        if (results.size() == 1) {
            return ((GrSignature)results.get((int)0).first).getReturnType();
        }
        return TypesUtil.getLeastUpperBoundNullable(ContainerUtil.map(results, it -> ((GrSignature)it.first).getReturnType()), manager);
    }

    public static boolean isSignatureApplicable(@NotNull List<? extends GrSignature> signature, PsiType @NotNull [] args, @NotNull PsiElement context) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(14);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(15);
        }
        return GrClosureSignatureUtil.isSignatureApplicableConcrete(signature, args, context) != Applicability.inapplicable;
    }

    public static Applicability isSignatureApplicableConcrete(@NotNull List<? extends GrSignature> signatures2, PsiType @NotNull [] args, @NotNull PsiElement context) {
        List<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>> results;
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(17);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(18);
        }
        if ((results = GrClosureSignatureUtil.getSignatureApplicabilities(signatures2, args, context)).isEmpty()) {
            return Applicability.inapplicable;
        }
        if (results.size() == 1) {
            return (Applicability)((Object)results.get((int)0).third);
        }
        return Applicability.applicable;
    }

    @Nullable
    public static Trinity<GrSignature, ArgInfo<PsiType>[], Applicability> getApplicableSignature(@NotNull List<? extends GrSignature> signatures2, PsiType @Nullable [] args, @NotNull GroovyPsiElement context) {
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(19);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(20);
        }
        if (args == null) {
            return null;
        }
        List<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>> results = GrClosureSignatureUtil.getSignatureApplicabilities(signatures2, args, context);
        if (results.size() == 1) {
            return results.get(0);
        }
        return null;
    }

    private static List<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>> getSignatureApplicabilities(@NotNull List<? extends GrSignature> signatures2, PsiType @NotNull [] args, @NotNull PsiElement context) {
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(21);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(22);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(23);
        }
        ArrayList<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>> results = new ArrayList<Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>>();
        for (GrSignature grSignature : signatures2) {
            PsiType[] _args;
            PsiType arg;
            GrClosureParameter[] parameters2;
            ArgInfo<PsiType>[] map2 = GrClosureSignatureUtil.mapArgTypesToParameters(grSignature, args, context, false);
            if (map2 != null) {
                results.add((Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>)new Trinity((Object)grSignature, map2, (Object)GrClosureSignatureUtil.isSignatureApplicableInner(map2, grSignature)));
                continue;
            }
            if (args.length != 1 || !PsiUtil.isInMethodCallContext(context) || (parameters2 = grSignature.getParameters()).length == 1 && parameters2[0].getType() instanceof PsiArrayType || !((arg = args[0]) instanceof GrTupleType) || (map2 = GrClosureSignatureUtil.mapArgTypesToParameters(grSignature, _args = ((GrTupleType)arg).getComponentTypesArray(), context, false)) == null) continue;
            results.add((Trinity<GrSignature, ArgInfo<PsiType>[], Applicability>)new Trinity((Object)grSignature, map2, (Object)GrClosureSignatureUtil.isSignatureApplicableInner(map2, grSignature)));
        }
        return results;
    }

    private static Applicability isSignatureApplicableInner(ArgInfo<PsiType> @NotNull [] infos, @NotNull GrSignature signature) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(24);
        }
        if (infos == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(25);
        }
        GrClosureParameter[] parameters2 = signature.getParameters();
        for (int i = 0; i < infos.length; ++i) {
            PsiType pType;
            PsiType type2;
            ArgInfo<PsiType> info = infos[i];
            if (info.args.size() != 1 || info.isMultiArg || (type2 = (PsiType)info.args.get(0)) != null || (pType = parameters2[i].getType()) == null || pType.equalsToText("java.lang.Object")) continue;
            return Applicability.canBeApplicable;
        }
        return Applicability.applicable;
    }

    @NotNull
    static List<GrSignature> curryImpl(@NotNull GrSignature original, PsiType[] args, int position, @NotNull PsiElement context) {
        if (original == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(27);
        }
        GrClosureParameter[] params = original.getParameters();
        ArrayList<GrClosureParameter> newParams = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<GrClosureParameter> opts = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<Integer> optInds = new ArrayList<Integer>(params.length);
        if (position == -1) {
            position = params.length - args.length;
        }
        if (position < 0 || position >= params.length) {
            List<GrSignature> list = Collections.emptyList();
            if (list == null) {
                GrClosureSignatureUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isOptional()) {
                opts.add(params[i]);
                optInds.add(i);
                continue;
            }
            newParams.add(params[i]);
        }
        PsiType rtype = original.getReturnType();
        ArrayList<GrSignature> result2 = new ArrayList<GrSignature>();
        GrClosureSignatureUtil.checkAndAddSignature(result2, args, position, newParams, rtype, context);
        for (int i = 0; i < opts.size(); ++i) {
            newParams.add((Integer)optInds.get(i), (GrClosureParameter)opts.get(i));
            GrClosureSignatureUtil.checkAndAddSignature(result2, args, position, newParams, rtype, context);
        }
        ArrayList<GrSignature> arrayList = result2;
        if (arrayList == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    public static boolean isVarArgsImpl(GrClosureParameter @NotNull [] parameters2) {
        if (parameters2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(30);
        }
        return parameters2.length > 0 && parameters2[parameters2.length - 1].getType() instanceof PsiArrayType;
    }

    public static ArgInfo<PsiType> @Nullable [] mapArgTypesToParameters(@NotNull GrSignature signature, PsiType @NotNull [] args, @NotNull PsiElement context, boolean partial) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(31);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(32);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(33);
        }
        return GrClosureSignatureUtil.mapParametersToArguments(signature, args, FunctionUtil.id(), context, partial);
    }

    public static <Arg> ArgInfo<Arg> @Nullable [] mapParametersToArguments(@NotNull GrSignature signature, Arg @NotNull [] args, @NotNull Function<Arg, PsiType> typeComputer, @NotNull PsiElement context, boolean partial) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(34);
        }
        if (typeComputer == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(35);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(36);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(37);
        }
        LOG.assertTrue(signature.isValid(), signature.getClass());
        if (GrClosureSignatureUtil.checkForOnlyMapParam(signature, args.length)) {
            return ArgInfo.empty_array();
        }
        GrClosureParameter[] params = signature.getParameters();
        if (args.length > params.length && !signature.isVarargs() && !partial) {
            return null;
        }
        int optional = GrClosureSignatureUtil.getOptionalParamCount(signature, context);
        int notOptional = params.length - optional;
        if (signature.isVarargs()) {
            --notOptional;
        }
        if (notOptional > args.length && !partial) {
            return null;
        }
        ArgInfo<Arg>[] map2 = GrClosureSignatureUtil.mapSimple(params, args, typeComputer, context, optional, false);
        if (map2 != null) {
            return map2;
        }
        if (signature.isVarargs()) {
            return new ParameterMapperForVararg(context, params, args, typeComputer).isApplicable();
        }
        if (!partial) {
            return null;
        }
        return GrClosureSignatureUtil.mapSimple(params, args, typeComputer, context, optional, true);
    }

    private static boolean checkForOnlyMapParam(@NotNull GrSignature signature, int argCount) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(38);
        }
        if (argCount > 0 || signature.isCurried()) {
            return false;
        }
        GrClosureParameter[] parameters2 = signature.getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        PsiType type2 = parameters2[0].getType();
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    private static <Arg> ArgInfo<Arg> @Nullable [] mapSimple(GrClosureParameter @NotNull [] params, Arg @NotNull [] args, @NotNull Function<? super Arg, ? extends PsiType> typeComputer, @NotNull PsiElement context, int optional, boolean partial) {
        if (typeComputer == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(39);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(40);
        }
        if (params == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(41);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(42);
        }
        if (args.length > params.length && !partial) {
            return null;
        }
        ArgInfo[] map2 = new ArgInfo[params.length];
        int notOptional = params.length - optional;
        int optionalArgs = args.length - notOptional;
        if (notOptional > args.length && !partial) {
            return null;
        }
        int cur = 0;
        int i = 0;
        while (i < args.length) {
            while (optionalArgs == 0 && cur < params.length && params[cur].isOptional()) {
                ++cur;
            }
            if (cur == params.length) {
                return partial ? map2 : null;
            }
            if (params[cur].isOptional()) {
                --optionalArgs;
            }
            PsiType type2 = (PsiType)typeComputer.fun(args[i]);
            if (!GrClosureSignatureUtil.isAssignableByConversion(params[cur].getType(), type2, context)) {
                return partial ? map2 : null;
            }
            map2[cur] = new ArgInfo<Arg>(args[i], type2);
            ++i;
            ++cur;
        }
        for (i = 0; i < map2.length; ++i) {
            if (map2[i] != null) continue;
            map2[i] = ArgInfo.empty();
        }
        return map2;
    }

    @Contract(value="null, _, _ -> true; _, null, _ -> true")
    public static boolean isAssignableByConversion(@Nullable PsiType paramType, @Nullable PsiType argType, @NotNull PsiElement context) {
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(43);
        }
        if (argType == null || paramType == null) {
            return true;
        }
        if (TypesUtil.isAssignableByMethodCallConversion(paramType, argType, context)) {
            return true;
        }
        PsiType lType = TypesUtil.rawSecondGeneric(paramType, context.getProject());
        PsiType rType = TypesUtil.rawSecondGeneric(argType, context.getProject());
        if (lType == null && rType == null) {
            return false;
        }
        return TypesUtil.isAssignableByMethodCallConversion(lType != null ? lType : paramType, rType != null ? rType : argType, context);
    }

    public static void checkAndAddSignature(List<? super GrSignature> list, PsiType[] args, int position, List<? extends GrClosureParameter> params, PsiType returnType2, @NotNull PsiElement context) {
        int i;
        int last;
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(44);
        }
        if ((last = position + args.length) > params.size()) {
            return;
        }
        for (int i2 = position; i2 < last; ++i2) {
            GrClosureParameter p = params.get(i2);
            PsiType type2 = p.getType();
            if (GrClosureSignatureUtil.isAssignableByConversion(type2, args[i2 - position], context)) continue;
            return;
        }
        GrClosureParameter[] _p = new GrClosureParameter[params.size() - args.length];
        int j = 0;
        for (i = 0; i < position; ++i) {
            _p[j++] = params.get(i);
        }
        for (i = position + args.length; i < params.size(); ++i) {
            _p[j++] = params.get(i);
        }
        list.add(new GrImmediateClosureSignatureImpl(_p, returnType2, _p.length > 0 && _p[_p.length - 1].getType() instanceof PsiArrayType, true));
    }

    @Nullable
    public static GrSignature createSignature(GroovyResolveResult resolveResult2) {
        PsiElement resolved = resolveResult2.getElement();
        if (!(resolved instanceof PsiMethod)) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
        return GrClosureSignatureUtil.createSignature((PsiMethod)resolved, substitutor);
    }

    private static int getOptionalParamCount(@NotNull GrSignature signature, PsiElement context) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(45);
        }
        GrClosureParameter[] parameters2 = signature.getParameters();
        boolean isCompileStatic = PsiUtil.isCompileStatic(context);
        if (!(parameters2.length != 1 || parameters2[0].getType() instanceof PsiPrimitiveType || signature.isCurried() || isCompileStatic)) {
            return 1;
        }
        int count = 0;
        for (GrClosureParameter parameter : parameters2) {
            if (!parameter.isOptional()) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public static Map<GrExpression, Pair<PsiParameter, PsiType>> mapArgumentsToParameters(@NotNull GroovyResolveResult resolveResult2, @NotNull PsiElement context, boolean partial, boolean eraseArgs, GrNamedArgument @NotNull [] namedArgs, GrExpression @NotNull [] expressionArgs, GrClosableBlock @NotNull [] closureArguments) {
        PsiParameter[] parameters2;
        GrSignature signature;
        if (resolveResult2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(46);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(47);
        }
        if (namedArgs == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(48);
        }
        if (expressionArgs == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(49);
        }
        if (closureArguments == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(50);
        }
        PsiElement element = resolveResult2.getElement();
        PsiSubstitutor substitutor = resolveResult2 instanceof GroovyMethodResult ? ((GroovyMethodResult)resolveResult2).getPartialSubstitutor() : resolveResult2.getSubstitutor();
        if (element instanceof PsiMethod) {
            signature = GrClosureSignatureUtil.createSignature((PsiMethod)element, substitutor, eraseArgs);
            parameters2 = ((PsiMethod)element).getParameterList().getParameters();
        } else if (element instanceof GrFunctionalExpression) {
            signature = GrClosureSignatureUtil.createSignature((GrFunctionalExpression)element);
            parameters2 = ((GrFunctionalExpression)element).getAllParameters();
        } else {
            return null;
        }
        ArgInfo<PsiElement>[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, namedArgs, expressionArgs, closureArguments, context, partial, eraseArgs);
        if (argInfos == null) {
            return null;
        }
        HashMap<GrExpression, Pair<PsiParameter, PsiType>> result2 = new HashMap<GrExpression, Pair<PsiParameter, PsiType>>();
        for (int i = 0; i < argInfos.length; ++i) {
            ArgInfo<PsiElement> info = argInfos[i];
            if (info == null) continue;
            for (PsiElement arg : info.args) {
                if (arg instanceof GrNamedArgument) {
                    arg = ((GrNamedArgument)arg).getExpression();
                }
                GrExpression expression = (GrExpression)arg;
                PsiType type2 = parameters2[i].getType();
                if (info.isMultiArg && type2 instanceof PsiArrayType) {
                    type2 = ((PsiArrayType)type2).getComponentType();
                }
                result2.put(expression, (Pair<PsiParameter, PsiType>)Pair.create((Object)parameters2[i], (Object)substitutor.substitute(type2)));
            }
        }
        return result2;
    }

    public static ArgInfo<PsiElement> @Nullable [] mapParametersToArguments(@NotNull GrSignature signature, @NotNull GrCall call) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(51);
        }
        if (call == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(52);
        }
        return GrClosureSignatureUtil.mapParametersToArguments(signature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), call, false, false);
    }

    public static ArgInfo<PsiElement> @Nullable [] mapParametersToArguments(@NotNull GrSignature signature, GrNamedArgument @NotNull [] namedArgs, GrExpression @NotNull [] expressionArgs, GrClosableBlock @NotNull [] closureArguments, @NotNull PsiElement context, boolean partial, boolean eraseArgs) {
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(53);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(54);
        }
        if (namedArgs == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(55);
        }
        if (expressionArgs == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(56);
        }
        if (closureArguments == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(57);
        }
        ArrayList<InnerArg> innerArgs = new ArrayList<InnerArg>();
        boolean hasNamedArgs = namedArgs.length > 0;
        GrClosureParameter[] params = signature.getParameters();
        if (hasNamedArgs) {
            if (params.length == 0) {
                return null;
            }
            PsiType type2 = params[0].getType();
            if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map") || type2 == null || type2.equalsToText("java.lang.Object")) {
                innerArgs.add(new InnerArg((PsiType)TypesUtil.createTypeByFQClassName("java.util.LinkedHashMap", context), namedArgs));
            } else {
                return null;
            }
        }
        for (GrExpression grExpression : expressionArgs) {
            PsiType type3 = grExpression.getType();
            if (partial && grExpression instanceof GrNewExpression && com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type3) == null) {
                type3 = null;
            }
            if (eraseArgs) {
                type3 = TypeConversionUtil.erasure((PsiType)type3);
            }
            innerArgs.add(new InnerArg(type3, grExpression));
        }
        for (GrExpression grExpression : closureArguments) {
            innerArgs.add(new InnerArg(TypeConversionUtil.erasure((PsiType)grExpression.getType()), grExpression));
        }
        return GrClosureSignatureUtil.mapParametersToArguments(signature, innerArgs, hasNamedArgs, partial, context);
    }

    private static ArgInfo<PsiElement>[] mapParametersToArguments(@NotNull GrSignature signature, @NotNull List<? extends InnerArg> innerArgs, boolean hasNamedArgs, boolean partial, @NotNull PsiElement context) {
        ArgInfo<InnerArg>[] innerMap;
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(58);
        }
        if (innerArgs == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(59);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(60);
        }
        if ((innerMap = GrClosureSignatureUtil.mapParametersToArguments(signature, innerArgs.toArray(new InnerArg[0]), o -> o.type, context, partial)) == null) {
            return null;
        }
        ArgInfo[] map2 = new ArgInfo[innerMap.length];
        int i = 0;
        if (hasNamedArgs) {
            map2[i] = new ArgInfo<PsiElement>(((InnerArg)innerMap[i].args.iterator().next()).list, true, innerArgs.get((int)i).type);
            ++i;
        }
        while (i < innerMap.length) {
            ArgInfo<InnerArg> innerArg = innerMap[i];
            if (innerArg == null) {
                map2[i] = null;
            } else {
                ArrayList<PsiElement> argList = new ArrayList<PsiElement>();
                for (InnerArg arg : innerArg.args) {
                    argList.addAll(arg.list);
                }
                boolean multiArg = innerArg.isMultiArg || argList.size() > 1;
                map2[i] = new ArgInfo(argList, multiArg, innerArg.type);
            }
            ++i;
        }
        return map2;
    }

    public static List<MethodSignature> generateAllSignaturesForMethod(GrMethod method, PsiSubstitutor substitutor) {
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        String name = method.getName();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        ArrayList<MethodSignature> result2 = new ArrayList<MethodSignature>();
        GrClosureSignatureUtil.generateAllMethodSignaturesByClosureSignature(name, signature, typeParameters, substitutor, result2);
        return result2;
    }

    @NotNull
    public static MultiMap<MethodSignature, PsiMethod> findRawMethodSignatures(PsiMethod @NotNull [] methods, @NotNull PsiClass clazz) {
        if (clazz == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(61);
        }
        if (methods == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(62);
        }
        HashMap<PsiTypeParameter, PsiType> initialMap = new HashMap<PsiTypeParameter, PsiType>();
        for (PsiTypeParameter parameter : clazz.getTypeParameters()) {
            initialMap.put(parameter, null);
        }
        PsiSubstitutor initialSubstitutor = PsiSubstitutor.createSubstitutor(initialMap);
        MultiMap result2 = new MultiMap();
        for (PsiMethod method : methods) {
            PsiMethod actual = method instanceof GrReflectedMethod ? ((GrReflectedMethod)method).getBaseMethod() : method;
            PsiSubstitutor substitutor = GrClosureSignatureUtil.calcRawSubstitutor(initialMap, initialSubstitutor, actual);
            result2.putValue((Object)method.getSignature(substitutor), (Object)actual);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(63);
        }
        return multiMap;
    }

    @NotNull
    private static PsiSubstitutor calcRawSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> initialMap, @NotNull PsiSubstitutor initialSubstitutor, @NotNull PsiMethod actual) {
        if (initialMap == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(64);
        }
        if (initialSubstitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(65);
        }
        if (actual == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(66);
        }
        if (actual.hasTypeParameters()) {
            HashMap<PsiTypeParameter, PsiType> map1 = new HashMap<PsiTypeParameter, PsiType>(initialMap);
            for (PsiTypeParameter parameter : actual.getTypeParameters()) {
                map1.put(parameter, null);
            }
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor(map1);
            if (psiSubstitutor == null) {
                GrClosureSignatureUtil.$$$reportNull$$$0(67);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = initialSubstitutor;
        if (psiSubstitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(68);
        }
        return psiSubstitutor;
    }

    private static MethodSignature generateSignature(String name, List<PsiType> paramTypes, PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor) {
        return MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])paramTypes.toArray(PsiType.createArray((int)paramTypes.size())), (PsiTypeParameter[])typeParameters, (PsiSubstitutor)substitutor);
    }

    public static void generateAllMethodSignaturesByClosureSignature(@NotNull String name, @NotNull GrSignature signature, PsiTypeParameter @NotNull [] typeParameters, @NotNull PsiSubstitutor substitutor, List<? super MethodSignature> result2) {
        int i;
        if (name == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(69);
        }
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(70);
        }
        if (substitutor == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(71);
        }
        if (typeParameters == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(72);
        }
        GrClosureParameter[] params = signature.getParameters();
        ArrayList<PsiType> newParams = new ArrayList<PsiType>(params.length);
        ArrayList<GrClosureParameter> opts = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<Integer> optInds = new ArrayList<Integer>(params.length);
        for (i = 0; i < params.length; ++i) {
            if (params[i].isOptional()) {
                opts.add(params[i]);
                optInds.add(i);
                continue;
            }
            newParams.add(params[i].getType());
        }
        result2.add((MethodSignature)GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        for (i = 0; i < opts.size(); ++i) {
            newParams.add((Integer)optInds.get(i), ((GrClosureParameter)opts.get(i)).getType());
            result2.add((MethodSignature)GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        }
    }

    public static List<MethodSignature> generateAllMethodSignaturesBySignature(@NotNull String name, @NotNull List<? extends GrSignature> signatures2) {
        if (name == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(73);
        }
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(74);
        }
        ArrayList<MethodSignature> result2 = new ArrayList<MethodSignature>();
        for (GrSignature grSignature : signatures2) {
            GrClosureSignatureUtil.generateAllMethodSignaturesByClosureSignature(name, grSignature, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, result2);
        }
        return result2;
    }

    @Nullable
    public static PsiType getTypeByArg(ArgInfo<? extends PsiElement> arg, PsiManager manager, GlobalSearchScope resolveScope) {
        if (arg.isMultiArg) {
            if (arg.args.isEmpty()) {
                return LazyFqnClassType.getLazyType("java.lang.Object", LanguageLevel.JDK_1_5, resolveScope, JavaPsiFacade.getInstance((Project)manager.getProject())).createArrayType();
            }
            PsiType leastUpperBound = null;
            PsiElement first = (PsiElement)arg.args.get(0);
            if (first instanceof GrNamedArgument) {
                GrNamedArgument[] args = new GrNamedArgument[arg.args.size()];
                int size = arg.args.size();
                for (int i = 0; i < size; ++i) {
                    args[i] = (GrNamedArgument)arg.args.get(i);
                }
                return GrMapType.createFromNamedArgs(first, args);
            }
            for (PsiElement elem : arg.args) {
                if (!(elem instanceof GrExpression)) continue;
                leastUpperBound = TypesUtil.getLeastUpperBoundNullable(leastUpperBound, ((GrExpression)elem).getType(), manager);
            }
            if (leastUpperBound == null) {
                return null;
            }
            return leastUpperBound.createArrayType();
        }
        if (arg.args.isEmpty()) {
            return null;
        }
        PsiElement elem = (PsiElement)arg.args.get(0);
        if (elem instanceof GrExpression) {
            return ((GrExpression)elem).getType();
        }
        return null;
    }

    @Nullable
    public static PsiType getReturnType(List<? extends GrSignature> signatures2) {
        if (signatures2.size() == 1) {
            return signatures2.get(0).getReturnType();
        }
        if (signatures2.size() > 1) {
            PsiType type2 = signatures2.get(0).getReturnType();
            if (type2 == null) {
                return null;
            }
            String firstType = type2.getCanonicalText();
            for (int i = 1; i < signatures2.size(); ++i) {
                PsiType _type = signatures2.get(i).getReturnType();
                if (_type == null) {
                    return null;
                }
                if (firstType.equals(_type.getCanonicalText())) continue;
                return null;
            }
            return type2;
        }
        return null;
    }

    @Nullable
    public static <Arg> MapResultWithError mapSimpleSignatureWithErrors(@NotNull GrSignature signature, Arg @NotNull [] args, @NotNull Function<? super Arg, ? extends PsiType> typeComputer, @NotNull GroovyPsiElement context, int maxErrorCount) {
        GrClosureParameter[] params;
        if (signature == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(75);
        }
        if (typeComputer == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(76);
        }
        if (context == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(77);
        }
        if (args == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(78);
        }
        if (args.length < (params = signature.getParameters()).length) {
            return null;
        }
        if (args.length > params.length && !signature.isVarargs()) {
            return null;
        }
        int errorCount = 0;
        ArrayList<Pair<Integer, PsiType>> errors = new ArrayList<Pair<Integer, PsiType>>(maxErrorCount);
        for (int i = 0; i < params.length; ++i) {
            PsiType type2 = (PsiType)typeComputer.fun(args[i]);
            GrClosureParameter parameter = params[i];
            PsiType parameterType = parameter.getType();
            if (GrClosureSignatureUtil.isAssignableByConversion(parameterType, type2, context)) continue;
            if (parameterType instanceof PsiArrayType && i == params.length - 1) {
                if (i + 1 == args.length) {
                    errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)parameterType));
                }
                PsiType ellipsis = ((PsiArrayType)parameterType).getComponentType();
                for (int j = i; j < args.length; ++j) {
                    if (GrClosureSignatureUtil.isAssignableByConversion(ellipsis, (PsiType)typeComputer.fun(args[j]), context)) continue;
                    if (++errorCount > maxErrorCount) {
                        return null;
                    }
                    errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)ellipsis));
                }
                continue;
            }
            if (++errorCount > maxErrorCount) {
                return null;
            }
            errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)parameterType));
        }
        return new MapResultWithError(errors);
    }

    public static List<GrSignature> generateSimpleSignatures(@NotNull List<? extends GrSignature> signatures2) {
        if (signatures2 == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(79);
        }
        ArrayList<GrSignature> result2 = new ArrayList<GrSignature>();
        for (GrSignature grSignature : signatures2) {
            int pCount;
            GrClosureParameter[] original = grSignature.getParameters();
            ArrayList<1> parameters2 = new ArrayList<1>(original.length);
            for (GrClosureParameter parameter : original) {
                parameters2.add(new GrDelegatingClosureParameter(parameter){

                    @Override
                    public boolean isOptional() {
                        return false;
                    }

                    @Override
                    @Nullable
                    public GrExpression getDefaultInitializer() {
                        return null;
                    }
                });
            }
            for (int i = pCount = grSignature.isVarargs() ? grSignature.getParameterCount() - 2 : grSignature.getParameterCount() - 1; i >= 0; --i) {
                if (!original[i].isOptional()) continue;
                result2.add(new GrImmediateClosureSignatureImpl(parameters2.toArray(GrClosureParameter.EMPTY_ARRAY), grSignature.getReturnType(), grSignature.isVarargs(), false));
                parameters2.remove(i);
            }
            result2.add(new GrImmediateClosureSignatureImpl(parameters2.toArray(GrClosureParameter.EMPTY_ARRAY), grSignature.getReturnType(), grSignature.isVarargs(), false));
        }
        return result2;
    }

    @Nullable
    public static GrMethodCall findCall(@NotNull GrFunctionalExpression expression) {
        PsiElement grandparent;
        PsiElement parent2;
        if (expression == null) {
            GrClosureSignatureUtil.$$$reportNull$$$0(80);
        }
        if ((parent2 = expression.getParent()) instanceof GrMethodCall && ArrayUtil.contains((Object)expression, (Object[])((GrMethodCall)parent2).getClosureArguments())) {
            return (GrMethodCall)parent2;
        }
        if (parent2 instanceof GrArgumentList && (grandparent = parent2.getParent()) instanceof GrMethodCall) {
            return (GrMethodCall)grandparent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 29: 
            case 63: 
            case 67: 
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 29: 
            case 63: 
            case 67: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 74: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 27: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 60: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 18: 
            case 23: 
            case 33: 
            case 37: 
            case 42: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 28: 
            case 29: 
            case 63: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 35: 
            case 39: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComputer";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionArgs";
                break;
            }
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureArguments";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerArgs";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialMap";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSubstitutor";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "curryImpl";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "findRawMethodSignatures";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRawSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSignature";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureApplicable";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureApplicableConcrete";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableSignature";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureApplicabilities";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureApplicableInner";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "curryImpl";
                break;
            }
            case 28: 
            case 29: 
            case 63: 
            case 67: 
            case 68: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgsImpl";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mapArgTypesToParameters";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "mapParametersToArguments";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkForOnlyMapParam";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mapSimple";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableByConversion";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAddSignature";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalParamCount";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "mapArgumentsToParameters";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findRawMethodSignatures";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "calcRawSubstitutor";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "generateAllMethodSignaturesByClosureSignature";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "generateAllMethodSignaturesBySignature";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "mapSimpleSignatureWithErrors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "generateSimpleSignatures";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 29: 
            case 63: 
            case 67: 
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MapResultWithError {
        private final List<Pair<Integer, PsiType>> errorsAndExpectedType;

        public MapResultWithError(List<Pair<Integer, PsiType>> errorsAndExpectedType) {
            this.errorsAndExpectedType = errorsAndExpectedType;
        }

        public List<Pair<Integer, PsiType>> getErrors() {
            return this.errorsAndExpectedType;
        }
    }

    private static class InnerArg {
        List<PsiElement> list;
        PsiType type;

        InnerArg(PsiType type2, PsiElement ... elements) {
            this.list = new ArrayList<PsiElement>(Arrays.asList(elements));
            this.type = type2;
        }
    }

    public static class ArgInfo<ArgType> {
        private static final ArgInfo[] EMPTY_ARRAY = new ArgInfo[0];
        private static final ArgInfo<?> EMPTY = new ArgInfo(Collections.emptyList(), false, null);
        @NotNull
        public final List<ArgType> args;
        public final boolean isMultiArg;
        @Nullable
        public final PsiType type;

        public ArgInfo(@NotNull List<ArgType> args, boolean multiArg, @Nullable PsiType type2) {
            if (args == null) {
                ArgInfo.$$$reportNull$$$0(0);
            }
            this.args = args;
            this.isMultiArg = multiArg;
            this.type = type2;
        }

        public ArgInfo(ArgType arg, PsiType type2) {
            this(Collections.singletonList(arg), false, type2);
        }

        @Contract(pure=true)
        @NotNull
        public static <ArgType> ArgInfo<ArgType> empty() {
            ArgInfo<?> argInfo = EMPTY;
            if (argInfo == null) {
                ArgInfo.$$$reportNull$$$0(1);
            }
            return argInfo;
        }

        @Contract(pure=true)
        public static <ArgType> ArgInfo<ArgType> @NotNull [] empty_array() {
            if (EMPTY_ARRAY == null) {
                ArgInfo.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureSignatureUtil$ArgInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty_array";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ParameterMapperForVararg<Arg> {
        private final PsiElement context;
        private final GrClosureParameter[] params;
        private final Arg[] args;
        private final PsiType[] types;
        private final PsiType vararg;
        private final int paramLength;
        private final ArgInfo<Arg>[] map;

        private ParameterMapperForVararg(PsiElement context, GrClosureParameter[] params, Arg[] args, Function<Arg, PsiType> typeComputer) {
            this.context = context;
            this.params = params;
            this.args = args;
            this.types = PsiType.createArray((int)args.length);
            for (int i = 0; i < args.length; ++i) {
                this.types[i] = (PsiType)typeComputer.fun(args[i]);
            }
            this.paramLength = params.length - 1;
            PsiType lastParamType = params[this.paramLength].getType();
            assert (lastParamType instanceof PsiArrayType);
            this.vararg = ((PsiArrayType)lastParamType).getComponentType();
            this.map = new ArgInfo[params.length];
        }

        private ArgInfo<Arg> @Nullable [] isApplicable() {
            int i;
            int notOptionals = 0;
            for (i = 0; i < this.paramLength; ++i) {
                if (this.params[i].isOptional()) continue;
                ++notOptionals;
            }
            if (this.isApplicableInternal(0, 0, notOptionals)) {
                for (i = 0; i < this.map.length; ++i) {
                    if (this.map[i] != null) continue;
                    this.map[i] = ArgInfo.empty();
                }
                return this.map;
            }
            return null;
        }

        private boolean isApplicableInternal(int curParam, int curArg, int notOptional) {
            boolean skipOptionals = false;
            int startParam = curParam;
            if (notOptional > this.args.length - curArg) {
                return false;
            }
            if (notOptional == this.args.length - curArg) {
                skipOptionals = true;
            }
            while (curArg < this.args.length) {
                if (skipOptionals) {
                    while (curParam < this.paramLength && this.params[curParam].isOptional()) {
                        ++curParam;
                    }
                }
                if (curParam == this.paramLength) break;
                if (this.params[curParam].isOptional()) {
                    if (GrClosureSignatureUtil.isAssignableByConversion(this.params[curParam].getType(), this.types[curArg], this.context) && this.isApplicableInternal(curParam + 1, curArg + 1, notOptional)) {
                        this.map[curParam] = new ArgInfo<Arg>(this.args[curArg], this.types[curArg]);
                        return true;
                    }
                    skipOptionals = true;
                    continue;
                }
                if (!GrClosureSignatureUtil.isAssignableByConversion(this.params[curParam].getType(), this.types[curArg], this.context)) {
                    for (int i = startParam; i < curParam; ++i) {
                        this.map[i] = null;
                    }
                    return false;
                }
                this.map[curParam] = new ArgInfo<Arg>(this.args[curArg], this.types[curArg]);
                --notOptional;
                ++curArg;
                ++curParam;
            }
            ArrayList<Arg> varargs = new ArrayList<Arg>();
            while (curArg < this.args.length) {
                if (!GrClosureSignatureUtil.isAssignableByConversion(this.vararg, this.types[curArg], this.context)) {
                    for (int i = startParam; i < curParam; ++i) {
                        this.map[i] = null;
                    }
                    return false;
                }
                varargs.add(this.args[curArg]);
                ++curArg;
            }
            this.map[this.paramLength] = new ArgInfo(varargs, true, (PsiType)new PsiEllipsisType(this.vararg));
            return true;
        }
    }
}

