/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtilsKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0019\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f*\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"getApplicableModules", "", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getWorkingDirectory", "", "module", "hasAnyApplicableModule", "", "hasNeededDependenciesToRunConsole", "sdkVersion", "isApplicableModule", "sdkVersionIfHasNeededDependenciesToRunConsole", "modules", "", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "intellij.groovy"})
public final class GroovyConsoleUtilKt {
    private static final Module[] modules(@NotNull Project $this$modules) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)$this$modules);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(this).modules");
        return moduleArray;
    }

    public static final boolean isApplicableModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ModuleChooserUtil.hasJavaSdk(module) && ModuleChooserUtil.hasAcceptableModuleType(module);
    }

    public static final boolean hasAnyApplicableModule(@NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Module[] $this$any$iv = GroovyConsoleUtilKt.modules(project);
            boolean $i$f$any = false;
            Module[] moduleArray = $this$any$iv;
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                Module element$iv;
                Module p1 = element$iv = moduleArray[i];
                boolean bl2 = false;
                if (!GroovyConsoleUtilKt.isApplicableModule(p1)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getApplicableModules(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Module[] $this$filter$iv = GroovyConsoleUtilKt.modules(project);
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var6_6 = $this$filterTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void p1 = element$iv$iv = var6_6[i];
            boolean bl = false;
            if (!GroovyConsoleUtilKt.isApplicableModule((Module)p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String getWorkingDirectory(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        Object[] objectArray = moduleRootManager.getContentRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
        Object object = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
        if (object == null || (object = object.getPath()) == null) {
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            object = project.getBasePath();
        }
        return object;
    }

    public static final boolean hasNeededDependenciesToRunConsole(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String sdkVersion = GroovyConfigUtilsKt.getSdkVersion(module);
        return sdkVersion != null && GroovyConsoleUtilKt.hasNeededDependenciesToRunConsole(module, sdkVersion);
    }

    @Nullable
    public static final String sdkVersionIfHasNeededDependenciesToRunConsole(@NotNull Module module) {
        String string;
        String sdkVersion;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string2 = sdkVersion = GroovyConfigUtilsKt.getSdkVersion(module);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = GroovyConsoleUtilKt.hasNeededDependenciesToRunConsole(module, it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean hasNeededDependenciesToRunConsole(Module module, String sdkVersion) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.module\u2026AndLibrariesScope(module)");
        GlobalSearchScope scope = globalSearchScope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (facade.findClass("groovy.ui.GroovyMain", scope) == null) {
            return false;
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"2.3") >= 0) {
            return true;
        }
        return facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null;
    }
}

