/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.config.GroovyLibraryProperties;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    public static final LibraryKind GROOVY_KIND = LibraryKind.create((String)"groovy");

    public GroovyLibraryPresentationProvider() {
        super(GROOVY_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return LibrariesUtil.getGroovyLibraryHome(libraryFiles) != null;
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        String jarVersion = JarVersionDetectionUtil.detectJarVersion((String)"org.codehaus.groovy.control.CompilationUnit", Arrays.asList(libraryFiles));
        if (jarVersion != null) {
            return jarVersion;
        }
        String home = LibrariesUtil.getGroovyLibraryHome(libraryFiles);
        if (home == null) {
            return "undefined";
        }
        return GroovyConfigUtils.getInstance().getSDKVersion(home);
    }

    @Override
    @NotNull
    public Icon getIcon(GroovyLibraryProperties properties) {
        Icon icon = JetgroovyIcons.Groovy.Groovy_16x16;
        if (icon == null) {
            GroovyLibraryPresentationProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            GroovyLibraryPresentationProvider.$$$reportNull$$$0(1);
        }
        return GroovyConfigUtils.getInstance().isSDKHome(file);
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File libDir;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        if ((jars = (libDir = new File(path + "/lib")).exists() ? libDir.listFiles() : new File(path + "/embeddable").listFiles()) != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        String string = GroovyConfigUtils.getInstance().getSDKVersion(path);
        if (string == null) {
            GroovyLibraryPresentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        return "Groovy";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyLibraryPresentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSDKHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

