/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.transformations.singleton.ImplKt;

public class NewInstanceOfSingletonInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitNewExpression(@NotNull GrNewExpression newExpression) {
                if (newExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newExpression.getArrayDeclaration() != null) {
                    return;
                }
                GrCodeReferenceElement refElement = newExpression.getReferenceElement();
                if (refElement == null) {
                    return;
                }
                PsiElement resolved = refElement.resolve();
                if (!(resolved instanceof GrTypeDefinition)) {
                    return;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((GrTypeDefinition)resolved), (String[])new String[]{"groovy.lang.Singleton"});
                if (annotation == null) {
                    return;
                }
                this.registerError((PsiElement)newExpression, GroovyInspectionBundle.message("new.instance.of.singleton", new Object[0]), (LocalQuickFix[])ContainerUtil.ar((Object[])new ReplaceWithInstanceAccessFix[]{new ReplaceWithInstanceAccessFix()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$1", "visitNewExpression"));
            }
        };
    }

    private static class ReplaceWithInstanceAccessFix
    extends GroovyFix {
        private ReplaceWithInstanceAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyInspectionBundle.message("replace.new.expression.with.instance.access", new Object[0]);
            if (string == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof GrNewExpression)) {
                return;
            }
            GrNewExpression newExpression = (GrNewExpression)element;
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            PsiElement resolved = refElement.resolve();
            if (!(resolved instanceof GrTypeDefinition)) {
                return;
            }
            GrTypeDefinition singleton = (GrTypeDefinition)resolved;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)singleton, (String[])new String[]{"groovy.lang.Singleton"});
            if (annotation == null) {
                return;
            }
            String qualifiedName = singleton.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            String propertyName = ImplKt.getPropertyName(annotation);
            GrExpression instanceRef = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(qualifiedName + "." + propertyName);
            GrExpression replaced = newExpression.replaceWithExpression(instanceRef, true);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$ReplaceWithInstanceAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$ReplaceWithInstanceAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

