/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.CoverageStatisticsBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCalculatorImpl
implements StatisticsCalculator {
    private Map<String, CoverageStatisticsBean> myStats = new HashMap<String, CoverageStatisticsBean>();
    private StatisticsCalculatorImpl myPrevStatsHolder;

    @Override
    public void compute(@NotNull CoverageData coverageData) {
        if (coverageData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.compute must not be null");
        }
        this.myPrevStatsHolder = null;
        this.doCompute(coverageData);
    }

    private void doCompute(CoverageData coverageData) {
        this.myStats.clear();
        for (ClassInfo cd : coverageData.getClasses()) {
            this.computeForClass(cd, null);
        }
    }

    @Override
    public void compute(@NotNull CoverageData before, @NotNull CoverageData after) {
        if (before == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.compute must not be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.compute must not be null");
        }
        this.myPrevStatsHolder = new StatisticsCalculatorImpl();
        this.myPrevStatsHolder.compute(before);
        this.doCompute(after);
    }

    private void computeForClass(ClassInfo cd, ClassInfo outerClass) {
        Entry classStatements = cd.getStatementStats();
        Entry classLines = cd.getLineStats();
        Entry methodStats = cd.getMethodStats();
        Entry blockStats = cd.getBlockStats();
        for (CoverageStatisticsBean bean : this.getIncrementLayers(cd, outerClass)) {
            boolean incrementCoveredClasses = false;
            boolean incrementTotalClasses = false;
            if (classLines != null) {
                bean.incrementLines(classLines);
                if (classLines.getCovered() > 0) {
                    incrementCoveredClasses = true;
                }
                if (classLines.getTotal() > 0) {
                    incrementTotalClasses = true;
                }
            }
            if (classStatements != null) {
                bean.incrementStatements(classStatements);
                if (classStatements.getCovered() > 0) {
                    incrementCoveredClasses = true;
                }
                if (classStatements.getTotal() > 0) {
                    incrementTotalClasses = true;
                }
            }
            if (incrementCoveredClasses) {
                bean.incrementCoveredClasses(1);
            }
            if (incrementTotalClasses) {
                bean.incrementTotalClasses(1);
            }
            bean.incrementMethods(methodStats);
            bean.incrementBlocks(blockStats);
        }
        Collection<ClassInfo> innerClasses = cd.getInnerClasses();
        if (innerClasses != null) {
            for (ClassInfo inner : innerClasses) {
                this.computeForClass(inner, outerClass == null ? cd : outerClass);
            }
        }
    }

    private List<CoverageStatisticsBean> getIncrementLayers(ClassInfo cd, ClassInfo outerClass) {
        return Arrays.asList(this.getOverallStats(), this.getForModule(cd.getModule()), this.getForNamespace(cd.getModule(), cd.getNamespace()), this.getForClass(cd), this.getForClassWithInnerClasses(outerClass == null ? cd : outerClass));
    }

    private CoverageStatisticsBean getStatistics(String key) {
        CoverageStatisticsBean stats = this.myStats.get(key);
        if (stats == null) {
            CoverageStatisticsBean prevStats = this.myPrevStatsHolder == null ? null : this.myPrevStatsHolder.getStatistics(key);
            stats = new CoverageStatisticsBean(prevStats);
            this.myStats.put(key, stats);
        }
        return stats;
    }

    @Override
    @NotNull
    public CoverageStatisticsBean getForClass(@NotNull ClassInfo classInfo) {
        if (classInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForClass must not be null");
        }
        CoverageStatisticsBean coverageStatisticsBean = this.getStatistics(this.makeModuleKey(classInfo.getModule()) + "*" + this.makeKey(classInfo));
        if (coverageStatisticsBean == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForClass must not return null");
        }
        return coverageStatisticsBean;
    }

    @Override
    @NotNull
    public CoverageStatisticsBean getForClassWithInnerClasses(@NotNull ClassInfo classInfo) {
        if (classInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForClassWithInnerClasses must not be null");
        }
        CoverageStatisticsBean coverageStatisticsBean = this.getStatistics(this.makeModuleKey(classInfo.getModule()) + "*" + this.makeKey(classInfo) + "#allInner");
        if (coverageStatisticsBean == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForClassWithInnerClasses must not return null");
        }
        return coverageStatisticsBean;
    }

    @Override
    @NotNull
    public CoverageStatisticsBean getForNamespace(@Nullable String module, @NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForNamespace must not be null");
        }
        CoverageStatisticsBean coverageStatisticsBean = this.getStatistics(this.makeModuleKey(module) + "$$" + namespace);
        if (coverageStatisticsBean == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForNamespace must not return null");
        }
        return coverageStatisticsBean;
    }

    @Override
    @NotNull
    public CoverageStatisticsBean getForModule(@Nullable String module) {
        CoverageStatisticsBean coverageStatisticsBean = this.getStatistics(this.makeModuleKey(module));
        if (coverageStatisticsBean == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getForModule must not return null");
        }
        return coverageStatisticsBean;
    }

    @Override
    @NotNull
    public CoverageStatisticsBean getOverallStats() {
        CoverageStatisticsBean coverageStatisticsBean = this.getStatistics(this.getOverallStatKey());
        if (coverageStatisticsBean == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/StatisticsCalculatorImpl.getOverallStats must not return null");
        }
        return coverageStatisticsBean;
    }

    private String makeKey(ClassInfo classInfo) {
        return classInfo.getFQName();
    }

    private String makeModuleKey(String module) {
        return "$Module$" + module + "$%$";
    }

    private String getOverallStatKey() {
        return "<overall>";
    }
}

