/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.detector.heuristics.rule.RuleFilter;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.spellcheck.GrazieSpellchecker;
import com.intellij.grazie.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0006j\b\u0012\u0004\u0012\u00020\u0015`\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/grazie/spellcheck/GrazieSpellchecker;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "()V", "MAX_SUGGESTIONS_COUNT", "", "checkers", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/spellcheck/GrazieSpellchecker$SpellerTool;", "Lcom/intellij/grazie/utils/LinkedSet;", "filter", "Lcom/intellij/grazie/detector/heuristics/rule/RuleFilter;", "getFilter", "()Lcom/intellij/grazie/detector/heuristics/rule/RuleFilter;", "filter$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "filterCheckers", "", "word", "", "getSuggestions", "init", "", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "isCorrect", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "update", "prevState", "newState", "SpellerTool", "intellij.grazie"})
public final class GrazieSpellchecker
implements GrazieStateLifecycle {
    private static final int MAX_SUGGESTIONS_COUNT = 3;
    private static final Lazy filter$delegate;
    private static final Logger logger;
    private static volatile LinkedHashSet<SpellerTool> checkers;
    public static final GrazieSpellchecker INSTANCE;

    private final RuleFilter getFilter() {
        Lazy lazy = filter$delegate;
        GrazieSpellchecker grazieSpellchecker = this;
        Object var3_3 = null;
        boolean bl = false;
        return (RuleFilter)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<SpellerTool> filterCheckers(String word) {
        void $this$filterTo$iv$iv;
        if (checkers.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set preferred = this.getFilter().filter(CollectionsKt.listOf((Object)word)).getPreferred();
        Iterable $this$filter$iv = checkers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                SpellerTool checker = (SpellerTool)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = preferred;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl3 = false;
                        if (!checker.getLang().equalsTo(it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@NotNull GrazieConfig.State state) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Iterable $this$filterNot$iv = state.getAvailableLanguages();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl = false;
            if (it.isEnglish()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SpellerTool spellerTool;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Lang lang = (Lang)((Object)element$iv$iv);
            boolean bl2 = false;
            JLanguageTool tool = LangTool.INSTANCE.getTool(lang, state);
            if (tool.getSpellingCheckRule() != null) {
                SpellingCheckRule spellingCheckRule;
                boolean bl3 = false;
                boolean bl4 = false;
                SpellingCheckRule it = spellingCheckRule;
                boolean bl5 = false;
                spellerTool = new SpellerTool(tool, lang, it, 3);
            } else {
                spellerTool = null;
            }
            if (spellerTool == null) continue;
            SpellerTool spellerTool2 = spellerTool;
            boolean bl6 = false;
            boolean bl7 = false;
            SpellerTool it$iv$iv = spellerTool2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        checkers = UtilsKt.toLinkedSet((List)destination$iv$iv);
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkParameterIsNotNull((Object)prevState, (String)"prevState");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        this.init(newState);
    }

    @Nullable
    public final Boolean isCorrect(@NotNull String word) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            Set<SpellerTool> myCheckers = this.filterCheckers(word);
            if (myCheckers.isEmpty()) {
                return null;
            }
            Iterable $this$any$iv = myCheckers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    SpellerTool speller = (SpellerTool)element$iv;
                    boolean bl3 = false;
                    try {
                        bl2 = speller.check(word);
                    }
                    catch (Throwable t) {
                        logger.warn("Got exception during check for spelling mistakes by LanguageTool with word: " + word, t);
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinkedHashSet<String> getSuggestions(@NotNull String word) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Iterable $this$mapNotNull$iv = this.filterCheckers(word);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set<String> set;
            Set<String> set2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpellerTool speller = (SpellerTool)element$iv$iv;
            boolean bl2 = false;
            try {
                set2 = speller.suggest(word);
            }
            catch (Throwable t) {
                logger.warn("Got exception during suggest for spelling mistakes by LanguageTool with word: " + word, t);
                set2 = null;
            }
            if (set2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Set<String> it$iv$iv = set;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return UtilsKt.toLinkedSet(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    private GrazieSpellchecker() {
    }

    static {
        GrazieSpellchecker grazieSpellchecker;
        INSTANCE = grazieSpellchecker = new GrazieSpellchecker();
        filter$delegate = LazyKt.lazy((Function0)filter.2.INSTANCE);
        logger = LoggerFactory.getLogger(GrazieSpellchecker.class);
        checkers = new LinkedHashSet();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010!\u001a\u00020\u0016J\t\u0010\"\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieSpellchecker$SpellerTool;", "", "tool", "Lorg/languagetool/JLanguageTool;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "speller", "Lorg/languagetool/rules/spelling/SpellingCheckRule;", "suggestLimit", "", "(Lorg/languagetool/JLanguageTool;Lcom/intellij/grazie/jlanguage/Lang;Lorg/languagetool/rules/spelling/SpellingCheckRule;I)V", "getLang", "()Lcom/intellij/grazie/jlanguage/Lang;", "getSpeller", "()Lorg/languagetool/rules/spelling/SpellingCheckRule;", "getSuggestLimit", "()I", "getTool", "()Lorg/languagetool/JLanguageTool;", "check", "", "word", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "suggest", "", "text", "toString", "intellij.grazie"})
    public static final class SpellerTool {
        @NotNull
        private final JLanguageTool tool;
        @NotNull
        private final Lang lang;
        @NotNull
        private final SpellingCheckRule speller;
        private final int suggestLimit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean check(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            SpellingCheckRule spellingCheckRule = this.speller;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (spellingCheckRule) {
                boolean bl3 = false;
                bl2 = !this.speller.isMisspelled(word) || !this.speller.isMisspelled(StringsKt.capitalize((String)word));
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> suggest(@NotNull String text2) {
            Set set;
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            SpellingCheckRule spellingCheckRule = this.speller;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (spellingCheckRule) {
                void $this$flatMapTo$iv$iv;
                boolean bl3 = false;
                RuleMatch[] ruleMatchArray = this.speller.match(this.tool.getRawAnalyzedSentence(text2));
                Intrinsics.checkExpressionValueIsNotNull((Object)ruleMatchArray, (String)"speller.match(tool.getRawAnalyzedSentence(text))");
                RuleMatch[] $this$flatMap$iv = ruleMatchArray;
                boolean $i$f$flatMap = false;
                RuleMatch[] ruleMatchArray2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                void var11_13 = $this$flatMapTo$iv$iv;
                int n = ((void)var11_13).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var11_13[i];
                    boolean bl4 = false;
                    Iterable list$iv$iv = it.getSuggestedReplacements();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)this.suggestLimit));
            }
            return set;
        }

        @NotNull
        public final JLanguageTool getTool() {
            return this.tool;
        }

        @NotNull
        public final Lang getLang() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule getSpeller() {
            return this.speller;
        }

        public final int getSuggestLimit() {
            return this.suggestLimit;
        }

        public SpellerTool(@NotNull JLanguageTool tool, @NotNull Lang lang, @NotNull SpellingCheckRule speller, int suggestLimit) {
            Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
            Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
            Intrinsics.checkParameterIsNotNull((Object)speller, (String)"speller");
            this.tool = tool;
            this.lang = lang;
            this.speller = speller;
            this.suggestLimit = suggestLimit;
        }

        @NotNull
        public final JLanguageTool component1() {
            return this.tool;
        }

        @NotNull
        public final Lang component2() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule component3() {
            return this.speller;
        }

        public final int component4() {
            return this.suggestLimit;
        }

        @NotNull
        public final SpellerTool copy(@NotNull JLanguageTool tool, @NotNull Lang lang, @NotNull SpellingCheckRule speller, int suggestLimit) {
            Intrinsics.checkParameterIsNotNull((Object)tool, (String)"tool");
            Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
            Intrinsics.checkParameterIsNotNull((Object)speller, (String)"speller");
            return new SpellerTool(tool, lang, speller, suggestLimit);
        }

        public static /* synthetic */ SpellerTool copy$default(SpellerTool spellerTool, JLanguageTool jLanguageTool, Lang lang, SpellingCheckRule spellingCheckRule, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                jLanguageTool = spellerTool.tool;
            }
            if ((n2 & 2) != 0) {
                lang = spellerTool.lang;
            }
            if ((n2 & 4) != 0) {
                spellingCheckRule = spellerTool.speller;
            }
            if ((n2 & 8) != 0) {
                n = spellerTool.suggestLimit;
            }
            return spellerTool.copy(jLanguageTool, lang, spellingCheckRule, n);
        }

        @NotNull
        public String toString() {
            return "SpellerTool(tool=" + this.tool + ", lang=" + (Object)((Object)this.lang) + ", speller=" + this.speller + ", suggestLimit=" + this.suggestLimit + ")";
        }

        public int hashCode() {
            JLanguageTool jLanguageTool = this.tool;
            Lang lang = this.lang;
            SpellingCheckRule spellingCheckRule = this.speller;
            return (((jLanguageTool != null ? jLanguageTool.hashCode() : 0) * 31 + (lang != null ? ((Object)((Object)lang)).hashCode() : 0)) * 31 + (spellingCheckRule != null ? spellingCheckRule.hashCode() : 0)) * 31 + Integer.hashCode(this.suggestLimit);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpellerTool)) break block3;
                    SpellerTool spellerTool = (SpellerTool)object;
                    if (!Intrinsics.areEqual((Object)this.tool, (Object)spellerTool.tool) || !Intrinsics.areEqual((Object)((Object)this.lang), (Object)((Object)spellerTool.lang)) || !Intrinsics.areEqual((Object)this.speller, (Object)spellerTool.speller) || this.suggestLimit != spellerTool.suggestLimit) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

