/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.service.fus.EventLogMetadataLoadException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistConditions;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import com.intellij.internal.statistic.service.request.StatsHttpRequests;
import com.intellij.internal.statistic.service.request.StatsRequestResult;
import com.intellij.internal.statistic.service.request.StatsResponseException;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsWhitelistLoader {
    @NotNull
    public static StatisticsWhitelistConditions getApprovedGroups(@NotNull String serviceUrl, @NotNull String userAgent) {
        if (serviceUrl == null) {
            StatisticsWhitelistLoader.$$$reportNull$$$0(0);
        }
        if (userAgent == null) {
            StatisticsWhitelistLoader.$$$reportNull$$$0(1);
        }
        try {
            String content = StatisticsWhitelistLoader.loadWhiteListFromServer(serviceUrl, userAgent);
            return StatisticsWhitelistLoader.parseApprovedGroups(content);
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            StatisticsWhitelistConditions statisticsWhitelistConditions = StatisticsWhitelistConditions.empty();
            if (statisticsWhitelistConditions == null) {
                StatisticsWhitelistLoader.$$$reportNull$$$0(2);
            }
            return statisticsWhitelistConditions;
        }
    }

    @NotNull
    public static String loadWhiteListFromServer(@Nullable String serviceUrl, @NotNull String userAgent) throws EventLogMetadataLoadException {
        StatsRequestResult<String> result;
        block6: {
            if (userAgent == null) {
                StatisticsWhitelistLoader.$$$reportNull$$$0(3);
            }
            if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
                throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.EMPTY_SERVICE_URL);
            }
            result = StatsHttpRequests.request(serviceUrl, userAgent).send(r -> r.readAsString());
            if (!result.isSucceed()) break block6;
            String string = result.getResult();
            if (string == null) {
                StatisticsWhitelistLoader.$$$reportNull$$$0(4);
            }
            return string;
        }
        try {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.UNREACHABLE_SERVICE, result.getError());
        }
        catch (StatsResponseException | IOException e) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.ERROR_ON_LOAD, (Throwable)e);
        }
    }

    public static long lastModifiedWhitelist(@Nullable String serviceUrl, @NotNull String userAgent) {
        if (userAgent == null) {
            StatisticsWhitelistLoader.$$$reportNull$$$0(5);
        }
        if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
            return 0L;
        }
        try {
            StatsRequestResult<Long> result = StatsHttpRequests.head(serviceUrl, userAgent).send(r -> r.lastModified());
            return result.getResult() != null ? result.getResult() : 0L;
        }
        catch (StatsResponseException | IOException e) {
            return 0L;
        }
    }

    @NotNull
    public static StatisticsWhitelistConditions parseApprovedGroups(@Nullable String content) throws EventLogMetadataParseException {
        FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(content);
        HashMap<String, StatisticsWhitelistGroupConditions> groupToCondition = new HashMap<String, StatisticsWhitelistGroupConditions>();
        for (FUStatisticsWhiteListGroupsService.WLGroup group : groups.groups) {
            groupToCondition.put(group.id, StatisticsWhitelistGroupConditions.create(group));
        }
        StatisticsWhitelistConditions statisticsWhitelistConditions = StatisticsWhitelistConditions.create(groupToCondition);
        if (statisticsWhitelistConditions == null) {
            StatisticsWhitelistLoader.$$$reportNull$$$0(6);
        }
        return statisticsWhitelistConditions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAgent";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/StatisticsWhitelistLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/StatisticsWhitelistLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApprovedGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadWhiteListFromServer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseApprovedGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApprovedGroups";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadWhiteListFromServer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastModifiedWhitelist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

