/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.kpmsearch.MyErrorHandler;
import org.jetbrains.idea.kpmsearch.PackageSearchResultModel;
import org.jetbrains.idea.kpmsearch.PackageServiceConfig;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

public class PackageSearchService
implements DependencySearchProvider {
    private static final MyErrorHandler<Throwable> myErrorHandler = new MyErrorHandler();
    private final Gson myGson = new Gson();
    private final PackageServiceConfig myPackageServiceConfig = new PackageServiceConfig();

    @Override
    public void fulltextSearch(@NotNull String searchString, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (searchString == null) {
            PackageSearchService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(1);
        }
        searchString = this.normalize(searchString);
        ProgressManager.checkCanceled();
        String url = this.createUrlFullTextSearch(searchString);
        this.doRequest(consumer, url);
    }

    private String normalize(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isOK = true;
        for (char c : string.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-') {
                builder.append(c);
                continue;
            }
            isOK = false;
        }
        return isOK ? string : builder.toString();
    }

    @Override
    public void suggestPrefix(@Nullable String groupId, @Nullable String artifactId, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(2);
        }
        artifactId = this.normalize(artifactId);
        groupId = this.normalize(groupId);
        ProgressManager.checkCanceled();
        String url = this.createUrlSuggestPrefix(groupId, artifactId);
        this.doRequest(consumer, url);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private void doRequest(@NotNull Consumer<RepositoryArtifactData> consumer, String url) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(3);
        }
        if (url == null) {
            return;
        }
        try {
            HttpRequests.request((String)url).userAgent(this.myPackageServiceConfig.getUserAgent()).forceHttps(true).connectTimeout((int)PackageServiceConfig.MAX_TIMEOUT).readTimeout((int)PackageServiceConfig.MAX_TIMEOUT).connect(request -> this.process(consumer, request));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object process(@NotNull Consumer<RepositoryArtifactData> consumer, HttpRequests.Request request) {
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(4);
        }
        try {
            JsonReader reader = this.myGson.newJsonReader((Reader)request.getReader());
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("items".equals(name)) {
                    this.readVariants(reader, consumer);
                    continue;
                }
                reader.nextString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createUrlFullTextSearch(@NotNull String coord) {
        String url;
        if (coord == null) {
            PackageSearchService.$$$reportNull$$$0(5);
        }
        if ((url = this.myPackageServiceConfig.getFullTextUrl()) == null) {
            return null;
        }
        return url + "?query=" + PackageSearchService.encode(coord.trim());
    }

    private String createUrlSuggestPrefix(@Nullable String groupId, @Nullable String artifactId) {
        String url = this.myPackageServiceConfig.getSuggestUrl();
        if (url == null) {
            return null;
        }
        String groupParam = StringUtil.isEmpty((String)groupId) ? "" : "groupId=" + PackageSearchService.encode(groupId.trim());
        String artifactParam = StringUtil.isEmpty((String)artifactId) ? "" : "artifactId=" + PackageSearchService.encode(artifactId.trim());
        return url + "?" + groupParam + "&" + artifactParam;
    }

    private void readVariants(JsonReader reader, Consumer<RepositoryArtifactData> consumer) throws IOException {
        reader.beginArray();
        int results = 0;
        while (reader.hasNext() && results++ < 20) {
            PackageSearchResultModel resultModel = (PackageSearchResultModel)this.myGson.fromJson(reader, PackageSearchResultModel.class);
            ProgressManager.checkCanceled();
            if (resultModel.versions == null || resultModel.versions.length < 1 || StringUtil.isEmpty((String)resultModel.groupId) || StringUtil.isEmpty((String)resultModel.artifactId)) continue;
            HashSet<String> versions = new HashSet<String>();
            ArrayList<MavenDependencyCompletionItem> itemList = new ArrayList<MavenDependencyCompletionItem>();
            for (int i = 0; i < resultModel.versions.length; ++i) {
                if (!versions.add(resultModel.versions[i])) continue;
                itemList.add(new MavenDependencyCompletionItem(resultModel.groupId, resultModel.artifactId, resultModel.versions[i], MavenDependencyCompletionItem.Type.REMOTE));
            }
            MavenDependencyCompletionItem[] items = itemList.toArray(new MavenDependencyCompletionItem[0]);
            consumer.accept(new MavenRepositoryArtifactInfo(items[0].getGroupId(), items[0].getArtifactId(), items));
        }
    }

    @NotNull
    private static String encode(@NotNull String s) {
        String string;
        if (s == null) {
            PackageSearchService.$$$reportNull$$$0(6);
        }
        try {
            string = URLEncoder.encode(s.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            PackageSearchService.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/kpmsearch/PackageSearchService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/kpmsearch/PackageSearchService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "encode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fulltextSearch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUrlFullTextSearch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

