/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.loomchild.segment.srx.SrxDocument;
import org.jetbrains.annotations.NotNull;
import org.languagetool.language.Language;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SrxTools;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/languagetool/tokenizers/SRXSentenceTokenizer;", "Lorg/languagetool/tokenizers/SentenceTokenizer;", "language", "Lorg/languagetool/language/Language;", "srxInClassPath", "", "(Lorg/languagetool/language/Language;Ljava/lang/String;)V", "parCode", "srxDocument", "Lnet/loomchild/segment/srx/SrxDocument;", "setSingleLineBreaksMarksParagraph", "", "lineBreakParagraphs", "", "singleLineBreaksMarksPara", "tokenize", "", "text", "languagetool-core"})
public class SRXSentenceTokenizer
implements SentenceTokenizer {
    private final SrxDocument srxDocument;
    private String parCode;
    private final Language language;

    @Override
    @NotNull
    public List<String> tokenize(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        StringBuilder stringBuilder = new StringBuilder().append(this.language.getShortCode());
        String string = this.parCode;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parCode");
        }
        return SrxTools.INSTANCE.tokenize(text, this.srxDocument, stringBuilder.append(string).toString());
    }

    @Override
    public boolean singleLineBreaksMarksPara() {
        String string = this.parCode;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parCode");
        }
        return Intrinsics.areEqual((Object)"_one", (Object)string);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }

    @JvmOverloads
    public SRXSentenceTokenizer(@NotNull Language language, @NotNull String srxInClassPath) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)srxInClassPath, (String)"srxInClassPath");
        this.language = language;
        this.srxDocument = SrxTools.INSTANCE.createSrxDocument(srxInClassPath);
        this.setSingleLineBreaksMarksParagraph(false);
    }

    public /* synthetic */ SRXSentenceTokenizer(Language language, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "/segment.srx";
        }
        this(language, string);
    }

    @JvmOverloads
    public SRXSentenceTokenizer(@NotNull Language language) {
        this(language, null, 2, null);
    }
}

