/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.CFSA2Serializer;
import morfologik.fsa.builders.FSABuilder;
import morfologik.stemming.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.config.UserConfig;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tools.annotation.Experimental;

public class MorfologikMultiSpeller {
    private static final LoadingCache<BufferedReaderWithSource, List<byte[]>> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BufferedReaderWithSource, List<byte[]>>(){

        public List<byte[]> load(@NotNull BufferedReaderWithSource reader) throws IOException {
            List lines = MorfologikMultiSpeller.getLines(reader.reader);
            if (reader.languageVariantReader != null) {
                lines.addAll(MorfologikMultiSpeller.getLines(reader.languageVariantReader));
                lines.add("LanguageTool".getBytes());
            }
            return lines;
        }
    });
    private static final Map<String, Dictionary> dicPathToDict = new HashMap<String, Dictionary>();
    private final List<MorfologikSpeller> spellers;
    private final List<MorfologikSpeller> defaultDictSpellers;
    private final List<MorfologikSpeller> userDictSpellers;
    private final boolean convertsCase;

    public MorfologikMultiSpeller(String binaryDictPath, String plainTextPath, String languageVariantPlainTextPath, int maxEditDistance) throws IOException {
        this(binaryDictPath, plainTextPath, languageVariantPlainTextPath, null, maxEditDistance);
    }

    @Experimental
    public MorfologikMultiSpeller(String binaryDictPath, String plainTextPath, String languageVariantPlainTextPath, UserConfig userConfig, int maxEditDistance) throws IOException {
        this(binaryDictPath, plainTextPath != null ? new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(plainTextPath), StandardCharsets.UTF_8)) : null, plainTextPath, languageVariantPlainTextPath == null ? null : new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextPath), StandardCharsets.UTF_8)), languageVariantPlainTextPath, userConfig != null ? userConfig.getAcceptedWords() : Collections.emptyList(), maxEditDistance);
        if (plainTextPath != null && (!plainTextPath.endsWith(".txt") || languageVariantPlainTextPath != null && !languageVariantPlainTextPath.endsWith(".txt"))) {
            throw new IllegalArgumentException("Unsupported dictionary, plain text file needs to have suffix .txt: " + plainTextPath);
        }
    }

    public MorfologikMultiSpeller(String binaryDictPath, BufferedReader plainTextReader, String plainTextReaderPath, BufferedReader languageVariantPlainTextReader, String languageVariantPlainTextPath, List<String> userWords, int maxEditDistance) throws IOException {
        MorfologikSpeller speller = this.getBinaryDict(binaryDictPath, maxEditDistance);
        ArrayList<MorfologikSpeller> spellers = new ArrayList<MorfologikSpeller>();
        MorfologikSpeller userDictSpeller = this.getUserDictSpellerOrNull(userWords, binaryDictPath, maxEditDistance);
        if (userDictSpeller != null) {
            spellers.add(userDictSpeller);
            this.userDictSpellers = Collections.singletonList(userDictSpeller);
        } else {
            this.userDictSpellers = Collections.emptyList();
        }
        spellers.add(speller);
        this.convertsCase = speller.convertsCase();
        if (plainTextReader != null) {
            MorfologikSpeller plainTextSpeller = this.getPlainTextDictSpellerOrNull(plainTextReader, plainTextReaderPath, languageVariantPlainTextReader, languageVariantPlainTextPath, binaryDictPath, maxEditDistance);
            if (plainTextSpeller != null) {
                spellers.add(plainTextSpeller);
                this.defaultDictSpellers = Arrays.asList(speller, plainTextSpeller);
            } else {
                this.defaultDictSpellers = Collections.singletonList(speller);
            }
        } else {
            this.defaultDictSpellers = Collections.singletonList(speller);
        }
        this.spellers = Collections.unmodifiableList(spellers);
    }

    private MorfologikSpeller getUserDictSpellerOrNull(List<String> userWords, String dictPath, int maxEditDistance) throws IOException {
        if (userWords.isEmpty()) {
            return null;
        }
        ArrayList<byte[]> byteLines = new ArrayList<byte[]>();
        for (String line : userWords) {
            byteLines.add(line.getBytes(StandardCharsets.UTF_8));
        }
        Dictionary dictionary2 = this.getDictionary(byteLines, dictPath, dictPath.replace(".dict", ".info"), false);
        return new MorfologikSpeller(dictionary2, maxEditDistance);
    }

    private MorfologikSpeller getBinaryDict(String binaryDictPath, int maxEditDistance) {
        if (binaryDictPath.endsWith(".dict")) {
            return new MorfologikSpeller(binaryDictPath, maxEditDistance);
        }
        throw new RuntimeException("Unsupported dictionary, binary Morfologik file needs to have suffix .dict: " + binaryDictPath);
    }

    @Nullable
    private MorfologikSpeller getPlainTextDictSpellerOrNull(BufferedReader plainTextReader, String plainTextReaderPath, BufferedReader languageVariantPlainTextReader, String languageVariantPlainTextPath, String dictPath, int maxEditDistance) throws IOException {
        List lines = (List)dictCache.getUnchecked((Object)new BufferedReaderWithSource(plainTextReader, plainTextReaderPath, languageVariantPlainTextReader, languageVariantPlainTextPath));
        if (lines.isEmpty()) {
            return null;
        }
        Dictionary dictionary2 = this.getDictionary(lines, plainTextReaderPath, dictPath.replace(".dict", ".info"), true);
        return new MorfologikSpeller(dictionary2, maxEditDistance);
    }

    private static List<byte[]> getLines(BufferedReader br) throws IOException {
        String line;
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(StringUtils.substringBefore((String)line, (String)"#").trim().getBytes(StandardCharsets.UTF_8));
        }
        return lines;
    }

    private Dictionary getDictionary(List<byte[]> lines, String dictPath, String infoPath, boolean allowCache) throws IOException {
        String cacheKey = dictPath + "|" + infoPath;
        Dictionary dictFromCache = dicPathToDict.get(cacheKey);
        if (allowCache && dictFromCache != null) {
            return dictFromCache;
        }
        ArrayList<byte[]> linesCopy = new ArrayList<byte[]>(lines);
        Collections.sort(linesCopy, FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(linesCopy);
        ByteArrayOutputStream fsaOutStream = (ByteArrayOutputStream)new CFSA2Serializer().serialize(fsa, (OutputStream)new ByteArrayOutputStream());
        ByteArrayInputStream fsaInStream = new ByteArrayInputStream(fsaOutStream.toByteArray());
        Dictionary dict = Dictionary.read((InputStream)fsaInStream, (InputStream)JLanguageTool.getDataBroker().getFromResourceDirAsStream(infoPath));
        dicPathToDict.put(cacheKey, dict);
        return dict;
    }

    public boolean isMisspelled(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            if (speller.isMisspelled(word)) continue;
            return false;
        }
        return true;
    }

    public int getFrequency(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            int freq = speller.getFrequency(word);
            if (freq <= 0) continue;
            return freq;
        }
        return 0;
    }

    @NotNull
    private List<String> getSuggestionsFromSpellers(String word, List<MorfologikSpeller> spellerList) {
        ArrayList<String> result = new ArrayList<String>();
        for (MorfologikSpeller speller : spellerList) {
            List<String> suggestions = speller.getSuggestions(word);
            for (String suggestion : suggestions) {
                if (result.contains(suggestion) || suggestion.equals(word)) continue;
                result.add(suggestion);
            }
        }
        return result;
    }

    public List<String> getSuggestions(String word) {
        return this.getSuggestionsFromSpellers(word, this.spellers);
    }

    @Experimental
    public List<String> getSuggestionsFromUserDicts(String word) {
        return this.getSuggestionsFromSpellers(word, this.userDictSpellers);
    }

    @Experimental
    public List<String> getSuggestionsFromDefaultDicts(String word) {
        return this.getSuggestionsFromSpellers(word, this.defaultDictSpellers);
    }

    public boolean convertsCase() {
        return this.convertsCase;
    }

    static class BufferedReaderWithSource {
        private BufferedReader reader;
        private String readerPath;
        private BufferedReader languageVariantReader;
        private String languageVariantPath;

        BufferedReaderWithSource(BufferedReader reader, String readerPath, BufferedReader languageVariantReader, String languageVariantPath) {
            this.reader = Objects.requireNonNull(reader);
            this.readerPath = Objects.requireNonNull(readerPath);
            this.languageVariantReader = languageVariantReader;
            this.languageVariantPath = languageVariantPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedReaderWithSource that = (BufferedReaderWithSource)o;
            return Objects.equals(this.readerPath, that.readerPath) && Objects.equals(this.languageVariantPath, that.languageVariantPath);
        }

        public int hashCode() {
            return Objects.hash(this.readerPath, this.languageVariantPath);
        }
    }
}

