/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.analysis.AnalyzedToken;
import org.languagetool.analysis.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class PatternToken
implements Cloneable {
    public static final String UNKNOWN_TAG = "UNKNOWN";
    private static final String CASE_INSENSITIVE = "(?iu)";
    private final boolean caseSensitive;
    private final boolean stringRegExp;
    private final List<PatternToken> andGroupList = new ArrayList<PatternToken>();
    private final List<PatternToken> orGroupList = new ArrayList<PatternToken>();
    private final boolean inflected;
    private String stringToken;
    private PosToken posToken;
    private ChunkTag chunkTag;
    private boolean negation;
    private boolean testWhitespace;
    private boolean whitespaceBefore;
    private boolean isInsideMarker = true;
    private List<PatternToken> exceptionList;
    private boolean exceptionValidNext;
    private boolean exceptionSet;
    private boolean exceptionValidPrevious;
    private List<PatternToken> previousExceptionList;
    private int skip;
    private int minOccurrence = 1;
    private int maxOccurrence = 1;
    private Pattern pattern;
    private Match tokenReference;
    private String referenceString;
    private String phraseName;
    private boolean testString;
    private boolean unificationNeutral;
    private boolean uniNegation;
    private Map<String, List<String>> unificationFeatures;
    private boolean isLastUnified;

    public PatternToken(String token, boolean caseSensitive, boolean regExp, boolean inflected) {
        this.caseSensitive = caseSensitive;
        this.stringRegExp = regExp;
        this.inflected = inflected;
        this.setStringElement(token);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isMatched(AnalyzedToken token) {
        boolean posNegation;
        if (this.testWhitespace && !this.isWhitespaceBefore(token)) {
            return false;
        }
        boolean bl = posNegation = this.posToken != null && this.posToken.negation;
        if (this.testString) {
            return this.isStringTokenMatched(token) ^ this.negation && this.isPosTokenMatched(token) ^ posNegation;
        }
        return !this.negation && this.isPosTokenMatched(token) ^ posNegation;
    }

    public boolean isExceptionMatched(AnalyzedToken token) {
        if (this.exceptionSet) {
            for (PatternToken testException : this.exceptionList) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAndExceptionGroupMatched(AnalyzedToken token) {
        for (PatternToken testAndGroup : this.andGroupList) {
            if (!testAndGroup.isExceptionMatched(token)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.isExceptionMatched(token) || this.isAndExceptionGroupMatched(token);
    }

    public void setAndGroupElement(PatternToken andToken) {
        this.andGroupList.add(Objects.requireNonNull(andToken));
    }

    public boolean hasAndGroup() {
        return this.andGroupList.size() > 0;
    }

    public List<PatternToken> getAndGroup() {
        return Collections.unmodifiableList(this.andGroupList);
    }

    public void setOrGroupElement(PatternToken orToken) {
        this.orGroupList.add(Objects.requireNonNull(orToken));
    }

    public boolean hasOrGroup() {
        return this.orGroupList.size() > 0;
    }

    public List<PatternToken> getOrGroup() {
        return Collections.unmodifiableList(this.orGroupList);
    }

    public boolean isMatchedByScopeNextException(AnalyzedToken token) {
        if (this.exceptionSet) {
            for (PatternToken testException : this.exceptionList) {
                if (!testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedToken token) {
        if (this.exceptionValidPrevious) {
            for (PatternToken testException : this.previousExceptionList) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedTokenReadings prevToken) {
        for (AnalyzedToken analyzedToken : prevToken) {
            if (!this.isMatchedByPreviousException(analyzedToken)) continue;
            return true;
        }
        return false;
    }

    public boolean isSentenceStart() {
        return this.posToken != null && "SENT_START".equals(this.posToken.posTag) && !this.posToken.negation;
    }

    public void setPosToken(PosToken posToken) {
        this.posToken = posToken;
    }

    public void setChunkTag(ChunkTag chunkTag) {
        this.chunkTag = chunkTag;
    }

    @Nullable
    public String getString() {
        return this.stringToken;
    }

    public void setStringElement(String token) {
        this.stringToken = token != null ? StringTools.trimWhitespace(token) : null;
        boolean bl = this.testString = !StringTools.isEmpty(this.stringToken);
        if (this.testString && this.stringRegExp) {
            String regToken = this.stringToken;
            if (!this.caseSensitive) {
                regToken = CASE_INSENSITIVE + this.stringToken;
            }
            if (!"\\0".equals(token)) {
                this.pattern = Pattern.compile(regToken);
            }
        }
    }

    public void setStringPosException(String token, boolean regExp, boolean inflected, boolean negation, boolean scopeNext, boolean scopePrevious, String posToken, boolean posRegExp, boolean posNegation, Boolean caseSensitivity) {
        PatternToken exception = new PatternToken(token, caseSensitivity == null ? this.caseSensitive : caseSensitivity, regExp, inflected);
        exception.setNegation(negation);
        exception.setPosToken(new PosToken(posToken, posRegExp, posNegation));
        exception.exceptionValidNext = scopeNext;
        this.setException(exception, scopePrevious);
    }

    private void setException(PatternToken pToken, boolean scopePrevious) {
        this.exceptionValidPrevious |= scopePrevious;
        if (this.exceptionList == null && !scopePrevious) {
            this.exceptionList = new ArrayList<PatternToken>();
        }
        if (this.previousExceptionList == null && scopePrevious) {
            this.previousExceptionList = new ArrayList<PatternToken>();
        }
        if (scopePrevious) {
            this.previousExceptionList.add(pToken);
        } else {
            if (!this.exceptionSet) {
                this.exceptionSet = true;
            }
            this.exceptionList.add(pToken);
        }
    }

    private boolean isPosTokenMatched(AnalyzedToken token) {
        boolean match;
        if (this.posToken == null || this.posToken.posTag == null) {
            return true;
        }
        if (token.getPosTag() == null) {
            return this.posToken.posUnknown && token.getHasNoTag();
        }
        if (this.posToken.regExp) {
            Matcher mPos = this.posToken.posPattern.matcher(token.getPosTag());
            match = mPos.matches();
        } else {
            match = this.posToken.posTag.equals(token.getPosTag());
        }
        if (!match && this.posToken.posUnknown) {
            match = token.getHasNoTag();
        }
        return match;
    }

    private boolean isStringTokenMatched(AnalyzedToken token) {
        String testToken = this.getTestToken(token);
        if (this.stringRegExp) {
            Matcher m = this.pattern.matcher(testToken);
            return m.matches();
        }
        if (this.caseSensitive) {
            return this.stringToken.equals(testToken);
        }
        return this.stringToken.equalsIgnoreCase(testToken);
    }

    private String getTestToken(AnalyzedToken token) {
        if (this.inflected) {
            if (token.getLemma() != null) {
                return token.getLemma();
            }
            return token.getToken();
        }
        return token.getToken();
    }

    public int getSkipNext() {
        return this.skip;
    }

    public int getMinOccurrence() {
        return this.minOccurrence;
    }

    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public void setSkipNext(int i) {
        this.skip = i;
    }

    public void setMinOccurrence(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("minOccurrences must be 0 or 1: " + i);
        }
        this.minOccurrence = i;
    }

    public void setMaxOccurrence(int i) {
        if (i == 0) {
            throw new IllegalArgumentException("maxOccurrences may not be 0");
        }
        this.maxOccurrence = i;
    }

    public boolean hasPreviousException() {
        return this.exceptionValidPrevious;
    }

    public boolean hasNextException() {
        return this.exceptionValidNext;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }

    public boolean getNegation() {
        return this.negation;
    }

    public boolean isReferenceElement() {
        return this.tokenReference != null;
    }

    public void setMatch(Match match) {
        this.tokenReference = Objects.requireNonNull(match);
    }

    public Match getMatch() {
        return this.tokenReference;
    }

    public PatternToken compile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        PatternToken compiledPatternToken;
        try {
            compiledPatternToken = (PatternToken)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone element", e);
        }
        compiledPatternToken.doCompile(token, synth);
        return compiledPatternToken;
    }

    private void doCompile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        MatchState matchState = this.tokenReference.createState(synth, token);
        if (StringTools.isEmpty(this.referenceString)) {
            this.referenceString = this.stringToken;
        }
        String reference = "\\" + this.tokenReference.getTokenRef();
        if (this.tokenReference.setsPos()) {
            String posReference = matchState.getTargetPosTag();
            if (posReference != null) {
                this.setPosToken(new PosToken(posReference, this.tokenReference.posRegExp(), this.negation));
            }
            this.setStringElement(this.referenceString.replace(reference, ""));
        } else {
            this.setStringElement(this.referenceString.replace(reference, matchState.toTokenString()));
        }
    }

    public void setPhraseName(String id) {
        this.phraseName = id;
    }

    public boolean isPartOfPhrase() {
        return this.phraseName != null;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.stringRegExp;
    }

    public boolean isPOStagRegularExpression() {
        return this.posToken != null && this.posToken.regExp;
    }

    @Nullable
    public String getPOStag() {
        return this.posToken != null ? this.posToken.posTag : null;
    }

    @Nullable
    public ChunkTag getChunkTag() {
        return this.chunkTag;
    }

    public boolean getPOSNegation() {
        return this.posToken != null && this.posToken.negation;
    }

    public boolean isInflected() {
        return this.inflected;
    }

    @Nullable
    public String getPhraseName() {
        return this.phraseName;
    }

    public boolean isUnified() {
        return this.unificationFeatures != null;
    }

    public void setUnification(Map<String, List<String>> uniFeatures) {
        this.unificationFeatures = Objects.requireNonNull(uniFeatures);
    }

    @Nullable
    public Map<String, List<String>> getUniFeatures() {
        return this.unificationFeatures;
    }

    public void setUniNegation() {
        this.uniNegation = true;
    }

    public boolean isUniNegated() {
        return this.uniNegation;
    }

    public boolean isLastInUnification() {
        return this.isLastUnified;
    }

    public void setLastInUnification() {
        this.isLastUnified = true;
    }

    public boolean isUnificationNeutral() {
        return this.unificationNeutral;
    }

    public void setUnificationNeutral() {
        this.unificationNeutral = true;
    }

    public void setWhitespaceBefore(boolean isWhite) {
        this.whitespaceBefore = isWhite;
        this.testWhitespace = true;
    }

    public boolean isInsideMarker() {
        return this.isInsideMarker;
    }

    public void setInsideMarker(boolean isInsideMarker) {
        this.isInsideMarker = isInsideMarker;
    }

    public void setExceptionSpaceBefore(boolean isWhite) {
        if (this.previousExceptionList != null && this.exceptionValidPrevious) {
            this.previousExceptionList.get(this.previousExceptionList.size() - 1).setWhitespaceBefore(isWhite);
        } else if (this.exceptionList != null) {
            this.exceptionList.get(this.exceptionList.size() - 1).setWhitespaceBefore(isWhite);
        }
    }

    public boolean isWhitespaceBefore(AnalyzedToken token) {
        return this.whitespaceBefore == token.isWhitespaceBefore();
    }

    public List<PatternToken> getExceptionList() {
        return this.exceptionList;
    }

    public List<PatternToken> getPreviousExceptionList() {
        return this.previousExceptionList;
    }

    public boolean hasExceptionList() {
        return this.exceptionList != null || this.previousExceptionList != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.negation) {
            sb.append('!');
        }
        sb.append(this.stringToken);
        if (this.phraseName != null) {
            sb.append(" {");
            sb.append(this.phraseName);
            sb.append('}');
        }
        if (this.posToken != null) {
            sb.append('/');
            sb.append(this.posToken);
        }
        if (this.chunkTag != null) {
            sb.append('/');
            sb.append(this.chunkTag);
        }
        if (this.exceptionList != null) {
            sb.append("/exceptions=");
            sb.append(this.exceptionList);
        }
        return sb.toString();
    }

    public static class PosToken {
        private final String posTag;
        private final boolean regExp;
        private final boolean negation;
        private final Pattern posPattern;
        private final boolean posUnknown;

        public PosToken(String posTag, boolean regExp, boolean negation) {
            this.posTag = posTag;
            this.regExp = regExp;
            this.negation = negation;
            if (regExp) {
                this.posPattern = Pattern.compile(posTag);
                this.posUnknown = this.posPattern.matcher(PatternToken.UNKNOWN_TAG).matches();
            } else {
                this.posPattern = null;
                this.posUnknown = PatternToken.UNKNOWN_TAG.equals(posTag);
            }
        }

        public String toString() {
            return this.posTag;
        }
    }
}

