/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.analysis.AnalyzedSentence;
import org.languagetool.language.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public abstract class AbstractDashRule
extends Rule {
    private final List<PatternRule> dashRules;

    public AbstractDashRule(List<PatternRule> dashRules, ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        this.dashRules = Objects.requireNonNull(dashRules);
        this.setDefaultOff();
    }

    @Override
    public String getId() {
        return "DASH_RULE";
    }

    @Override
    public abstract String getDescription();

    @Override
    public int estimateContextForSureMatch() {
        return 2;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        for (PatternRule dashRule : this.dashRules) {
            for (RuleMatch match : dashRule.match(sentence)) {
                RuleMatch rm = new RuleMatch(this, match.getSentence(), match.getFromPos(), match.getToPos(), match.getPatternStartPos(), match.getPatternEndPos(), match.getMessage(), match.getShortMessage(), false, "");
                matches.add(rm);
            }
        }
        return matches.toArray(new RuleMatch[0]);
    }

    protected static List<PatternRule> loadCompoundFile(String path, String msg, Language lang) {
        ArrayList<PatternRule> rules = new ArrayList<PatternRule>();
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
             InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            int counter = 0;
            while ((line = br.readLine()) != null) {
                ++counter;
                if (line.isEmpty() || line.charAt(0) == '#' || line.endsWith("+")) continue;
                if (line.endsWith("*")) {
                    line = AbstractDashRule.removeLastCharacter(line);
                }
                ArrayList<PatternToken> tokList = new ArrayList<PatternToken>();
                String[] tokens = line.split("-");
                int tokenCounter = 0;
                for (String token : tokens) {
                    tokList.add(new PatternToken(token, true, false, false));
                    if (++tokenCounter >= tokens.length) continue;
                    tokList.add(new PatternToken("[\u2014\u2013]", false, true, false));
                }
                PatternRule dashRule = new PatternRule("DASH_RULE" + counter, lang, tokList, "", msg + "<suggestion>" + line.replaceAll("[\u2013\u2014]", "-") + "</suggestion>.", line.replaceAll("[\u2013\u2014]", "-"));
                rules.add(dashRule);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rules;
    }

    private static String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

