/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedTextResource
implements Resource {
    private String contentType;
    private String encoding;
    private String href = null;
    private String unparsedText = null;
    private InputStream inputStream;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new UnparsedTextResource(resourceURI, details);
        }
    };

    public UnparsedTextResource(String href, AbstractResourceCollection.InputDetails details) {
        this.href = href;
        this.inputStream = details.inputStream;
        this.contentType = details.contentType;
        this.encoding = details.encoding;
    }

    @Override
    public String getResourceURI() {
        return this.href;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.unparsedText == null) {
            StringBuilder builder = null;
            try {
                String enc = this.encoding;
                if (enc == null) {
                    enc = StandardUnparsedTextResolver.inferStreamEncoding(this.inputStream, null);
                }
                builder = CatalogCollection.makeStringBuilderFromStream(this.inputStream, enc);
            }
            catch (FileNotFoundException e) {
                throw new XPathException(e);
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
            this.unparsedText = builder.toString();
        }
        return new StringValue(this.unparsedText);
    }

    @Override
    public String getContentType() {
        return this.contentType == null ? "text/plain" : this.contentType;
    }
}

