/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.codeInsight.navigation.PsiElementNavigationTarget;
import com.intellij.model.Pointer;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectSymbol;", "Lcom/intellij/model/presentation/PresentableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "myQualifiedName", "", "", "myRootProjectPath", "(Ljava/util/List;Ljava/lang/String;)V", "myPresentation", "Lcom/intellij/model/presentation/SymbolPresentation;", "Lorg/jetbrains/annotations/NotNull;", "projectName", "getProjectName", "()Ljava/lang/String;", "qualifiedName", "getQualifiedName", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "findBuildFile", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "getNavigationTargets", "", "Lcom/intellij/navigation/NavigationTarget;", "getSymbolPresentation", "hashCode", "", "Companion", "intellij.gradle.java"})
@ApiStatus.Internal
public final class GradleProjectSymbol
implements PresentableSymbol,
NavigatableSymbol {
    private final SymbolPresentation myPresentation;
    private final List<String> myQualifiedName;
    private final String myRootProjectPath;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Pointer<GradleProjectSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)pointer, (String)"Pointer.hardPointer(this)");
        return pointer;
    }

    @NotNull
    public final String getProjectName() {
        return this.myQualifiedName.isEmpty() ? ":" : (String)CollectionsKt.last(this.myQualifiedName);
    }

    @NotNull
    public final String getQualifiedName() {
        return Companion.qualifiedName(this.myQualifiedName);
    }

    @NotNull
    public SymbolPresentation getSymbolPresentation() {
        return this.myPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiFile = this.findBuildFile(project);
        if (psiFile != null) {
            return CollectionsKt.listOf((Object)new PsiElementNavigationTarget(psiFile));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findBuildFile(Project project) {
        ExternalProject externalProject;
        ExternalProject externalProject2 = ExternalProjectDataCache.getInstance((Project)project).getRootExternalProject(this.myRootProjectPath);
        if (externalProject2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)externalProject2, (String)"ExternalProjectDataCache\u2026ojectPath) ?: return null");
        ExternalProject rootProject = externalProject2;
        if (this.myQualifiedName.isEmpty()) {
            externalProject = rootProject;
        } else {
            void $this$fold$iv;
            Iterable iterable = this.myQualifiedName;
            ExternalProject initial$iv = rootProject;
            boolean $i$f$fold = false;
            ExternalProject accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void name;
                String string = (String)element$iv;
                ExternalProject extProject = accumulator$iv;
                boolean bl = false;
                Object object = extProject;
                accumulator$iv = object != null && (object = object.getChildProjects()) != null ? (ExternalProject)object.get(name) : null;
            }
            externalProject = accumulator$iv;
            if (externalProject == null) {
                return null;
            }
        }
        ExternalProject externalProject3 = externalProject;
        File file = externalProject3.getBuildFile();
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"externalProject.buildFile ?: return null");
        File buildFile = file;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(buildFile);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026buildFile) ?: return null");
        VirtualFile virtualFile2 = virtualFile;
        return (PsiElement)PsiManager.getInstance((Project)project).findFile(virtualFile2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol");
        }
        GradleProjectSymbol cfr_ignored_0 = (GradleProjectSymbol)object2;
        if (Intrinsics.areEqual(this.myQualifiedName, ((GradleProjectSymbol)other).myQualifiedName) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.myRootProjectPath, (Object)((GradleProjectSymbol)other).myRootProjectPath) ^ true);
    }

    public int hashCode() {
        int result = ((Object)this.myQualifiedName).hashCode();
        result = 31 * result + this.myRootProjectPath.hashCode();
        return result;
    }

    public GradleProjectSymbol(@NotNull List<String> myQualifiedName, @NotNull String myRootProjectPath) {
        Intrinsics.checkParameterIsNotNull(myQualifiedName, (String)"myQualifiedName");
        Intrinsics.checkParameterIsNotNull((Object)myRootProjectPath, (String)"myRootProjectPath");
        this.myQualifiedName = myQualifiedName;
        this.myRootProjectPath = myRootProjectPath;
        CharSequence charSequence = this.myRootProjectPath;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SymbolPresentation symbolPresentation = SymbolPresentation.create((Icon)GradleIcons.Gradle, (String)this.getProjectName(), (String)GradleBundle.message((String)"gradle.project.0", (Object[])new Object[]{this.getProjectName()}), (String)GradleBundle.message((String)"gradle.project.0", (Object[])new Object[]{this.getQualifiedName()}));
        Intrinsics.checkExpressionValueIsNotNull((Object)symbolPresentation, (String)"SymbolPresentation.creat\u2026ct.0\", qualifiedName)\n  )");
        this.myPresentation = symbolPresentation;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectSymbol$Companion;", "", "()V", "qualifiedName", "", "qualifiedNameParts", "", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final String qualifiedName(@NotNull List<String> qualifiedNameParts) {
            Intrinsics.checkParameterIsNotNull(qualifiedNameParts, (String)"qualifiedNameParts");
            return qualifiedNameParts.isEmpty() ? ":" : CollectionsKt.joinToString$default((Iterable)qualifiedNameParts, (CharSequence)"", null, null, (int)0, null, (Function1)qualifiedName.1.INSTANCE, (int)30, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

