/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.plist.Plist;

public class PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = new HashSet<Preferences>();
    @NotNull
    private final TIntHashSet myLeftHighlightingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myRightHighlightingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myLeftSmartTypingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myRightSmartTypingBraces = new TIntHashSet();

    public PreferencesRegistry() {
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    public void fillFromPList(@NotNull CharSequence scopeName, @NotNull Plist plist) {
        if (scopeName == null) {
            PreferencesRegistry.$$$reportNull$$$0(0);
        }
        if (plist == null) {
            PreferencesRegistry.$$$reportNull$$$0(1);
        }
        Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("highlightingPairs"));
        Set<TextMateBracePair> smartTypingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("smartTypingPairs"));
        this.fillHighlightingBraces(highlightingPairs);
        this.fillSmartTypingBraces(smartTypingPairs);
        if (highlightingPairs != null || smartTypingPairs != null) {
            this.myPreferences.add(new Preferences(scopeName, highlightingPairs, smartTypingPairs));
        }
    }

    public void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                this.myLeftHighlightingBraces.add((int)pair.leftChar);
                this.myRightHighlightingBraces.add((int)pair.rightChar);
            }
        }
    }

    public void fillSmartTypingBraces(Collection<TextMateBracePair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateBracePair pair : smartTypingPairs) {
                this.myLeftSmartTypingBraces.add((int)pair.leftChar);
                this.myRightSmartTypingBraces.add((int)pair.rightChar);
            }
        }
    }

    public boolean isPossibleLeftHighlightingBrace(char c) {
        return this.myLeftHighlightingBraces.contains((int)c) || this.myLeftSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleRightHighlightingBrace(char c) {
        return this.myRightHighlightingBraces.contains((int)c) || this.myRightSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleLeftSmartTypingBrace(char c) {
        return this.myLeftSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleRightSmartTypingBrace(char c) {
        return this.myRightSmartTypingBraces.contains((int)c);
    }

    @NotNull
    public List<Preferences> getPreferences(@NotNull CharSequence scopeSelector) {
        if (scopeSelector == null) {
            PreferencesRegistry.$$$reportNull$$$0(2);
        }
        List<Preferences> list = new TextMateScopeComparator<Preferences>(scopeSelector, Preferences::getScopeSelector).sortAndFilter(this.myPreferences);
        if (list == null) {
            PreferencesRegistry.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillFromPList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

