/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.watch.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.util.IncubationLogger;

class VirtualFileSystemBuildLifecycleListener
implements RootBuildLifecycleListener {
    private final WatchingAwareVirtualFileSystem virtualFileSystem;

    public VirtualFileSystemBuildLifecycleListener(WatchingAwareVirtualFileSystem virtualFileSystem) {
        this.virtualFileSystem = virtualFileSystem;
    }

    @Override
    public void afterStart(GradleInternal gradle) {
        boolean watchFileSystem;
        StartParameterInternal startParameter = (StartParameterInternal)gradle.getStartParameter();
        if (VirtualFileSystemServices.isDeprecatedVfsRetentionPropertyPresent(startParameter)) {
            String deprecatedVfsRetentionEnabledProperty = "org.gradle.unsafe.vfs.retention";
            ((DeprecationMessageBuilder)DeprecationLogger.deprecateIndirectUsage("Using the system property " + deprecatedVfsRetentionEnabledProperty + " to enable watching the file system").withAdvice("Use the gradle property org.gradle.unsafe.watch-fs instead.")).willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
        if (watchFileSystem = startParameter.isWatchFileSystem()) {
            IncubationLogger.incubatingFeatureUsed("Watching the file system");
            if (VirtualFileSystemServices.isDropVfs(startParameter)) {
                this.virtualFileSystem.invalidateAll();
            }
        }
        this.virtualFileSystem.afterBuildStarted(watchFileSystem);
        gradle.settingsEvaluated(settings -> this.virtualFileSystem.updateProjectRootDirectory(settings.getRootDir()));
    }

    @Override
    public void beforeComplete(GradleInternal gradle) {
        this.virtualFileSystem.beforeBuildFinished(((StartParameterInternal)gradle.getStartParameter()).isWatchFileSystem());
    }
}

