/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.gradle.api.Action;
import org.gradle.api.file.RelativePath;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Handle;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;

class InstrumentingTransformer
implements CachedClasspathTransformer.Transform {
    private static final Type SYSTEM_TYPE = Type.getType(System.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type INTEGER_TYPE = Type.getType(Integer.class);
    private static final Type INSTRUMENTED_TYPE = Type.getType(Instrumented.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type SERIALIZED_LAMBDA_TYPE = Type.getType(SerializedLambda.class);
    private static final Type LONG_TYPE = Type.getType(Long.class);
    private static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    private static final String RETURN_PRIMITIVE_BOOLEAN = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
    private static final String RETURN_INT = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING_FROM_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE, STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_OBJECT_FROM_INT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{Type.INT_TYPE});
    private static final String RETURN_BOOLEAN_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{OBJECT_TYPE});
    private static final String RETURN_PROPERTIES = Type.getMethodDescriptor((Type)Type.getType(Properties.class), (Type[])new Type[0]);
    private static final String RETURN_PROPERTIES_FROM_STRING = Type.getMethodDescriptor((Type)Type.getType(Properties.class), (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.getType(CallSiteArray.class), (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CallSiteArray.class)});
    private static final String RETURN_OBJECT_FROM_SERIALIZED_LAMBDA = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{SERIALIZED_LAMBDA_TYPE});
    private static final String INSTRUMENTED_CALL_SITE_METHOD = "$instrumentedCallSiteArray";
    private static final String CREATE_CALL_SITE_ARRAY_METHOD = "$createCallSiteArray";
    private static final String[] NO_EXCEPTIONS = new String[0];

    InstrumentingTransformer() {
    }

    @Override
    public void applyConfigurationTo(Hasher hasher) {
        hasher.putString(InstrumentingTransformer.class.getSimpleName());
        hasher.putInt(8);
    }

    @Override
    public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor) {
        return Pair.of(entry.getPath(), new InstrumentingVisitor(visitor));
    }

    private static class LambdaFactoryDetails {
        final String name;
        final String descriptor;
        final Handle bootstrapMethodHandle;
        final List<?> bootstrapMethodArguments;

        public LambdaFactoryDetails(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
            this.name = name;
            this.descriptor = descriptor;
            this.bootstrapMethodHandle = bootstrapMethodHandle;
            this.bootstrapMethodArguments = bootstrapMethodArguments;
        }
    }

    private static class InstrumentingMethodVisitor
    extends MethodVisitor {
        private final InstrumentingVisitor owner;
        private final String className;

        public InstrumentingMethodVisitor(InstrumentingVisitor owner, MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.owner = owner;
            this.className = owner.className;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 184) {
                if (owner.equals(SYSTEM_TYPE.getInternalName())) {
                    if (name.equals("getProperty")) {
                        if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                            this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                            super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "systemProperty", RETURN_STRING_FROM_STRING_STRING, false);
                            return;
                        }
                        if (descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                            this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                            super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "systemProperty", RETURN_STRING_FROM_STRING_STRING_STRING, false);
                            return;
                        }
                    } else if (name.equals("getProperties") && descriptor.equals(RETURN_PROPERTIES)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "systemProperties", RETURN_PROPERTIES_FROM_STRING, false);
                        return;
                    }
                } else if (owner.equals(INTEGER_TYPE.getInternalName()) && name.equals("getInteger")) {
                    if (descriptor.equals(RETURN_INTEGER_FROM_STRING)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getInteger", RETURN_INTEGER_FROM_STRING_STRING, false);
                        return;
                    }
                    if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INT)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getInteger", RETURN_INTEGER_FROM_STRING_INT_STRING, false);
                        return;
                    }
                    if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INTEGER)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getInteger", RETURN_INTEGER_FROM_STRING_INTEGER_STRING, false);
                        return;
                    }
                } else if (owner.equals(LONG_TYPE.getInternalName()) && name.equals("getLong")) {
                    if (descriptor.equals(RETURN_LONG_FROM_STRING)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getLong", RETURN_LONG_FROM_STRING_STRING, false);
                        return;
                    }
                    if (descriptor.equals(RETURN_LONG_FROM_STRING_PRIMITIVE_LONG)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getLong", RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING, false);
                        return;
                    }
                    if (descriptor.equals(RETURN_LONG_FROM_STRING_LONG)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getLong", RETURN_LONG_FROM_STRING_LONG_STRING, false);
                        return;
                    }
                } else {
                    if (owner.equals(BOOLEAN_TYPE.getInternalName()) && name.equals("getBoolean") && descriptor.equals(RETURN_PRIMITIVE_BOOLEAN_FROM_STRING)) {
                        this.visitLdcInsn(Type.getObjectType((String)this.className).getClassName());
                        super.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "getBoolean", RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING, false);
                        return;
                    }
                    if (owner.equals(this.className) && name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                        super.visitMethodInsn(184, this.className, InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY, false);
                        return;
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (descriptor.endsWith(")" + Type.getType(Action.class).getDescriptor()) && bootstrapMethodHandle.getOwner().equals(Type.getType(LambdaMetafactory.class).getInternalName()) && bootstrapMethodHandle.getName().equals("metafactory")) {
                Handle altMethod = new Handle(6, Type.getType(LambdaMetafactory.class).getInternalName(), "altMetafactory", Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), STRING_TYPE, Type.getType(MethodType.class), Type.getType(Object[].class)}), false);
                ArrayList<Integer> args = new ArrayList<Integer>(bootstrapMethodArguments.length + 1);
                Collections.addAll(args, bootstrapMethodArguments);
                args.add(1);
                super.visitInvokeDynamicInsn(name, descriptor, altMethod, args.toArray());
                this.owner.addSerializedLambda(new LambdaFactoryDetails(name, descriptor, altMethod, args));
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }
    }

    private static class InstrumentingVisitor
    extends ClassVisitor {
        String className;
        private boolean hasGroovyCallSites;
        private final List<LambdaFactoryDetails> lambdaFactories = new ArrayList<LambdaFactoryDetails>();

        public InstrumentingVisitor(ClassVisitor visitor) {
            super(458752, visitor);
        }

        public void addSerializedLambda(LambdaFactoryDetails lambdaFactoryDetails) {
            this.lambdaFactories.add(lambdaFactoryDetails);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this.hasGroovyCallSites = true;
            }
            return new InstrumentingMethodVisitor(this, methodVisitor);
        }

        public void visitEnd() {
            if (this.hasGroovyCallSites) {
                this.generateCallSiteFactoryMethod();
            }
            if (!this.lambdaFactories.isEmpty()) {
                this.generateLambdaDeserializeMethod();
            }
            super.visitEnd();
        }

        private void generateLambdaDeserializeMethod() {
            MethodVisitor methodVisitor = super.visitMethod(4106, "$deserializeLambda$", RETURN_OBJECT_FROM_SERIALIZED_LAMBDA, null, NO_EXCEPTIONS);
            methodVisitor.visitCode();
            Label next = null;
            for (LambdaFactoryDetails factory : this.lambdaFactories) {
                if (next != null) {
                    methodVisitor.visitLabel(next);
                    methodVisitor.visitFrame(3, 0, new Object[0], 0, new Object[0]);
                }
                next = new Label();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, SERIALIZED_LAMBDA_TYPE.getInternalName(), "getImplMethodName", RETURN_STRING, false);
                String implementationName = ((Handle)factory.bootstrapMethodArguments.get(1)).getName();
                methodVisitor.visitLdcInsn((Object)implementationName);
                methodVisitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "equals", RETURN_BOOLEAN_FROM_OBJECT, false);
                methodVisitor.visitJumpInsn(153, next);
                Type[] argumentTypes = Type.getArgumentTypes((String)factory.descriptor);
                for (int i = 0; i < argumentTypes.length; ++i) {
                    Type argumentType = argumentTypes[i];
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitLdcInsn((Object)i);
                    methodVisitor.visitMethodInsn(182, SERIALIZED_LAMBDA_TYPE.getInternalName(), "getCapturedArg", RETURN_OBJECT_FROM_INT, false);
                    AsmClassGeneratorUtils.unboxOrCast(methodVisitor, argumentType);
                }
                methodVisitor.visitInvokeDynamicInsn(factory.name, factory.descriptor, factory.bootstrapMethodHandle, factory.bootstrapMethodArguments.toArray());
                methodVisitor.visitInsn(176);
            }
            methodVisitor.visitLabel(next);
            methodVisitor.visitFrame(3, 0, new Object[0], 0, new Object[0]);
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateCallSiteFactoryMethod() {
            MethodVisitor methodVisitor = super.visitMethod(4106, InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY, null, NO_EXCEPTIONS);
            methodVisitor.visitCode();
            methodVisitor.visitMethodInsn(184, this.className, InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD, RETURN_CALL_SITE_ARRAY, false);
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(184, INSTRUMENTED_TYPE.getInternalName(), "groovyCallSites", RETURN_VOID_FROM_CALL_SITE_ARRAY, false);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(2, 0);
            methodVisitor.visitEnd();
        }
    }
}

