/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class CompositeCleanupAction
implements CleanupAction {
    private final List<CleanupAction> cleanups;

    public static Builder builder() {
        return new Builder();
    }

    private CompositeCleanupAction(List<CleanupAction> cleanups) {
        this.cleanups = cleanups;
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        for (CleanupAction action : this.cleanups) {
            action.clean(cleanableStore, progressMonitor);
        }
    }

    private static class CleanableSubDir
    implements CleanableStore {
        private final CleanableStore delegate;
        private final File subDir;
        private final String displayName;

        CleanableSubDir(CleanableStore delegate, File subDir) {
            this.delegate = delegate;
            this.subDir = subDir;
            this.displayName = delegate.getDisplayName() + " [subdir: " + subDir + "]";
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public File getBaseDir() {
            return this.subDir;
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return this.delegate.getReservedCacheFiles();
        }
    }

    private static class ScopedCleanupAction
    implements CleanupAction {
        private final File baseDir;
        private final CleanupAction action;

        ScopedCleanupAction(File baseDir, CleanupAction action) {
            this.baseDir = baseDir;
            this.action = action;
        }

        @Override
        public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
            this.action.clean(new CleanableSubDir(cleanableStore, this.baseDir), progressMonitor);
        }
    }

    public static class Builder {
        private List<CleanupAction> cleanups = new ArrayList<CleanupAction>();

        private Builder() {
        }

        public Builder add(CleanupAction ... actions) {
            Collections.addAll(this.cleanups, actions);
            return this;
        }

        public Builder add(File baseDir, CleanupAction ... actions) {
            for (CleanupAction action : actions) {
                this.cleanups.add(new ScopedCleanupAction(baseDir, action));
            }
            return this;
        }

        public CompositeCleanupAction build() {
            return new CompositeCleanupAction((List)ImmutableList.copyOf(this.cleanups));
        }
    }
}

