/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionContainer;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class DefaultFileCollectionResolveContext
implements ResolvableFileCollectionResolveContext {
    private final List<Object> queue = new LinkedList<Object>();
    private final Converter<? extends FileCollectionInternal> fileCollectionConverter;
    private final Converter<? extends FileTreeInternal> fileTreeConverter;

    public DefaultFileCollectionResolveContext(Factory<PatternSet> patternSetFactory) {
        this(new FileCollectionConverter(patternSetFactory), new FileTreeConverter(patternSetFactory));
    }

    private DefaultFileCollectionResolveContext(Converter<? extends FileCollectionInternal> fileCollectionConverter, Converter<? extends FileTreeInternal> fileTreeConverter) {
        this.fileCollectionConverter = fileCollectionConverter;
        this.fileTreeConverter = fileTreeConverter;
    }

    @Override
    public FileCollectionResolveContext addAll(Iterable<?> elements) {
        for (Object element : elements) {
            this.add(element);
        }
        return this;
    }

    @Override
    public FileCollectionResolveContext add(Object element) {
        if (element instanceof FileCollectionContainer) {
            FileCollectionContainer container = (FileCollectionContainer)element;
            container.visitContents(this);
        } else {
            this.queue.add(element);
        }
        return this;
    }

    @Override
    public boolean maybeAdd(Object element) {
        return false;
    }

    @Override
    public FileCollectionResolveContext add(Object element, PathToFileResolver resolver) {
        this.queue.add(resolver.resolve(element));
        return this;
    }

    @Override
    public final ResolvableFileCollectionResolveContext newContext() {
        return new DefaultFileCollectionResolveContext(this.fileCollectionConverter, this.fileTreeConverter);
    }

    @Override
    public ImmutableList<FileTreeInternal> resolveAsFileTrees() {
        return this.doResolve(this.fileTreeConverter);
    }

    @Override
    public ImmutableList<FileCollectionInternal> resolveAsFileCollections() {
        return this.doResolve(this.fileCollectionConverter);
    }

    private <T> ImmutableList<T> doResolve(Converter<? extends T> converter) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Object element : this.queue) {
            converter.convertInto(element, (ImmutableCollection.Builder<T>)result);
        }
        return result.build();
    }

    public static class FileTreeConverter
    implements Converter<FileTreeInternal> {
        private final Factory<PatternSet> patternSetFactory;

        public FileTreeConverter(Factory<PatternSet> patternSetFactory) {
            this.patternSetFactory = patternSetFactory;
        }

        @Override
        public void convertInto(Object element, ImmutableCollection.Builder<? super FileTreeInternal> result) {
            if (element instanceof FileTree) {
                FileTree fileTree = (FileTree)element;
                result.add((Object)Cast.cast(FileTreeInternal.class, fileTree));
            } else if (element instanceof MinimalFileTree) {
                MinimalFileTree fileTree = (MinimalFileTree)element;
                result.add((Object)new FileTreeAdapter(fileTree, this.patternSetFactory));
            } else if (element instanceof MinimalFileSet) {
                MinimalFileSet fileSet = (MinimalFileSet)element;
                for (File file : fileSet.getFiles()) {
                    this.convertFileToFileTree(file, result);
                }
            } else if (element instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)element;
                for (File file : fileCollection) {
                    this.convertFileToFileTree(file, result);
                }
            } else {
                if (element instanceof MinimalFileCollection) {
                    throw new IllegalArgumentException(String.format("Cannot convert instance of %s to FileTree", element.getClass().getSimpleName()));
                }
                if (element instanceof TaskDependency) {
                    return;
                }
                if (element instanceof File) {
                    this.convertFileToFileTree((File)element, result);
                } else {
                    throw new IllegalArgumentException("Don't know how to convert element into a FileTree: " + element);
                }
            }
        }

        private void convertFileToFileTree(File file, ImmutableCollection.Builder<? super FileTreeInternal> result) {
            result.add((Object)new FileTreeAdapter(new DirectoryFileTree(file, this.patternSetFactory.create(), FileSystems.getDefault()), this.patternSetFactory));
        }
    }

    public static class FileCollectionConverter
    implements Converter<FileCollectionInternal> {
        private final Factory<PatternSet> patternSetFactory;

        public FileCollectionConverter(Factory<PatternSet> patternSetFactory) {
            this.patternSetFactory = patternSetFactory;
        }

        @Override
        public void convertInto(Object element, ImmutableCollection.Builder<? super FileCollectionInternal> result) {
            if (element instanceof FileCollection) {
                FileCollection fileCollection = (FileCollection)element;
                result.add((Object)Cast.cast(FileCollectionInternal.class, fileCollection));
            } else if (element instanceof MinimalFileTree) {
                MinimalFileTree fileTree = (MinimalFileTree)element;
                result.add((Object)new FileTreeAdapter(fileTree, this.patternSetFactory));
            } else if (element instanceof MinimalFileSet) {
                MinimalFileSet fileSet = (MinimalFileSet)element;
                result.add((Object)new FileCollectionAdapter(fileSet));
            } else {
                if (element instanceof MinimalFileCollection) {
                    throw new IllegalArgumentException(String.format("Cannot convert instance of %s to FileCollection", element.getClass().getSimpleName()));
                }
                if (element instanceof TaskDependency) {
                    return;
                }
                if (element instanceof File) {
                    result.add((Object)new FileCollectionAdapter(new ListBackedFileSet((File)element)));
                } else {
                    throw new IllegalArgumentException("Don't know how to convert element into a FileCollection: " + element);
                }
            }
        }
    }

    protected static interface Converter<T> {
        public void convertInto(Object var1, ImmutableCollection.Builder<? super T> var2);
    }
}

