/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.mvnsettings;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.artifacts.mvnsettings.CannotLocateLocalMavenRepositoryException;
import org.gradle.api.internal.artifacts.mvnsettings.MavenFileLocations;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.internal.impldep.org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.gradle.internal.impldep.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.gradle.internal.impldep.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.settings.building.SettingsBuildingException;
import org.gradle.internal.impldep.org.apache.maven.settings.building.SettingsBuildingRequest;
import org.gradle.internal.impldep.org.apache.maven.settings.building.SettingsBuildingResult;
import org.gradle.internal.impldep.org.apache.maven.settings.io.DefaultSettingsReader;

public class DefaultMavenSettingsProvider
implements MavenSettingsProvider {
    private final MavenFileLocations mavenFileLocations;

    public DefaultMavenSettingsProvider(MavenFileLocations mavenFileLocations) {
        this.mavenFileLocations = mavenFileLocations;
    }

    @Override
    public Settings buildSettings() throws SettingsBuildingException {
        DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder defaultSettingsBuilder = factory.newInstance();
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(this.mavenFileLocations.getUserSettingsFile());
        settingsBuildingRequest.setGlobalSettingsFile(this.mavenFileLocations.getGlobalSettingsFile());
        SettingsBuildingResult settingsBuildingResult = defaultSettingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        return settingsBuildingResult.getEffectiveSettings();
    }

    @Override
    public String getLocalRepository() {
        String localRepo = this.readLocalRepository(this.mavenFileLocations.getUserSettingsFile());
        if (localRepo == null) {
            localRepo = this.readLocalRepository(this.mavenFileLocations.getGlobalSettingsFile());
        }
        return localRepo;
    }

    private String readLocalRepository(File settingsFile) {
        if (settingsFile == null || !settingsFile.exists()) {
            return null;
        }
        Map<String, Boolean> options = Collections.singletonMap("org.gradle.internal.impldep.org.apache.maven.settings.io.isStrict", Boolean.FALSE);
        DefaultSettingsReader settingsReader = new DefaultSettingsReader();
        try {
            String localRepository = settingsReader.read(settingsFile, options).getLocalRepository();
            return StringUtils.isEmpty((String)localRepository) ? null : localRepository;
        }
        catch (Exception parseException) {
            throw new CannotLocateLocalMavenRepositoryException("Unable to parse local Maven settings: " + settingsFile.getAbsolutePath(), parseException);
        }
    }
}

