/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.internal.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.internal.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.internal.artifacts.cache.ResolutionControl;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;

public class DefaultCachePolicy
implements CachePolicy {
    private static final int SECONDS_IN_DAY = 86400;
    final List<Action<? super DependencyResolutionControl>> dependencyCacheRules;
    final List<Action<? super ModuleResolutionControl>> moduleCacheRules;
    final List<Action<? super ArtifactResolutionControl>> artifactCacheRules;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;

    public DefaultCachePolicy() {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>();
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>();
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>();
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingArtifactsFor(86400, TimeUnit.SECONDS);
    }

    DefaultCachePolicy(DefaultCachePolicy policy) {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>(policy.dependencyCacheRules);
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>(policy.moduleCacheRules);
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>(policy.artifactCacheRules);
    }

    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public void setOffline() {
        this.eachDependency(ResolutionControl::useCachedResult);
        this.eachModule(ResolutionControl::useCachedResult);
        this.eachArtifact(ResolutionControl::useCachedResult);
    }

    @Override
    public void setRefreshDependencies() {
        this.eachDependency(dependencyResolutionControl -> dependencyResolutionControl.cacheFor(0, TimeUnit.SECONDS));
        this.eachModule(moduleResolutionControl -> moduleResolutionControl.cacheFor(0, TimeUnit.SECONDS));
        this.eachArtifact(artifactResolutionControl -> artifactResolutionControl.cacheFor(0, TimeUnit.SECONDS));
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit unit) {
        this.eachDependency(dependencyResolutionControl -> {
            if (!((Set)dependencyResolutionControl.getCachedResult()).isEmpty()) {
                dependencyResolutionControl.cacheFor(value, unit);
            }
        });
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.eachModule(moduleResolutionControl -> {
            if (moduleResolutionControl.isChanging()) {
                moduleResolutionControl.cacheFor(value, units);
            }
        });
        this.eachArtifact(artifactResolutionControl -> {
            if (artifactResolutionControl.belongsToChangingModule()) {
                artifactResolutionControl.cacheFor(value, units);
            }
        });
    }

    private void cacheMissingArtifactsFor(int value, TimeUnit units) {
        this.eachArtifact(artifactResolutionControl -> {
            if (artifactResolutionControl.getCachedResult() == null) {
                artifactResolutionControl.cacheFor(value, units);
            }
        });
    }

    private void eachDependency(Action<? super DependencyResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyCacheRules.add(0, rule);
    }

    private void eachModule(Action<? super ModuleResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.moduleCacheRules.add(0, rule);
    }

    private void eachArtifact(Action<? super ArtifactResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.artifactCacheRules.add(0, rule);
    }

    @Override
    public boolean mustRefreshVersionList(ModuleIdentifier moduleIdentifier, Set<ModuleVersionIdentifier> matchingVersions, long ageMillis) {
        CachedDependencyResolutionControl dependencyResolutionControl = new CachedDependencyResolutionControl(moduleIdentifier, matchingVersions, ageMillis);
        for (Action<? super DependencyResolutionControl> rule : this.dependencyCacheRules) {
            rule.execute(dependencyResolutionControl);
            if (!dependencyResolutionControl.ruleMatch()) continue;
            return dependencyResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshMissingModule(ModuleComponentIdentifier component, long ageMillis) {
        return this.mustRefreshModule(component, null, ageMillis, false);
    }

    @Override
    public boolean mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, long ageMillis) {
        return this.mustRefreshModule(component, resolvedModuleVersion, ageMillis, false);
    }

    @Override
    public boolean mustRefreshModule(ResolvedModuleVersion resolvedModuleVersion, long ageMillis, boolean changing) {
        return this.mustRefreshModule(resolvedModuleVersion.getId(), resolvedModuleVersion, ageMillis, changing);
    }

    @Override
    public boolean mustRefreshChangingModule(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, long ageMillis) {
        return this.mustRefreshModule(component, resolvedModuleVersion, ageMillis, true);
    }

    private boolean mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion version, long ageMillis, boolean changingModule) {
        return this.mustRefreshModule(DefaultModuleVersionIdentifier.newId(component.getModuleIdentifier(), component.getVersion()), version, ageMillis, changingModule);
    }

    private boolean mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion version, long ageMillis, boolean changingModule) {
        CachedModuleResolutionControl moduleResolutionControl = new CachedModuleResolutionControl(moduleVersionId, version, changingModule, ageMillis);
        for (Action<? super ModuleResolutionControl> rule : this.moduleCacheRules) {
            rule.execute(moduleResolutionControl);
            if (!moduleResolutionControl.ruleMatch()) continue;
            return moduleResolutionControl.mustCheck();
        }
        return false;
    }

    @Override
    public boolean mustRefreshModuleArtifacts(ModuleVersionIdentifier moduleVersionId, Set<ArtifactIdentifier> artifacts, long ageMillis, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            return true;
        }
        return this.mustRefreshModule(moduleVersionId, (ResolvedModuleVersion)new DefaultResolvedModuleVersion(moduleVersionId), ageMillis, belongsToChangingModule);
    }

    @Override
    public boolean mustRefreshArtifact(ArtifactIdentifier artifactIdentifier, File cachedArtifactFile, long ageMillis, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedArtifactResolutionControl artifactResolutionControl = new CachedArtifactResolutionControl(artifactIdentifier, cachedArtifactFile, ageMillis, belongsToChangingModule);
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            return true;
        }
        for (Action<? super ArtifactResolutionControl> rule : this.artifactCacheRules) {
            rule.execute(artifactResolutionControl);
            if (!artifactResolutionControl.ruleMatch()) continue;
            return artifactResolutionControl.mustCheck();
        }
        return false;
    }

    DefaultCachePolicy copy() {
        return new DefaultCachePolicy(this);
    }

    private class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ArtifactIdentifier, File>
    implements ArtifactResolutionControl {
        private final boolean belongsToChangingModule;

        private CachedArtifactResolutionControl(ArtifactIdentifier artifactIdentifier, File cachedResult, long ageMillis, boolean belongsToChangingModule) {
            super(artifactIdentifier, cachedResult, ageMillis);
            this.belongsToChangingModule = belongsToChangingModule;
        }

        @Override
        public boolean belongsToChangingModule() {
            return this.belongsToChangingModule;
        }
    }

    private class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion cachedVersion, boolean changing, long ageMillis) {
            super(moduleVersionId, cachedVersion, ageMillis);
            this.changing = changing;
        }

        @Override
        public boolean isChanging() {
            return this.changing;
        }
    }

    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleIdentifier, Set<ModuleVersionIdentifier>>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleIdentifier request, Set<ModuleVersionIdentifier> result, long ageMillis) {
            super(request, result, ageMillis);
        }
    }

    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B> {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A request, B cachedResult, long ageMillis) {
            this.request = request;
            this.cachedResult = cachedResult;
            this.ageMillis = this.correctForClockShift(ageMillis);
        }

        private long correctForClockShift(long ageMillis) {
            if (ageMillis < 0L) {
                return 1L;
            }
            return ageMillis;
        }

        @Override
        public A getRequest() {
            return this.request;
        }

        @Override
        public B getCachedResult() {
            return this.cachedResult;
        }

        @Override
        public void cacheFor(int value, TimeUnit units) {
            long expiryMillis = TimeUnit.MILLISECONDS.convert(value, units);
            this.setMustCheck(this.ageMillis > expiryMillis);
        }

        @Override
        public void useCachedResult() {
            this.setMustCheck(false);
        }

        @Override
        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean val) {
            this.ruleMatch = true;
            this.mustCheck = val;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        public boolean mustCheck() {
            return this.mustCheck;
        }
    }
}

