/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.model.alphabet;

import com.intellij.grazie.detector.model.alphabet.Alphabet$Companion$WhenMappings;
import com.intellij.grazie.detector.model.alphabet.NoneAlphabet;
import com.intellij.grazie.detector.model.alphabet.RegexAlphabet;
import com.intellij.grazie.detector.model.alphabet.SetBasedAlphabet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0017\b&\u0018\u0000 \u000f2\u00020\u0001:\u0013\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet;", "", "group", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "(Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;)V", "getGroup", "()Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "matchAny", "", "input", "", "matchAnySpecial", "matchAnyUnique", "matchEntire", "CHINESE", "Companion", "DUTCH", "ENGLISH", "FRENCH", "GERMAN", "GREEK", "Group", "ITALIAN", "JAPANESE", "NONE", "PERSIAN", "POLISH", "PORTUGUESE", "ROMANIAN", "RUSSIAN", "SLOVAK", "SPANISH", "UKRANIAN", "language-detector"})
public abstract class Alphabet {
    @NotNull
    private final Group group;
    @NotNull
    private static final LinkedHashSet<Alphabet> all;
    @NotNull
    private static final LinkedHashSet<SetBasedAlphabet> latin;
    @NotNull
    private static final LinkedHashSet<GREEK> greek;
    @NotNull
    private static final LinkedHashSet<PERSIAN> persian;
    @NotNull
    private static final LinkedHashSet<SetBasedAlphabet> cyrillic;
    @NotNull
    private static final LinkedHashSet<RegexAlphabet> asian;
    public static final Companion Companion;

    public abstract boolean matchEntire(@NotNull CharSequence var1);

    public abstract boolean matchAny(@NotNull CharSequence var1);

    public abstract boolean matchAnySpecial(@NotNull CharSequence var1);

    public abstract boolean matchAnyUnique(@NotNull CharSequence var1);

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    public Alphabet(@NotNull Group group) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)group), (String)"group");
        this.group = group;
    }

    static {
        Companion = new Companion(null);
        all = SetsKt.linkedSetOf((Object[])new Alphabet[]{ENGLISH.INSTANCE, FRENCH.INSTANCE, GERMAN.INSTANCE, DUTCH.INSTANCE, ITALIAN.INSTANCE, POLISH.INSTANCE, PORTUGUESE.INSTANCE, ROMANIAN.INSTANCE, SLOVAK.INSTANCE, SPANISH.INSTANCE, GREEK.INSTANCE, PERSIAN.INSTANCE, CHINESE.INSTANCE, JAPANESE.INSTANCE});
        latin = SetsKt.linkedSetOf((Object[])new SetBasedAlphabet[]{ENGLISH.INSTANCE, FRENCH.INSTANCE, GERMAN.INSTANCE, DUTCH.INSTANCE, ITALIAN.INSTANCE, POLISH.INSTANCE, PORTUGUESE.INSTANCE, ROMANIAN.INSTANCE, SLOVAK.INSTANCE, SPANISH.INSTANCE});
        greek = SetsKt.linkedSetOf((Object[])new GREEK[]{GREEK.INSTANCE});
        persian = SetsKt.linkedSetOf((Object[])new PERSIAN[]{PERSIAN.INSTANCE});
        cyrillic = SetsKt.linkedSetOf((Object[])new SetBasedAlphabet[]{RUSSIAN.INSTANCE, UKRANIAN.INSTANCE});
        asian = SetsKt.linkedSetOf((Object[])new RegexAlphabet[]{CHINESE.INSTANCE, JAPANESE.INSTANCE});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "", "regex", "Lkotlin/text/Regex;", "(Ljava/lang/String;ILkotlin/text/Regex;)V", "matchAny", "", "input", "", "matchEntire", "LATIN", "GREEK", "PERSIAN", "ASIAN", "CYRILLIC", "NONE", "Companion", "language-detector"})
    public static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group LATIN;
        public static final /* enum */ Group GREEK;
        public static final /* enum */ Group PERSIAN;
        public static final /* enum */ Group ASIAN;
        public static final /* enum */ Group CYRILLIC;
        public static final /* enum */ Group NONE;
        private static final /* synthetic */ Group[] $VALUES;
        private final Regex regex;
        @NotNull
        private static final List<Group> all;
        public static final Companion Companion;

        static {
            Group[] groupArray = new Group[6];
            Group[] groupArray2 = groupArray;
            groupArray[0] = LATIN = new Group(new Regex("[\\p{IsLatin}]+"));
            groupArray[1] = GREEK = new Group(new Regex("[\\p{IsGreek}]+"));
            groupArray[2] = PERSIAN = new Group(new Regex("[\\p{IsArabic}|\\u200C]+"));
            groupArray[3] = ASIAN = new Group(new Regex("[\\p{IsHan}|\\p{IsHiragana}|\\p{IsKatakana}]+"));
            groupArray[4] = CYRILLIC = new Group(new Regex("[\\p{IsCyrillic}]+"));
            groupArray[5] = NONE = new Group(new Regex(""));
            $VALUES = groupArray;
            Companion = new Companion(null);
            all = CollectionsKt.listOf((Object[])new Group[]{LATIN, GREEK, PERSIAN, ASIAN, CYRILLIC});
        }

        public final boolean matchAny(@NotNull CharSequence input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            return this.regex.containsMatchIn(input);
        }

        public final boolean matchEntire(@NotNull CharSequence input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            return this.regex.matches(input);
        }

        private Group(Regex regex) {
            this.regex = regex;
        }

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String string) {
            return Enum.valueOf(Group.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group$Companion;", "", "()V", "all", "", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "getAll", "()Ljava/util/List;", "language-detector"})
        public static final class Companion {
            @NotNull
            public final List<Group> getAll() {
                return all;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ENGLISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class ENGLISH
    extends SetBasedAlphabet {
        public static final ENGLISH INSTANCE;

        private ENGLISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz", "", "");
        }

        static {
            ENGLISH eNGLISH;
            INSTANCE = eNGLISH = new ENGLISH();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$FRENCH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class FRENCH
    extends SetBasedAlphabet {
        public static final FRENCH INSTANCE;

        private FRENCH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u00e0\u00e2\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff", "\u0152\u00db");
        }

        static {
            FRENCH fRENCH;
            INSTANCE = fRENCH = new FRENCH();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GERMAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class GERMAN
    extends SetBasedAlphabet {
        public static final GERMAN INSTANCE;

        private GERMAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df", "\u00e4\u00f6\u00fc\u00df", "\u00f6\u00df");
        }

        static {
            GERMAN gERMAN;
            INSTANCE = gERMAN = new GERMAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$DUTCH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class DUTCH
    extends SetBasedAlphabet {
        public static final DUTCH INSTANCE;

        private DUTCH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00eb\u00ef\u0133", "\u00e0\u00e9\u00eb\u00ef\u0133", "\u0133");
        }

        static {
            DUTCH dUTCH;
            INSTANCE = dUTCH = new DUTCH();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ITALIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class ITALIAN
    extends SetBasedAlphabet {
        public static final ITALIAN INSTANCE;

        private ITALIAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00e0\u00e9\u00e8\u00ec\u00f2\u00f9", "\u00ec\u00f2");
        }

        static {
            ITALIAN iTALIAN;
            INSTANCE = iTALIAN = new ITALIAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$POLISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class POLISH
    extends SetBasedAlphabet {
        public static final POLISH INSTANCE;

        private POLISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u00f3\u017c\u0107\u0119\u015b\u017a", "\u0105\u0142\u0144\u017c\u0107\u0119\u015b\u017a");
        }

        static {
            POLISH pOLISH;
            INSTANCE = pOLISH = new POLISH();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$PORTUGUESE;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class PORTUGUESE
    extends SetBasedAlphabet {
        public static final PORTUGUESE INSTANCE;

        private PORTUGUESE() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5\u00e7\u00e1\u00e9\u00ed\u00f3\u00fa\u00e2\u00ea\u00f4\u00e0", "\u00e3\u00f5");
        }

        static {
            PORTUGUESE pORTUGUESE;
            INSTANCE = pORTUGUESE = new PORTUGUESE();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$ROMANIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class ROMANIAN
    extends SetBasedAlphabet {
        public static final ROMANIAN INSTANCE;

        private ROMANIAN() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u00ee\u00e2\u015f\u0163", "\u0103\u015f\u0163");
        }

        static {
            ROMANIAN rOMANIAN;
            INSTANCE = rOMANIAN = new ROMANIAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SLOVAK;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class SLOVAK
    extends SetBasedAlphabet {
        public static final SLOVAK INSTANCE;

        private SLOVAK() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u017e\u0161\u010d\u00e1\u00e4\u010f\u00e9\u00ed\u013e\u013a\u0148\u00f3\u00f4\u0155\u0165\u00fa\u00fd", "\u017e\u0161\u010d\u010f\u013e\u013a\u0148\u0155\u0165\u00fd");
        }

        static {
            SLOVAK sLOVAK;
            INSTANCE = sLOVAK = new SLOVAK();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$SPANISH;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class SPANISH
    extends SetBasedAlphabet {
        public static final SPANISH INSTANCE;

        private SPANISH() {
            super(Group.LATIN, "abcdefghijklmnopqrstuvwxyz\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00e1\u00e9\u00ed\u00f1\u00f3\u00fa\u00fc\u00a1\u00bf", "\u00f1\u00a1\u00bf");
        }

        static {
            SPANISH sPANISH;
            INSTANCE = sPANISH = new SPANISH();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GREEK;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "language-detector"})
    public static final class GREEK
    extends RegexAlphabet {
        public static final GREEK INSTANCE;

        private GREEK() {
            super(Group.GREEK, new Regex("[\\p{IsGreek}]+"), null, null, 12, null);
        }

        static {
            GREEK gREEK;
            INSTANCE = gREEK = new GREEK();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$PERSIAN;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "language-detector"})
    public static final class PERSIAN
    extends RegexAlphabet {
        public static final PERSIAN INSTANCE;

        private PERSIAN() {
            super(Group.PERSIAN, new Regex("[\\p{IsArabic}|\\u200C]+"), null, null, 12, null);
        }

        static {
            PERSIAN pERSIAN;
            INSTANCE = pERSIAN = new PERSIAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$CHINESE;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "language-detector"})
    public static final class CHINESE
    extends RegexAlphabet {
        public static final CHINESE INSTANCE;

        private CHINESE() {
            super(Group.ASIAN, new Regex("[\\p{IsHan}]+"), null, null, 12, null);
        }

        static {
            CHINESE cHINESE;
            INSTANCE = cHINESE = new CHINESE();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$JAPANESE;", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "()V", "language-detector"})
    public static final class JAPANESE
    extends RegexAlphabet {
        public static final JAPANESE INSTANCE;

        private JAPANESE() {
            super(Group.ASIAN, new Regex("[\\p{IsHan}|\\p{IsHiragana}|\\p{IsKatakana}]+"), null, null, 12, null);
        }

        static {
            JAPANESE jAPANESE;
            INSTANCE = jAPANESE = new JAPANESE();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$RUSSIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class RUSSIAN
    extends SetBasedAlphabet {
        public static final RUSSIAN INSTANCE;

        private RUSSIAN() {
            super(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "\u0451\u0439\u044a\u044b\u044d", "\u0451\u0439\u044a\u044b\u044d");
        }

        static {
            RUSSIAN rUSSIAN;
            INSTANCE = rUSSIAN = new RUSSIAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$UKRANIAN;", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "()V", "language-detector"})
    public static final class UKRANIAN
    extends SetBasedAlphabet {
        public static final UKRANIAN INSTANCE;

        private UKRANIAN() {
            super(Group.CYRILLIC, "\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044c\u044e\u044f", "\u0454\u0456\u0457\u0491", "\u0454\u0456\u0457\u0491");
        }

        static {
            UKRANIAN uKRANIAN;
            INSTANCE = uKRANIAN = new UKRANIAN();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$NONE;", "Lcom/intellij/grazie/detector/model/alphabet/NoneAlphabet;", "()V", "language-detector"})
    public static final class NONE
    extends NoneAlphabet {
        public static final NONE INSTANCE;

        private NONE() {
        }

        static {
            NONE nONE;
            INSTANCE = nONE = new NONE();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0018\u001a\u00020\u0019R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0004j\b\u0012\u0004\u0012\u00020\r`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0004j\b\u0012\u0004\u0012\u00020\u0010`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0004j\b\u0012\u0004\u0012\u00020\r`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0004j\b\u0012\u0004\u0012\u00020\u0015`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Companion;", "", "()V", "all", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet;", "Lkotlin/collections/LinkedHashSet;", "getAll", "()Ljava/util/LinkedHashSet;", "asian", "Lcom/intellij/grazie/detector/model/alphabet/RegexAlphabet;", "getAsian", "cyrillic", "Lcom/intellij/grazie/detector/model/alphabet/SetBasedAlphabet;", "getCyrillic", "greek", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$GREEK;", "getGreek", "latin", "getLatin", "persian", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$PERSIAN;", "getPersian", "byGroup", "group", "Lcom/intellij/grazie/detector/model/alphabet/Alphabet$Group;", "language-detector"})
    public static final class Companion {
        @NotNull
        public final LinkedHashSet<Alphabet> getAll() {
            return all;
        }

        @NotNull
        public final LinkedHashSet<SetBasedAlphabet> getLatin() {
            return latin;
        }

        @NotNull
        public final LinkedHashSet<GREEK> getGreek() {
            return greek;
        }

        @NotNull
        public final LinkedHashSet<PERSIAN> getPersian() {
            return persian;
        }

        @NotNull
        public final LinkedHashSet<SetBasedAlphabet> getCyrillic() {
            return cyrillic;
        }

        @NotNull
        public final LinkedHashSet<RegexAlphabet> getAsian() {
            return asian;
        }

        @NotNull
        public final LinkedHashSet<? extends Alphabet> byGroup(@NotNull Group group) {
            LinkedHashSet<Alphabet> linkedHashSet;
            Intrinsics.checkParameterIsNotNull((Object)((Object)group), (String)"group");
            switch (Alphabet$Companion$WhenMappings.$EnumSwitchMapping$0[group.ordinal()]) {
                case 1: {
                    linkedHashSet = this.getLatin();
                    break;
                }
                case 2: {
                    linkedHashSet = this.getGreek();
                    break;
                }
                case 3: {
                    linkedHashSet = this.getPersian();
                    break;
                }
                case 4: {
                    linkedHashSet = this.getAsian();
                    break;
                }
                case 5: {
                    linkedHashSet = this.getCyrillic();
                    break;
                }
                case 6: {
                    linkedHashSet = SetsKt.linkedSetOf((Object[])new NONE[]{NONE.INSTANCE});
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return linkedHashSet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

