/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final ReachableNodes myReachableNodes;

    private PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<? extends CommitId> branchesCommitId) {
        if (permanentLinearGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(0);
        }
        if (permanentGraphLayout == null) {
            PermanentGraphImpl.$$$reportNull$$$0(1);
        }
        if (permanentCommitsInfo == null) {
            PermanentGraphImpl.$$$reportNull$$$0(2);
        }
        if (graphColorManager == null) {
            PermanentGraphImpl.$$$reportNull$$$0(3);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(4);
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize(() -> BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter()));
    }

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<? extends CommitId> branchesCommitId) {
        if (graphCommits == null) {
            PermanentGraphImpl.$$$reportNull$$$0(5);
        }
        if (graphColorManager == null) {
            PermanentGraphImpl.$$$reportNull$$$0(6);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(7);
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        PermanentCommitsInfoImpl commitIdPermanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, (nodeIndex1, nodeIndex2) -> {
            Object commitId1 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex1);
            Object commitId2 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex2);
            return graphColorManager.compareHeads(commitId1, commitId2);
        });
        return new PermanentGraphImpl<CommitId>(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
    }

    @NotNull
    private LinearGraphController createBaseController(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(8);
        }
        if (sortType == PermanentGraph.SortType.Normal) {
            return new BaseController(this);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            return new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), (PermanentGraphInfo)this);
        }
        return new BekBaseController(this, (BekIntMap)this.myBekIntMap.get());
    }

    @NotNull
    private LinearGraphController createFilteredController(@NotNull LinearGraphController baseController, @NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        Set<Integer> visibleHeadsIds;
        if (baseController == null) {
            PermanentGraphImpl.$$$reportNull$$$0(9);
        }
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(10);
        }
        Set<Integer> set = visibleHeadsIds = visibleHeads != null ? this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true) : null;
        if (matchingCommits != null) {
            return new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits), visibleHeadsIds);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            if (visibleHeadsIds != null) {
                return new BranchFilterController(baseController, this, visibleHeadsIds);
            }
            LinearGraphController linearGraphController = baseController;
            if (linearGraphController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(11);
            }
            return linearGraphController;
        }
        return new CollapsedController(baseController, this, visibleHeadsIds);
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits, @NotNull BiConsumer<? super LinearGraphController, ? super PermanentGraphInfo<CommitId>> preprocessor2) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(12);
        }
        if (preprocessor2 == null) {
            PermanentGraphImpl.$$$reportNull$$$0(13);
        }
        LinearGraphController controller = this.createFilteredController(this.createBaseController(sortType), sortType, visibleHeads, matchingCommits);
        preprocessor2.accept(controller, this);
        return new VisibleGraphImpl<CommitId>(controller, this, this.myGraphColorManager);
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(14);
        }
        VisibleGraph<? extends CommitId> visibleGraph = this.createVisibleGraph(sortType, visibleHeads, matchingCommits, (controller, info) -> {});
        if (visibleGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(15);
        }
        return visibleGraph;
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                Object commitId = PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(index);
                List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(PermanentGraphImpl.this.myPermanentLinearGraph, index);
                List parentsCommitIds = PermanentGraphImpl.this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
                return GraphCommitImpl.createCommit(commitId, parentsCommitIds, PermanentGraphImpl.this.myPermanentCommitsInfo.getTimestamp(index));
            }

            @Override
            public int size() {
                return PermanentGraphImpl.this.myPermanentLinearGraph.nodesCount();
            }
        };
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        if (commit == null) {
            PermanentGraphImpl.$$$reportNull$$$0(16);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        List<CommitId> list = this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
        if (list == null) {
            PermanentGraphImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        if (commit == null) {
            PermanentGraphImpl.$$$reportNull$$$0(18);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        Set<CommitId> set = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<? extends CommitId> heads) {
        if (heads == null) {
            PermanentGraphImpl.$$$reportNull$$$0(20);
        }
        List headIds = ContainerUtil.map(heads, head -> this.myPermanentCommitsInfo.getNodeId(head));
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            IntOpenHashSet branchNodes = new IntOpenHashSet();
            this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(((Integer)this.myPermanentCommitsInfo.getCommitId((int)node)).intValue())));
            return new IntContainedInBranchCondition(branchNodes);
        }
        HashSet branchNodes = new HashSet();
        this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(this.myPermanentCommitsInfo.getCommitId((int)node))));
        return new ContainedInBranchCondition(branchNodes);
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(21);
        }
        return permanentCommitsInfoImpl;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(22);
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(23);
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(24);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentLinearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphColorManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesCommitId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCommits";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseController";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessor";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteredController";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleGraph";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentCommitsInfo";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBaseController";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredController";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleGraph";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainedInBranchCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final Set<CommitId> myBranchNodes;

        ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(commitId);
        }
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final IntOpenHashSet myBranchNodes;

        IntContainedInBranchCondition(IntOpenHashSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(((Integer)commitId).intValue());
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Int2ObjectOpenHashMap<CommitId> myNotLoadedCommits = new Int2ObjectOpenHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            Integer n = nodeId;
            if (n == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(0);
            }
            return n;
        }

        @NotNull
        Int2ObjectOpenHashMap<CommitId> getNotLoadedCommits() {
            Int2ObjectOpenHashMap<CommitId> int2ObjectOpenHashMap = this.myNotLoadedCommits;
            if (int2ObjectOpenHashMap == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(1);
            }
            return int2ObjectOpenHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$NotLoadedCommitsIdsGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotLoadedCommits";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

