/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashSet;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.service.JpsServiceManager;

public class BuilderRegistry {
    private static final Logger LOG = Logger.getInstance(BuilderRegistry.class);
    private final Map<BuilderCategory, List<ModuleLevelBuilder>> myModuleLevelBuilders = new HashMap<BuilderCategory, List<ModuleLevelBuilder>>();
    private final TObjectLongHashMap<BuildTargetType<?>> myExpectedBuildTime = new TObjectLongHashMap();
    private final List<TargetBuilder<?, ?>> myTargetBuilders = new ArrayList();
    private final FileFilter myModuleBuilderFileFilter;

    public static BuilderRegistry getInstance() {
        return Holder.ourInstance;
    }

    private BuilderRegistry() {
        for (BuilderCategory category : BuilderCategory.values()) {
            this.myModuleLevelBuilders.put(category, new ArrayList());
        }
        THashSet compilableFileExtensions = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (BuilderService service : JpsServiceManager.getInstance().getExtensions(BuilderService.class)) {
            this.myTargetBuilders.addAll(service.createBuilders());
            List<? extends ModuleLevelBuilder> moduleLevelBuilders = service.createModuleLevelBuilders();
            for (ModuleLevelBuilder moduleLevelBuilder : moduleLevelBuilders) {
                try {
                    List<String> extensions = moduleLevelBuilder.getCompilableFileExtensions();
                    if (compilableFileExtensions != null) {
                        compilableFileExtensions.addAll(extensions);
                    }
                }
                catch (AbstractMethodError e) {
                    LOG.info(moduleLevelBuilder.getClass().getName() + " builder doesn't implement 'getCompilableFileExtensions' method so ModuleBuildTarget will process all files under source roots.");
                    compilableFileExtensions = null;
                }
                this.myModuleLevelBuilders.get((Object)moduleLevelBuilder.getCategory()).add(moduleLevelBuilder);
            }
        }
        if (compilableFileExtensions == null) {
            this.myModuleBuilderFileFilter = FileUtilRt.ALL_FILES;
        } else {
            THashSet finalCompilableFileExtensions = compilableFileExtensions;
            this.myModuleBuilderFileFilter = arg_0 -> BuilderRegistry.lambda$new$0((Set)finalCompilableFileExtensions, arg_0);
        }
        long moduleTargetBuildTime = 0L;
        for (ModuleLevelBuilder moduleLevelBuilder : this.getModuleLevelBuilders()) {
            moduleTargetBuildTime += moduleLevelBuilder.getExpectedBuildTime();
        }
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.PRODUCTION, moduleTargetBuildTime);
        this.myExpectedBuildTime.put((Object)JavaModuleBuildTargetType.TEST, moduleTargetBuildTime);
        for (TargetBuilder targetBuilder : this.myTargetBuilders) {
            long l = targetBuilder.getExpectedBuildTime();
            for (BuildTargetType type : targetBuilder.getTargetTypes()) {
                if (this.myExpectedBuildTime.adjustValue(type, l)) continue;
                this.myExpectedBuildTime.put(type, l);
            }
        }
    }

    @NotNull
    public FileFilter getModuleBuilderFileFilter() {
        FileFilter fileFilter = this.myModuleBuilderFileFilter;
        if (fileFilter == null) {
            BuilderRegistry.$$$reportNull$$$0(0);
        }
        return fileFilter;
    }

    public int getModuleLevelBuilderCount() {
        int count = 0;
        for (BuilderCategory category : BuilderCategory.values()) {
            count += this.getBuilders(category).size();
        }
        return count;
    }

    public List<BuildTask> getBeforeTasks() {
        return Collections.emptyList();
    }

    public List<BuildTask> getAfterTasks() {
        return Collections.emptyList();
    }

    public List<ModuleLevelBuilder> getBuilders(BuilderCategory category) {
        return Collections.unmodifiableList(this.myModuleLevelBuilders.get((Object)category));
    }

    public List<ModuleLevelBuilder> getModuleLevelBuilders() {
        ArrayList<ModuleLevelBuilder> result = new ArrayList<ModuleLevelBuilder>();
        for (BuilderCategory category : BuilderCategory.values()) {
            result.addAll(this.getBuilders(category));
        }
        return result;
    }

    public List<TargetBuilder<?, ?>> getTargetBuilders() {
        return this.myTargetBuilders;
    }

    public long getExpectedBuildTimeForTarget(BuildTargetType<?> targetType) {
        long time = this.myExpectedBuildTime.get(targetType);
        if (time == -1L) {
            return 0L;
        }
        return time;
    }

    private static /* synthetic */ boolean lambda$new$0(Set finalCompilableFileExtensions, File file) {
        return finalCompilableFileExtensions.contains(FileUtilRt.getExtension((String)file.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/BuilderRegistry", "getModuleBuilderFileFilter"));
    }

    private static final class Holder {
        static final BuilderRegistry ourInstance = new BuilderRegistry();

        private Holder() {
        }
    }
}

