/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.InternedString;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.org.objectweb.asm.Type;

public final class TypeRepr {
    private static final byte PRIMITIVE_TYPE = 0;
    private static final byte CLASS_TYPE = 1;
    private static final byte ARRAY_TYPE = 2;

    private TypeRepr() {
    }

    public static Collection<AbstractType> createClassType(DependencyContext context, String[] args, Collection<AbstractType> acc) {
        if (args != null) {
            for (String a : args) {
                acc.add(TypeRepr.createClassType(context, context.get(a)));
            }
        }
        return acc;
    }

    public static ClassType createClassType(DependencyContext context, int s) {
        return (ClassType)context.getType(new ClassType(s));
    }

    public static AbstractType getType(DependencyContext context, int descr) {
        return TypeRepr.getType(InternedString.create(context, descr));
    }

    public static AbstractType getType(DependencyContext context, String descr) {
        return TypeRepr.getType(InternedString.create(context, descr));
    }

    public static AbstractType getType(InternedString descr) {
        DependencyContext context = descr.getContext();
        Type t = Type.getType((String)descr.asString());
        switch (t.getSort()) {
            case 10: {
                return context.getType(new ClassType(context.get(t.getClassName().replace('.', '/'))));
            }
            case 9: {
                return context.getType(new ArrayType(TypeRepr.getType(context, t.getElementType())));
            }
        }
        return context.getType(new PrimitiveType(descr.asInt()));
    }

    public static AbstractType getType(DependencyContext context, Type t) {
        return TypeRepr.getType(context, t.getDescriptor());
    }

    public static AbstractType[] getType(DependencyContext context, Type[] t) {
        if (t.length == 0) {
            return AbstractType.EMPTY_TYPE_ARRAY;
        }
        AbstractType[] r = new AbstractType[t.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = TypeRepr.getType(context, t[i]);
        }
        return r;
    }

    public static DataExternalizer<ClassType> classTypeExternalizer(DependencyContext context) {
        final DataExternalizer<AbstractType> delegate = TypeRepr.externalizer(context);
        return new DataExternalizer<ClassType>(){

            public void save(@NotNull DataOutput out, ClassType value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                delegate.save(out, (Object)value);
            }

            public ClassType read(@NotNull DataInput in) throws IOException {
                AbstractType read;
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((read = (AbstractType)delegate.read(in)) instanceof ClassType) {
                    return (ClassType)read;
                }
                throw new IOException("Expected: " + ClassType.class.getName() + "; Actual: " + (read == null ? "null" : read.getClass().getName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/TypeRepr$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static DataExternalizer<AbstractType> externalizer(final DependencyContext context) {
        return new DataExternalizer<AbstractType>(){

            public void save(@NotNull DataOutput out, AbstractType value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                value.save(out);
            }

            public AbstractType read(@NotNull DataInput in) throws IOException {
                AbstractType elementType;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                int level = 0;
                block5: while (true) {
                    byte tag = in.readByte();
                    switch (tag) {
                        case 0: {
                            elementType = context.getType(new PrimitiveType(in));
                            break block5;
                        }
                        case 1: {
                            elementType = context.getType(new ClassType(in));
                            break block5;
                        }
                        case 2: {
                            ++level;
                            continue block5;
                        }
                        default: {
                            System.out.println("Unknown type!");
                            continue block5;
                        }
                    }
                    break;
                }
                for (int i = 0; i < level; ++i) {
                    elementType = context.getType(new ArrayType(elementType));
                }
                return elementType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/TypeRepr$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static class ClassType
    implements AbstractType {
        public static final ClassType[] EMPTY_ARRAY = new ClassType[0];
        public final int className;

        @Override
        public String getDescr(DependencyContext context) {
            return "L" + context.getValue(this.className) + ";";
        }

        @Override
        public void updateClassUsages(DependencyContext context, int owner, Set<? super UsageRepr.Usage> s) {
            s.add(UsageRepr.createClassUsage(context, this.className));
        }

        ClassType(int className) {
            this.className = className;
        }

        ClassType(DataInput in) {
            try {
                this.className = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassType type = (ClassType)o;
            return this.className == type.className;
        }

        public int hashCode() {
            return this.className;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(1);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.className);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    public static class ArrayType
    implements AbstractType {
        public final AbstractType elementType;

        public AbstractType getDeepElementType() {
            AbstractType current = this;
            while (current instanceof ArrayType) {
                current = current.elementType;
            }
            return current;
        }

        @Override
        public String getDescr(DependencyContext context) {
            return "[" + this.elementType.getDescr(context);
        }

        @Override
        public void updateClassUsages(DependencyContext context, int owner, Set<? super UsageRepr.Usage> s) {
            this.elementType.updateClassUsages(context, owner, s);
        }

        ArrayType(AbstractType elementType) {
            this.elementType = elementType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayType arrayType = (ArrayType)o;
            return this.elementType.equals(arrayType.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(2);
                this.elementType.save(out);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    public static class PrimitiveType
    implements AbstractType {
        public final int type;

        @Override
        public String getDescr(DependencyContext context) {
            return context.getValue(this.type);
        }

        @Override
        public void updateClassUsages(DependencyContext context, int owner, Set<? super UsageRepr.Usage> s) {
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(0);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.type);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        PrimitiveType(int type) {
            this.type = type;
        }

        PrimitiveType(DataInput in) {
            try {
                this.type = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimitiveType that = (PrimitiveType)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return this.type;
        }
    }

    static interface AbstractType
    extends RW.Savable {
        public static final AbstractType[] EMPTY_TYPE_ARRAY = new AbstractType[0];

        public void updateClassUsages(DependencyContext var1, int var2, Set<? super UsageRepr.Usage> var3);

        public String getDescr(DependencyContext var1);

        @Override
        public void save(DataOutput var1);
    }
}

