/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public final class BackwardReferenceIndexUtil {
    private static final Logger LOG = Logger.getInstance(BackwardReferenceIndexUtil.class);

    /*
     * Could not resolve type clashes
     */
    static void registerFile(String filePath, TObjectIntHashMap<? extends JavacRef> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString, JavaBackwardReferenceIndexWriter writer) {
        try {
            int fileId = writer.enumeratePath(filePath);
            int funExprId = 0;
            HashMap<CompilerRef, Void> definitions = new HashMap<CompilerRef, Void>(defs.size());
            HashMap<CompilerRef, Collection<CompilerRef>> backwardHierarchyMap = new HashMap<CompilerRef, Collection<CompilerRef>>();
            THashMap signatureData = new THashMap();
            THashMap castMap = new THashMap();
            THashMap implicitToStringMap = new THashMap();
            AnonymousClassEnumerator anonymousClassEnumerator = new AnonymousClassEnumerator();
            for (JavacDef def : defs) {
                if (def instanceof JavacDef.JavacClassDef) {
                    JavacRef[] superClasses;
                    CompilerRef.CompilerClassHierarchyElementDef aClass;
                    JavacRef.JavacClass sym = (JavacRef.JavacClass)def.getDefinedElement();
                    if (sym.isPackageInfo()) continue;
                    if (sym.isAnonymous()) {
                        JavacRef[] classes = ((JavacDef.JavacClassDef)def).getSuperClasses();
                        if (classes.length == 0) {
                            LOG.info("Seems that compilation will finish with errors in anonymous class inside file " + filePath);
                            continue;
                        }
                        aClass = anonymousClassEnumerator.addAnonymous(sym.getName(), writer.asClassUsage(classes[0]));
                    } else {
                        aClass = writer.asClassUsage((JavacRef)sym);
                    }
                    definitions.put(aClass, null);
                    for (JavacRef superClass : superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses()) {
                        CompilerRef.JavaCompilerClassRef superClassRef = writer.asClassUsage(superClass);
                        backwardHierarchyMap.computeIfAbsent(superClassRef, k -> new SmartList()).add(aClass);
                    }
                    continue;
                }
                if (def instanceof JavacDef.JavacFunExprDef) {
                    CompilerRef.JavaCompilerClassRef functionalType = writer.asClassUsage(def.getDefinedElement());
                    int id = funExprId++;
                    CompilerRef.JavaCompilerFunExprDef result = new CompilerRef.JavaCompilerFunExprDef(id);
                    definitions.put(result, null);
                    ((Collection)ContainerUtil.getOrCreate(backwardHierarchyMap, (Object)functionalType, () -> new SmartList())).add(result);
                    continue;
                }
                if (!(def instanceof JavacDef.JavacMemberDef)) continue;
                CompilerRef ref = writer.enumerateNames(def.getDefinedElement(), (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous(name)));
                CompilerRef.JavaCompilerClassRef returnType = writer.asClassUsage(((JavacDef.JavacMemberDef)def).getReturnType());
                if (ref == null || returnType == null) continue;
                SignatureData data = new SignatureData(returnType.getName(), ((JavacDef.JavacMemberDef)def).getIteratorKind(), ((JavacDef.JavacMemberDef)def).isStatic());
                signatureData.computeIfAbsent(data, element -> new SmartList()).add(ref);
            }
            THashMap convertedRefs = new THashMap();
            IOException[] exception = new IOException[]{null};
            refs.forEachEntry((arg_0, arg_1) -> BackwardReferenceIndexUtil.lambda$registerFile$5(writer, anonymousClassEnumerator, (Map)convertedRefs, exception, arg_0, arg_1));
            if (exception[0] != null) {
                throw exception[0];
            }
            for (JavacTypeCast cast : casts) {
                CompilerRef enumeratedOperandType;
                CompilerRef enumeratedCastType = writer.enumerateNames((JavacRef)cast.getCastType(), (Function<? super String, Integer>)((Function)name -> null));
                if (enumeratedCastType == null || (enumeratedOperandType = writer.enumerateNames((JavacRef)cast.getOperandType(), (Function<? super String, Integer>)((Function)name -> null))) == null) continue;
                castMap.computeIfAbsent(enumeratedCastType, t -> new SmartList()).add(enumeratedOperandType);
            }
            for (JavacRef ref : implicitToString) {
                implicitToStringMap.put(writer.asClassUsage(ref), null);
            }
            writer.writeData(fileId, new CompiledFileData(backwardHierarchyMap, (Map<CompilerRef, Collection<CompilerRef>>)castMap, (Map<CompilerRef, Integer>)convertedRefs, definitions, (Map<SignatureData, Collection<CompilerRef>>)signatureData, (Map<CompilerRef, Void>)implicitToStringMap));
        }
        catch (IOException e) {
            writer.setRebuildCause(e);
        }
    }

    private static /* synthetic */ boolean lambda$registerFile$5(JavaBackwardReferenceIndexWriter writer, AnonymousClassEnumerator anonymousClassEnumerator, Map convertedRefs, IOException[] exception, JavacRef ref, int count) {
        try {
            CompilerRef compilerRef = writer.enumerateNames(ref, (Function<? super String, Integer>)((Function)name -> anonymousClassEnumerator.getCompilerRefIfAnonymous(name)));
            if (compilerRef != null) {
                Integer old = (Integer)convertedRefs.get(compilerRef);
                convertedRefs.put(compilerRef, old == null ? count : old + count);
            }
        }
        catch (IOException e) {
            exception[0] = e;
            return false;
        }
        return true;
    }

    private static class AnonymousClassEnumerator {
        private THashMap<String, CompilerRef.CompilerClassHierarchyElementDef> myAnonymousName2Id = null;

        private AnonymousClassEnumerator() {
        }

        private CompilerRef.JavaCompilerAnonymousClassRef addAnonymous(String internalName, CompilerRef.JavaCompilerClassRef base) {
            if (this.myAnonymousName2Id == null) {
                this.myAnonymousName2Id = new THashMap();
            }
            int anonymousIdx = this.myAnonymousName2Id.size();
            this.myAnonymousName2Id.put((Object)internalName, (Object)base);
            return new CompilerRef.JavaCompilerAnonymousClassRef(anonymousIdx);
        }

        private Integer getCompilerRefIfAnonymous(String className) {
            if (this.myAnonymousName2Id == null) {
                return null;
            }
            CompilerRef.CompilerClassHierarchyElementDef ref = (CompilerRef.CompilerClassHierarchyElementDef)this.myAnonymousName2Id.get((Object)className);
            return ref == null ? null : Integer.valueOf(ref.getName());
        }
    }
}

