/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.ClassObjectReferenceImpl;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.Packet;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.StringReferenceImpl;
import com.jetbrains.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class PacketStream {
    final VirtualMachineImpl vm;
    private int inCursor = 0;
    final Packet pkt;
    private final ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;

    PacketStream(VirtualMachineImpl vm, int cmdSet, int cmd) {
        this.vm = vm;
        this.pkt = new Packet();
        this.pkt.cmdSet = (short)cmdSet;
        this.pkt.cmd = (short)cmd;
    }

    PacketStream(VirtualMachineImpl vm, Packet pkt) {
        this.vm = vm;
        this.pkt = pkt;
        this.isCommitted = true;
    }

    int id() {
        return this.pkt.id;
    }

    void send() {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.vm.sendToTarget(this.pkt);
            this.isCommitted = true;
        }
    }

    void waitForReply() throws JDWPException {
        if (!this.isCommitted) {
            throw new InternalException("waitForReply without send");
        }
        if (this.vm != null) {
            this.vm.waitForTargetReply(this.pkt);
        }
        this.processError();
    }

    private void processError() throws JDWPException {
        if (this.pkt.errorCode != 0) {
            JDWPException e = new JDWPException(this.pkt.errorCode);
            if (this.pkt.errorCode == 113 && this.pkt.data.length > 0) {
                try {
                    e.initCause(new Throwable("(remote exception) " + this.readString()){

                        @Override
                        public synchronized Throwable fillInStackTrace() {
                            return this;
                        }

                        @Override
                        public String toString() {
                            return this.getMessage();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    <T> CompletableFuture<T> readReply(Function<Packet, T> reader) {
        return this.pkt.reply.thenApply(p -> {
            try {
                this.processError();
            }
            catch (JDWPException e) {
                throw e.toJDIException();
            }
            return reader.apply((Packet)p);
        });
    }

    void writeBoolean(boolean data) {
        if (data) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte data) {
        this.dataStream.write(data);
    }

    void writeChar(char data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeShort(short data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeInt(int data) {
        this.dataStream.write((byte)(data >>> 24 & 0xFF));
        this.dataStream.write((byte)(data >>> 16 & 0xFF));
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeLong(long data) {
        this.dataStream.write((byte)(data >>> 56 & 0xFFL));
        this.dataStream.write((byte)(data >>> 48 & 0xFFL));
        this.dataStream.write((byte)(data >>> 40 & 0xFFL));
        this.dataStream.write((byte)(data >>> 32 & 0xFFL));
        this.dataStream.write((byte)(data >>> 24 & 0xFFL));
        this.dataStream.write((byte)(data >>> 16 & 0xFFL));
        this.dataStream.write((byte)(data >>> 8 & 0xFFL));
        this.dataStream.write((byte)(data >>> 0 & 0xFFL));
    }

    void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    void writeID(int size, long data) {
        switch (size) {
            case 8: {
                this.writeLong(data);
                break;
            }
            case 4: {
                this.writeInt((int)data);
                break;
            }
            case 2: {
                this.writeShort((short)data);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
            }
        }
    }

    void writeNullObjectRef() {
        this.writeObjectRef(0L);
    }

    void writeObjectRef(long data) {
        this.writeID(this.vm.sizeofObjectRef, data);
    }

    void writeClassRef(long data) {
        this.writeID(this.vm.sizeofClassRef, data);
    }

    void writeMethodRef(long data) {
        this.writeID(this.vm.sizeofMethodRef, data);
    }

    void writeModuleRef(long data) {
        this.writeID(this.vm.sizeofModuleRef, data);
    }

    void writeFieldRef(long data) {
        this.writeID(this.vm.sizeofFieldRef, data);
    }

    void writeFrameRef(long data) {
        this.writeID(this.vm.sizeofFrameRef, data);
    }

    void writeByteArray(byte[] data) {
        this.dataStream.write(data, 0, data.length);
    }

    void writeString(String string) {
        byte[] stringBytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeInt(stringBytes.length);
        this.writeByteArray(stringBytes);
    }

    void writeLocation(Location location) {
        byte tag;
        ReferenceTypeImpl refType = (ReferenceTypeImpl)location.declaringType();
        if (refType instanceof ClassType) {
            tag = 1;
        } else if (refType instanceof InterfaceType) {
            tag = 2;
        } else {
            throw new InternalException("Invalid Location");
        }
        this.writeByte(tag);
        this.writeClassRef(refType.ref());
        this.writeMethodRef(((MethodImpl)location.method()).ref());
        this.writeLong(location.codeIndex());
    }

    void writeValue(Value val) {
        this.writeByte(ValueImpl.typeValueKey(val));
        this.writeUntaggedValue(val);
    }

    void writeUntaggedValue(Value val) {
        try {
            this.writeUntaggedValueChecked(val);
        }
        catch (InvalidTypeException exc) {
            throw new RuntimeException("Internal error: Invalid Tag/Type pair");
        }
    }

    void writeUntaggedValueChecked(Value val) throws InvalidTypeException {
        byte tag = ValueImpl.typeValueKey(val);
        if (PacketStream.isObjectTag(tag)) {
            if (val == null) {
                this.writeObjectRef(0L);
            } else {
                if (!(val instanceof ObjectReference)) {
                    throw new InvalidTypeException();
                }
                this.writeObjectRef(((ObjectReferenceImpl)val).ref());
            }
        } else {
            switch (tag) {
                case 66: {
                    if (!(val instanceof ByteValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeByte(((PrimitiveValue)val).byteValue());
                    break;
                }
                case 67: {
                    if (!(val instanceof CharValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeChar(((PrimitiveValue)val).charValue());
                    break;
                }
                case 70: {
                    if (!(val instanceof FloatValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeFloat(((PrimitiveValue)val).floatValue());
                    break;
                }
                case 68: {
                    if (!(val instanceof DoubleValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeDouble(((PrimitiveValue)val).doubleValue());
                    break;
                }
                case 73: {
                    if (!(val instanceof IntegerValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeInt(((PrimitiveValue)val).intValue());
                    break;
                }
                case 74: {
                    if (!(val instanceof LongValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeLong(((PrimitiveValue)val).longValue());
                    break;
                }
                case 83: {
                    if (!(val instanceof ShortValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeShort(((PrimitiveValue)val).shortValue());
                    break;
                }
                case 90: {
                    if (!(val instanceof BooleanValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeBoolean(((PrimitiveValue)val).booleanValue());
                }
            }
        }
    }

    byte readByte() {
        byte ret = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return ret;
    }

    boolean readBoolean() {
        byte ret = this.readByte();
        return ret != 0;
    }

    char readChar() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    short readShort() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    int readInt() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        int b3 = this.pkt.data[this.inCursor++] & 0xFF;
        int b4 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    long readLong() {
        long b1 = this.pkt.data[this.inCursor++] & 0xFF;
        long b2 = this.pkt.data[this.inCursor++] & 0xFF;
        long b3 = this.pkt.data[this.inCursor++] & 0xFF;
        long b4 = this.pkt.data[this.inCursor++] & 0xFF;
        long b5 = this.pkt.data[this.inCursor++] & 0xFF;
        long b6 = this.pkt.data[this.inCursor++] & 0xFF;
        long b7 = this.pkt.data[this.inCursor++] & 0xFF;
        long b8 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() {
        int len = this.readInt();
        String ret = new String(this.pkt.data, this.inCursor, len, StandardCharsets.UTF_8);
        this.inCursor += len;
        return ret;
    }

    private long readID(int size) {
        switch (size) {
            case 8: {
                return this.readLong();
            }
            case 4: {
                return this.readInt();
            }
            case 2: {
                return this.readShort();
            }
        }
        throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
    }

    long readObjectRef() {
        return this.readID(this.vm.sizeofObjectRef);
    }

    long readClassRef() {
        return this.readID(this.vm.sizeofClassRef);
    }

    ObjectReferenceImpl readTaggedObjectReference() {
        byte typeKey = this.readByte();
        return this.vm.objectMirror(this.readObjectRef(), typeKey);
    }

    ObjectReferenceImpl readObjectReference() {
        return this.vm.objectMirror(this.readObjectRef());
    }

    StringReferenceImpl readStringReference() {
        long ref = this.readObjectRef();
        return this.vm.stringMirror(ref);
    }

    ArrayReferenceImpl readArrayReference() {
        long ref = this.readObjectRef();
        return this.vm.arrayMirror(ref);
    }

    ThreadReferenceImpl readThreadReference() {
        long ref = this.readObjectRef();
        return this.vm.threadMirror(ref);
    }

    ThreadGroupReferenceImpl readThreadGroupReference() {
        long ref = this.readObjectRef();
        return this.vm.threadGroupMirror(ref);
    }

    ClassLoaderReferenceImpl readClassLoaderReference() {
        long ref = this.readObjectRef();
        return this.vm.classLoaderMirror(ref);
    }

    ClassObjectReferenceImpl readClassObjectReference() {
        long ref = this.readObjectRef();
        return this.vm.classObjectMirror(ref);
    }

    ReferenceTypeImpl readReferenceType() {
        byte tag = this.readByte();
        long ref = this.readObjectRef();
        return this.vm.referenceType(ref, tag);
    }

    long readMethodRef() {
        return this.readID(this.vm.sizeofMethodRef);
    }

    long readModuleRef() {
        return this.readID(this.vm.sizeofModuleRef);
    }

    long readFieldRef() {
        return this.readID(this.vm.sizeofFieldRef);
    }

    Field readField() {
        ReferenceTypeImpl refType = this.readReferenceType();
        long fieldRef = this.readFieldRef();
        return refType.getFieldMirror(fieldRef);
    }

    long readFrameRef() {
        return this.readID(this.vm.sizeofFrameRef);
    }

    ValueImpl readValue() {
        byte typeKey = this.readByte();
        return this.readUntaggedValue(typeKey);
    }

    ValueImpl readUntaggedValue(byte typeKey) {
        ValueImpl val = null;
        if (PacketStream.isObjectTag(typeKey)) {
            val = this.vm.objectMirror(this.readObjectRef(), typeKey);
        } else {
            switch (typeKey) {
                case 66: {
                    val = this.vm.mirrorOf(this.readByte());
                    break;
                }
                case 67: {
                    val = this.vm.mirrorOf(this.readChar());
                    break;
                }
                case 70: {
                    val = this.vm.mirrorOf(this.readFloat());
                    break;
                }
                case 68: {
                    val = this.vm.mirrorOf(this.readDouble());
                    break;
                }
                case 73: {
                    val = this.vm.mirrorOf(this.readInt());
                    break;
                }
                case 74: {
                    val = this.vm.mirrorOf(this.readLong());
                    break;
                }
                case 83: {
                    val = this.vm.mirrorOf(this.readShort());
                    break;
                }
                case 90: {
                    val = this.vm.mirrorOf(this.readBoolean());
                    break;
                }
                case 86: {
                    val = this.vm.mirrorOfVoid();
                }
            }
        }
        return val;
    }

    Location readLocation() {
        byte tag = this.readByte();
        long classRef = this.readObjectRef();
        long methodRef = this.readMethodRef();
        long codeIndex = this.readLong();
        if (classRef != 0L) {
            ReferenceTypeImpl refType = this.vm.referenceType(classRef, tag);
            return new LocationImpl(this.vm, refType, methodRef, codeIndex);
        }
        return null;
    }

    byte[] readByteArray(int length) {
        byte[] array = new byte[length];
        System.arraycopy(this.pkt.data, this.inCursor, array, 0, length);
        this.inCursor += length;
        return array;
    }

    List<Value> readArrayRegion() {
        byte typeKey = this.readByte();
        int length = this.readInt();
        ArrayList<Value> list = new ArrayList<Value>(length);
        boolean gettingObjects = PacketStream.isObjectTag(typeKey);
        for (int i = 0; i < length; ++i) {
            if (gettingObjects) {
                typeKey = this.readByte();
            }
            ValueImpl value = this.readUntaggedValue(typeKey);
            list.add(value);
        }
        return list;
    }

    void writeArrayRegion(List<Value> srcValues) {
        this.writeInt(srcValues.size());
        for (Value value : srcValues) {
            this.writeUntaggedValue(value);
        }
    }

    int skipBytes(int n) {
        this.inCursor += n;
        return n;
    }

    int available() {
        return this.pkt.data.length - this.inCursor;
    }

    byte command() {
        return (byte)this.pkt.cmd;
    }

    static boolean isObjectTag(byte tag) {
        return tag == 76 || tag == 91 || tag == 115 || tag == 116 || tag == 103 || tag == 108 || tag == 99;
    }
}

