/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class QuickFixManagerImpl
extends QuickFixManager<PropertyInspectorTable> {
    private static final Logger LOG = Logger.getInstance(QuickFixManagerImpl.class);

    QuickFixManagerImpl(GuiEditor editor, PropertyInspectorTable propertyInspectorTable, JViewport viewPort) {
        super(editor, propertyInspectorTable, viewPort);
        propertyInspectorTable.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
    }

    @Override
    @Nullable
    public Rectangle getErrorBounds() {
        int selectedRow = ((PropertyInspectorTable)((Object)this.myComponent)).getSelectedRow();
        if (selectedRow < 0 || selectedRow >= ((PropertyInspectorTable)((Object)this.myComponent)).getRowCount()) {
            return null;
        }
        Rectangle rowRect = ((PropertyInspectorTable)((Object)this.myComponent)).getCellRect(selectedRow, 0, true);
        LOG.assertTrue(rowRect != null);
        Rectangle visibleRect = ((PropertyInspectorTable)((Object)this.myComponent)).getVisibleRect();
        if (visibleRect.intersects(rowRect)) {
            return visibleRect.intersection(rowRect);
        }
        return null;
    }

    @Override
    public ErrorInfo @NotNull [] getErrorInfos() {
        int selectedRow = ((PropertyInspectorTable)((Object)this.myComponent)).getSelectedRow();
        if (selectedRow < 0 || selectedRow >= ((PropertyInspectorTable)((Object)this.myComponent)).getRowCount()) {
            if (ErrorInfo.EMPTY_ARRAY == null) {
                QuickFixManagerImpl.$$$reportNull$$$0(0);
            }
            return ErrorInfo.EMPTY_ARRAY;
        }
        ErrorInfo info = ((PropertyInspectorTable)((Object)this.myComponent)).getErrorInfoForRow(selectedRow);
        if (info != null) {
            ErrorInfo[] errorInfoArray = new ErrorInfo[]{info};
            if (errorInfoArray == null) {
                QuickFixManagerImpl.$$$reportNull$$$0(1);
            }
            return errorInfoArray;
        }
        if (ErrorInfo.EMPTY_ARRAY == null) {
            QuickFixManagerImpl.$$$reportNull$$$0(2);
        }
        return ErrorInfo.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/QuickFixManagerImpl", "getErrorInfos"));
    }

    private final class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            QuickFixManagerImpl.this.hideIntentionHint();
            QuickFixManagerImpl.this.updateIntentionHintVisibility();
        }
    }
}

