/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormElementProblemDescriptor;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.make.FormElementNavigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFileErrorCollector
extends FormErrorCollector {
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();

    FormFileErrorCollector(PsiFile file, InspectionManager manager, boolean onTheFly) {
        this.myManager = manager;
        this.myFile = file;
        this.myOnTheFly = onTheFly;
    }

    @Override
    public void addError(String inspectionId, @NotNull IComponent component, @Nullable IProperty prop, @NotNull String errorMessage, EditorQuickFixProvider ... editorQuickFixProviders) {
        if (component == null) {
            FormFileErrorCollector.$$$reportNull$$$0(0);
        }
        if (errorMessage == null) {
            FormFileErrorCollector.$$$reportNull$$$0(1);
        }
        if (editorQuickFixProviders == null) {
            FormFileErrorCollector.$$$reportNull$$$0(2);
        }
        ArrayList quickFixes = new ArrayList();
        for (EditorQuickFixProvider provider : editorQuickFixProviders) {
            Object[] localQuickFixes;
            if (!(provider instanceof LocalQuickFixProvider) || (localQuickFixes = ((LocalQuickFixProvider)provider).getQuickFixes()) == null) continue;
            ContainerUtil.addAll(quickFixes, (Object[])localQuickFixes);
        }
        FormElementProblemDescriptor problemDescriptor = new FormElementProblemDescriptor((PsiElement)this.myFile, JDOMUtil.escapeText((String)errorMessage), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, this.myOnTheFly, component.getId(), prop != null ? prop.getName() : null);
        FormElementNavigatable navigatable = new FormElementNavigatable(this.myFile.getProject(), this.myFile.getVirtualFile(), component.getId());
        problemDescriptor.setNavigatable(navigatable);
        this.myProblems.add((ProblemDescriptor)problemDescriptor);
    }

    public ProblemDescriptor[] result() {
        return this.myProblems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "errorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "editorQuickFixProviders";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/inspections/FormFileErrorCollector";
        objectArray[2] = "addError";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

