/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLocaleAction
extends ComboBoxAction {
    private GuiEditor myLastEditor;
    private Presentation myPresentation;

    public ChooseLocaleAction() {
        this.getTemplatePresentation().setText("");
        this.getTemplatePresentation().setDescription(UIDesignerBundle.messagePointer("choose.locale.description", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ChooseLocaleAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ChooseLocaleAction.$$$reportNull$$$0(1);
        }
        this.myPresentation = presentation;
        JComponent jComponent = super.createCustomComponent(presentation, place);
        if (jComponent == null) {
            ChooseLocaleAction.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        GuiEditor editor = this.myLastEditor;
        if (editor != null) {
            Locale[] locales = FormEditingUtil.collectUsedLocales(editor.getModule(), editor.getRootContainer());
            if (locales.length > 1 || locales.length == 1 && locales[0].getDisplayName().length() > 0) {
                Arrays.sort(locales, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
                for (Locale locale : locales) {
                    group.add((AnAction)new SetLocaleAction(editor, locale, true));
                }
            } else {
                group.add((AnAction)new SetLocaleAction(editor, new Locale(""), false));
            }
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            ChooseLocaleAction.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    @Nullable
    private GuiEditor getEditor(AnActionEvent e) {
        this.myLastEditor = FormEditingUtil.getActiveEditor(e.getDataContext());
        return this.myLastEditor;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseLocaleAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setVisible(this.getEditor(e) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/ChooseLocaleAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/ChooseLocaleAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SetLocaleAction
    extends AnAction {
        private final GuiEditor myEditor;
        private final Locale myLocale;
        private final boolean myUpdateText;

        SetLocaleAction(GuiEditor editor, Locale locale, boolean updateText) {
            super(locale.getDisplayName().length() == 0 ? UIDesignerBundle.message("choose.locale.default", new Object[0]) : locale.getDisplayName());
            this.myUpdateText = updateText;
            this.myEditor = editor;
            this.myLocale = locale;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetLocaleAction.$$$reportNull$$$0(0);
            }
            this.myEditor.setStringDescriptorLocale(this.myLocale);
            if (this.myUpdateText) {
                ChooseLocaleAction.this.myPresentation.setText(this.getTemplatePresentation().getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/actions/ChooseLocaleAction$SetLocaleAction", "actionPerformed"));
        }
    }
}

