/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.util.EditorHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"createLinkToFile", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "isSupported", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "javaVersionString", "notifyInvalidGradleJavaHomeInfo", "", "javaHomeProperty", "Lorg/jetbrains/plugins/gradle/util/GradleProperties$GradleProperty;", "reason", "Lorg/jetbrains/plugins/gradle/util/JavaHomeValidationStatus;", "notifyInvalidGradleJvmInfo", "notificationHint", "notifyInvalidJavaHomeInfo", "validateGradleJavaHome", "javaHome", "validateJavaHome", "externalProjectPath", "Ljava/nio/file/Path;", "intellij.gradle.common"})
@ApiStatus.Internal
@JvmName(name="GradleJvmValidationUtil")
public final class GradleJvmValidationUtil {
    public static final void validateJavaHome(@NotNull Project project, @NotNull Path externalProjectPath, @NotNull GradleVersion gradleVersion) {
        block2: {
            JavaHomeValidationStatus validationStatus;
            block3: {
                block0: {
                    JavaHomeValidationStatus validationStatus2;
                    GradleProperties.GradleProperty<String> javaHomeProperty;
                    block1: {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        Intrinsics.checkParameterIsNotNull((Object)externalProjectPath, (String)"externalProjectPath");
                        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
                        GradleProperties gradleProperties = GradlePropertiesUtil.getGradleProperties(externalProjectPath);
                        javaHomeProperty = gradleProperties.getJavaHomeProperty();
                        if (javaHomeProperty == null) break block0;
                        String javaHome = javaHomeProperty.getValue();
                        validationStatus2 = GradleJvmValidationUtil.validateGradleJavaHome(gradleVersion, javaHome);
                        if (!Intrinsics.areEqual((Object)validationStatus2, (Object)JavaHomeValidationStatus.Invalid.INSTANCE)) break block1;
                        GradleJvmValidationUtil.notifyInvalidGradleJavaHomeInfo(project, javaHomeProperty, validationStatus2);
                        break block2;
                    }
                    if (!(validationStatus2 instanceof JavaHomeValidationStatus.Unsupported)) break block2;
                    GradleJvmValidationUtil.notifyInvalidGradleJavaHomeInfo(project, javaHomeProperty, validationStatus2);
                    break block2;
                }
                String javaHome = ExternalSystemJdkUtil.getJavaHome();
                validationStatus = GradleJvmValidationUtil.validateGradleJavaHome(gradleVersion, javaHome);
                if (!Intrinsics.areEqual((Object)validationStatus, (Object)JavaHomeValidationStatus.Invalid.INSTANCE)) break block3;
                GradleJvmValidationUtil.notifyInvalidJavaHomeInfo(project, validationStatus);
                break block2;
            }
            if (!(validationStatus instanceof JavaHomeValidationStatus.Unsupported)) break block2;
            GradleJvmValidationUtil.notifyInvalidJavaHomeInfo(project, validationStatus);
        }
    }

    @NotNull
    public static final JavaHomeValidationStatus validateGradleJavaHome(@NotNull GradleVersion gradleVersion, @Nullable String javaHome) {
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        if (javaHome == null) {
            return JavaHomeValidationStatus.Undefined.INSTANCE;
        }
        if (!ExternalSystemJdkUtil.isValidJdk((String)javaHome)) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
        SdkType javaSdkType = sdkType;
        String string = javaSdkType.getVersionString(javaHome);
        if (string == null) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaSdkType.getVersionSt\u2026eValidationStatus.Invalid");
        String versionString = string;
        JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
        if (javaVersion == null) {
            return JavaHomeValidationStatus.Invalid.INSTANCE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026eValidationStatus.Invalid");
        JavaVersion javaVersion2 = javaVersion;
        if (!GradleJvmValidationUtil.isSupported(gradleVersion, versionString)) {
            return new JavaHomeValidationStatus.Unsupported(javaVersion2, gradleVersion);
        }
        return new JavaHomeValidationStatus.Success(javaHome);
    }

    public static final boolean isSupported(@NotNull GradleVersion gradleVersion, @NotNull String javaVersionString) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        Intrinsics.checkParameterIsNotNull((Object)javaVersionString, (String)"javaVersionString");
        JavaVersion javaVersion = JavaVersion.tryParse((String)javaVersionString);
        if (javaVersion == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion, (String)"JavaVersion.tryParse(jav\u2026onString) ?: return false");
        JavaVersion version = javaVersion;
        boolean bl = gradleVersion.compareTo(GradleVersion.version((String)"6.3")) >= 0 ? version.feature >= 8 : (gradleVersion.compareTo(GradleVersion.version((String)"6.0")) >= 0 ? 8 <= (n6 = version.feature) && 13 >= n6 : (gradleVersion.compareTo(GradleVersion.version((String)"5.4.1")) >= 0 ? 8 <= (n5 = version.feature) && 12 >= n5 : (gradleVersion.compareTo(GradleVersion.version((String)"5.0")) >= 0 ? 8 <= (n4 = version.feature) && 11 >= n4 : (gradleVersion.compareTo(GradleVersion.version((String)"4.1")) >= 0 ? 7 <= (n3 = version.feature) && 9 >= n3 : (gradleVersion.compareTo(GradleVersion.version((String)"4.0")) >= 0 ? 7 <= (n2 = version.feature) && 8 >= n2 : 6 <= (n = version.feature) && 8 >= n)))));
        return bl;
    }

    private static final void notifyInvalidGradleJavaHomeInfo(Project project, GradleProperties.GradleProperty<String> javaHomeProperty, JavaHomeValidationStatus reason) {
        String notificationContent;
        String propertyLocation = GradleJvmValidationUtil.createLinkToFile(project, javaHomeProperty.getLocation());
        String string = notificationContent = GradleBundle.message("gradle.notifications.java.home.property.content", propertyLocation);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"notificationContent");
        GradleJvmValidationUtil.notifyInvalidGradleJvmInfo(project, string, reason);
    }

    private static final void notifyInvalidJavaHomeInfo(Project project, JavaHomeValidationStatus reason) {
        String notificationContent;
        String string = notificationContent = GradleBundle.message("gradle.notifications.java.home.variable.content", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"notificationContent");
        GradleJvmValidationUtil.notifyInvalidGradleJvmInfo(project, string, reason);
    }

    private static final String createLinkToFile(Project project, String path) {
        String string;
        VirtualFile projectDirectory = ProjectUtil.guessProjectDir((Project)project);
        Object object = projectDirectory;
        if (object != null && (object = object.getPath()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            string = FileUtil.toSystemDependentName((String)it);
        } else {
            string = null;
        }
        String projectPath = string;
        String string2 = FileUtil.toSystemDependentName((String)path);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toSystemDependentName(path)");
        String filePath = string2;
        String presentablePath = projectPath == null ? FileUtil.getLocationRelativeToUserHome((String)filePath) : (FileUtil.isAncestor((String)projectPath, (String)filePath, (boolean)true) ? FileUtil.getRelativePath((String)projectPath, (String)filePath, (char)File.separatorChar) : FileUtil.getLocationRelativeToUserHome((String)filePath));
        return "<a href='" + path + "'>" + presentablePath + "</a>";
    }

    private static final void notifyInvalidGradleJvmInfo(Project project, String notificationHint, JavaHomeValidationStatus reason) {
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.invalid.title", new Object[0]);
        String notificationContent = notificationHint;
        if (reason instanceof JavaHomeValidationStatus.Unsupported) {
            String string = ((JavaHomeValidationStatus.Unsupported)reason).getJavaVersion().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reason.javaVersion.toString()");
            String javaVersion = string;
            String gradleVersion = ((JavaHomeValidationStatus.Unsupported)reason).getGradleVersion().getVersion();
            String additionalFailureHint = GradleBundle.message("gradle.notifications.java.home.unsupported.content", javaVersion, gradleVersion);
            notificationContent = additionalFailureHint + ' ' + notificationContent;
        }
        NotificationListener.Adapter hyperLinkProcessor2 = new NotificationListener.Adapter(project){
            final /* synthetic */ Project $project;

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(e.getDescription());
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026(e.description) ?: return");
                VirtualFile file = virtualFile;
                ProjectViewSelectInTarget.select((Project)this.$project, (Object)file, (String)"ProjectPane", null, (VirtualFile)file, (boolean)true);
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project).findFile(file);
                if (psiFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiManager.getInstance(p\u2026.findFile(file) ?: return");
                PsiFile psiFile2 = psiFile;
                EditorHelper.openInEditor((PsiElement)((PsiElement)psiFile2));
            }
            {
                this.$project = $captured_local_variable$0;
            }
        };
        String string = notificationTitle;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"notificationTitle");
        Notification notification2 = GradleNotification.NOTIFICATION_GROUP.createNotification(string, notificationContent, NotificationType.INFORMATION, (NotificationListener)hyperLinkProcessor2);
        notification2.notify(project);
    }
}

