/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitCheckoutOperation
extends GitBranchOperation {
    private static final int REPOSITORIES_LIMIT = 4;
    @NonNls
    private static final String ROLLBACK_HREF_ATTRIBUTE = "rollback";
    @NotNull
    private final String myStartPointReference;
    private final boolean myDetach;
    private final boolean myReset;
    private final boolean myRefShouldBeValid;
    @Nullable
    private final String myNewBranch;

    GitCheckoutOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPointReference, boolean detach, boolean withReset, boolean refShouldBeValid, @Nullable String newBranch) {
        if (project == null) {
            GitCheckoutOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCheckoutOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitCheckoutOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(3);
        }
        if (startPointReference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myStartPointReference = startPointReference;
        this.myDetach = detach;
        this.myReset = withReset;
        this.myRefShouldBeValid = refShouldBeValid;
        this.myNewBranch = newBranch;
    }

    @Override
    protected void execute() {
        GitCheckoutOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        this.notifyBranchWillChange();
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getOperationName());){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                VirtualFile root = repository.getRoot();
                Hash startHash = GitUtil.getHead(repository);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT);
                GitSimpleEventDetector unknownPathspec = new GitSimpleEventDetector(GitSimpleEventDetector.Event.INVALID_REFERENCE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByCheckout = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitCommandResult result2 = this.myGit.checkout(repository, this.myStartPointReference, this.myNewBranch, false, this.myDetach, this.myReset, localChangesDetector, unmergedFiles, unknownPathspec, untrackedOverwrittenByCheckout);
                if (result2.success()) {
                    GitUtil.updateAndRefreshChangedVfs(repository, startHash);
                    this.markSuccessful(repository);
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    boolean smartCheckoutSucceeded = this.smartCheckoutOrNotify(repository, localChangesDetector);
                    if (smartCheckoutSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (untrackedOverwrittenByCheckout.wasMessageDetected()) {
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByCheckout.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                if (!this.myRefShouldBeValid && unknownPathspec.hasHappened()) {
                    this.markSkip(repository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
        }
        if (!fatalErrorHappened) {
            Collection<GitRepository> repositories = this.getSkippedRepositories();
            String revisionNotFound = GitBundle.message("checkout.operation.revision.not.found", repositories.size(), DvcsUtil.joinShortNames(repositories, (int)4));
            if (this.wereSuccessful()) {
                if (!this.wereSkipped()) {
                    this.notifySuccess();
                } else {
                    Collection<GitRepository> successfulRepositories = this.getSuccessfulRepositories();
                    String mentionSuccess = GitBundle.message("checkout.operation.in", this.getSuccessMessage(), successfulRepositories.size(), DvcsUtil.joinShortNames(successfulRepositories, (int)4));
                    String mentionSkipped = this.wereSkipped() ? "<br/>" + revisionNotFound : "";
                    VcsNotifier.getInstance((Project)this.myProject).notifySuccess("", mentionSuccess + mentionSkipped + "<br/>" + "<a href='" + ROLLBACK_HREF_ATTRIBUTE + "'>" + GitBundle.message("checkout.operation.rollback", new Object[0]) + "</a>", (NotificationListener)new RollbackOperationNotificationListener());
                }
                this.notifyBranchHasChanged(this.myStartPointReference);
                this.updateRecentBranch();
            } else {
                LOG.assertTrue(!this.myRefShouldBeValid);
                this.notifyError(GitBundle.message("checkout.operation.could.not.checkout.error", GitCheckoutOperation.getRefPresentation(this.myStartPointReference)), revisionNotFound);
            }
        }
    }

    private boolean smartCheckoutOrNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByCheckout) {
        Collection<String> absolutePaths;
        if (repository == null) {
            GitCheckoutOperation.$$$reportNull$$$0(5);
        }
        if (localChangesOverwrittenByCheckout == null) {
            GitCheckoutOperation.$$$reportNull$$$0(6);
        }
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByCheckout, (String)this.myCurrentHeads.get(repository), this.myStartPointReference);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByCheckout.getRelativeFilePaths()), GitBundle.message("checkout.operation.name", new Object[0]), GitBundle.message("checkout.operation.force.checkout", new Object[0]));
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            Hash startHash = GitUtil.getHead(repository);
            boolean smartCheckedOutSuccessfully = this.smartCheckout(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, this.getIndicator());
            if (smartCheckedOutSuccessfully) {
                for (GitRepository conflictingRepository : allConflictingRepositories) {
                    this.markSuccessful(conflictingRepository);
                    GitUtil.updateAndRefreshChangedVfs(conflictingRepository, startHash);
                }
                return true;
            }
            return false;
        }
        if (decision == GitSmartOperationDialog.Choice.FORCE) {
            Map changesToRefresh = StreamEx.of((Collection)allConflictingRepositories).toMap(repo -> GitChangeUtils.getDiffWithWorkingTree(repo, this.myStartPointReference, false));
            boolean forceCheckoutSucceeded = this.checkoutOrNotify(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, true);
            if (forceCheckoutSucceeded) {
                this.markSuccessful(allConflictingRepositories.toArray(new GitRepository[0]));
                GitUtil.updateRepositories(allConflictingRepositories);
                allConflictingRepositories.forEach(repo -> GitUtil.refreshVfs(repo.getRoot(), (Collection)changesToRefresh.get(repo)));
            }
            return forceCheckoutSucceeded;
        }
        this.fatalLocalChangesError(this.myStartPointReference);
        return false;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        String previousBranch = (String)UtilKt.getIfSingle(repositories.stream().map(this.myCurrentHeads::get).distinct());
        if (previousBranch == null) {
            previousBranch = GitBundle.message("checkout.operation.previous.branch", new Object[0]);
        }
        String rollBackProposal = GitBundle.message("checkout.operation.you.may.rollback.not.to.let.branches.diverge", previousBranch);
        String string = GitBundle.message("checkout.operation.however.checkout.has.succeeded.for.the.following", repositories.size()) + "<br/>" + this.successfulRepositoriesJoined() + "<br/>" + rollBackProposal;
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("checkout.operation.name", new Object[0]);
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            Hash startHash = GitUtil.getHead(repository);
            GitCommandResult result2 = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result2);
            if (result2.success() && this.myNewBranch != null) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranch, true, new GitLineHandlerListener[0]));
            }
            GitUtil.updateAndRefreshChangedVfs(repository, startHash);
        }
        if (!checkoutResult.totalSuccess() || !deleteResult.totalSuccess()) {
            StringBuilder message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.operation.errors.during.checkout", new Object[0]));
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.operation.errors.during.deleting", GitUIUtil.code(this.myNewBranch)));
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError(GitBundle.message("checkout.operation.error.during.rollback", new Object[0]), message.toString(), true);
        }
    }

    @NotNull
    private String getCommonErrorTitle() {
        String string = GitBundle.message("checkout.operation.could.not.checkout.error.title", GitCheckoutOperation.getRefPresentation(this.myStartPointReference));
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        if (this.myNewBranch == null) {
            String string = GitBundle.message("checkout.operation.checked.out", GitUIUtil.bold(GitUIUtil.code(this.myStartPointReference)));
            if (string == null) {
                GitCheckoutOperation.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = GitBundle.message("checkout.operation.checked.out.new.branch.from", GitUIUtil.bold(GitUIUtil.code(this.myNewBranch)), GitUIUtil.bold(GitUIUtil.code(GitCheckoutOperation.getRefPresentation(this.myStartPointReference))));
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getRefPresentation(@NotNull String reference) {
        if (reference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(12);
        }
        String string = StringUtil.substringBeforeLast((String)reference, (String)"^0");
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(13);
        }
        return string;
    }

    private boolean smartCheckout(@NotNull List<? extends GitRepository> repositories, @NotNull String reference, @Nullable String newBranch, @NotNull ProgressIndicator indicator) {
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(14);
        }
        if (reference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            GitCheckoutOperation.$$$reportNull$$$0(16);
        }
        AtomicBoolean result2 = new AtomicBoolean();
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), GitBundle.message("checkout.operation.name", new Object[0]), reference, saveMethod, indicator, () -> result2.set(this.checkoutOrNotify(repositories, reference, newBranch, false)));
        preservingProcess.execute();
        return result2.get();
    }

    private boolean checkoutOrNotify(@NotNull List<? extends GitRepository> repositories, @NotNull String reference, @Nullable String newBranch, boolean force) {
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(17);
        }
        if (reference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(18);
        }
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        for (GitRepository gitRepository : repositories) {
            compoundResult.append(gitRepository, this.myGit.checkout(gitRepository, reference, newBranch, force, this.myDetach, this.myReset, new GitLineHandlerListener[0]));
        }
        if (compoundResult.totalSuccess()) {
            return true;
        }
        this.notifyError(GitBundle.message("checkout.operation.could.not.checkout.error", reference), compoundResult.getErrorOutputWithReposIndication());
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPointReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenByCheckout";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitCheckoutOperation";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitCheckoutOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonErrorTitle";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "smartCheckoutOrNotify";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRefPresentation";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "smartCheckout";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkoutOrNotify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RollbackOperationNotificationListener
    implements NotificationListener {
        private RollbackOperationNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                RollbackOperationNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                RollbackOperationNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equalsIgnoreCase(GitCheckoutOperation.ROLLBACK_HREF_ATTRIBUTE)) {
                GitCheckoutOperation.this.rollback();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitCheckoutOperation$RollbackOperationNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

