/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.transport;

import java.io.IOException;
import org.gradle.internal.impldep.org.simpleframework.transport.Controller;
import org.gradle.internal.impldep.org.simpleframework.transport.Flusher;
import org.gradle.internal.impldep.org.simpleframework.transport.Packet;
import org.gradle.internal.impldep.org.simpleframework.transport.Socket;
import org.gradle.internal.impldep.org.simpleframework.transport.SocketFlusher;
import org.gradle.internal.impldep.org.simpleframework.transport.SocketWriter;
import org.gradle.internal.impldep.org.simpleframework.transport.Writer;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Reactor;

class SocketController
implements Controller {
    private final Flusher flusher;
    private final Writer writer;

    public SocketController(Socket socket, Reactor reactor, int limit) throws IOException {
        this.writer = new SocketWriter(socket, limit);
        this.flusher = new SocketFlusher(reactor, this.writer);
    }

    public void write(Packet packet) throws IOException {
        boolean done = this.writer.write(packet);
        if (!done) {
            this.flusher.flush();
        }
    }

    public void flush() throws IOException {
        boolean done = this.writer.flush();
        if (!done) {
            this.flusher.flush();
        }
    }

    public void close() throws IOException {
        this.flusher.close();
        this.writer.close();
    }
}

