/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.vcs;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.jetbrains.changeReminder.predict.FileProbabilityRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/filePrediction/features/vcs/FilePredictionVcsFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "calculateFileFeatures", "", "", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "refs", "Lcom/intellij/filePrediction/references/ExternalReferencesResult;", "getFeatures", "", "()[Ljava/lang/String;", "getName", "intellij.filePrediction"})
public final class FilePredictionVcsFeatures
implements FilePredictionFeatureProvider {
    @Override
    @NotNull
    public String getName() {
        return "vcs";
    }

    @Override
    @NotNull
    public String[] getFeatures() {
        return new String[]{"prev_in_changelist", "in_changelist", "related_prob"};
    }

    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull ExternalReferencesResult refs) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        if (!ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            return MapsKt.emptyMap();
        }
        HashMap result2 = new HashMap();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
        ChangeListManager changeListManager2 = changeListManager;
        if (prevFile != null) {
            ((Map)result2).put("prev_in_changelist", FilePredictionFeature.Companion.binary(changeListManager2.isFileAffected(prevFile)));
        }
        ((Map)result2).put("in_changelist", FilePredictionFeature.Companion.binary(changeListManager2.isFileAffected(newFile)));
        if (prevFile != null) {
            VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
            VcsLogData dataManager = vcsProjectLog.getDataManager();
            if (dataManager != null) {
                VcsContextFactory contextFactory = VcsContextFactory.SERVICE.getInstance();
                FilePath filePath = contextFactory.createFilePath(newFile.getPath(), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"contextFactory.createFilePath(newFile.path, false)");
                FilePath newPath = filePath;
                FilePath filePath2 = contextFactory.createFilePath(prevFile.getPath(), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)filePath2, (String)"contextFactory.createFil\u2026ath(prevFile.path, false)");
                FilePath recentFile = filePath2;
                List<FilePath> list = Collections.singletonList(recentFile);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(recentFile)");
                FileProbabilityRequest request = new FileProbabilityRequest(project, dataManager, (Collection)list);
                ((Map)result2).put("related_prob", FilePredictionFeature.Companion.numerical(request.calculate(newPath)));
            }
        }
        return result2;
    }
}

