/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.features.history.FileHistoryFeatures;
import com.intellij.filePrediction.features.history.FilePredictionHistory;
import com.intellij.filePrediction.features.history.NextFileProbability;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J6\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\bH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/filePrediction/features/history/FilePredictionHistoryFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "addNGramFeatures", "", "probability", "Lcom/intellij/filePrediction/features/history/NextFileProbability;", "prefix", "", "result", "Ljava/util/HashMap;", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "Lkotlin/collections/HashMap;", "calculateFileFeatures", "", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "refs", "Lcom/intellij/filePrediction/references/ExternalReferencesResult;", "getFeatures", "", "()[Ljava/lang/String;", "getName", "intellij.filePrediction"})
public final class FilePredictionHistoryFeatures
implements FilePredictionFeatureProvider {
    @Override
    @NotNull
    public String getName() {
        return "history";
    }

    @Override
    @NotNull
    public String[] getFeatures() {
        return new String[]{"size", "position", "uni_mle", "uni_min", "uni_max", "uni_mle_to_min", "uni_mle_to_max", "bi_mle", "bi_min", "bi_max", "bi_mle_to_min", "bi_mle_to_max"};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull ExternalReferencesResult refs) {
        void uniGram;
        void position;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        HashMap<String, FilePredictionFeature> result2 = new HashMap<String, FilePredictionFeature>();
        FilePredictionHistory history = FilePredictionHistory.Companion.getInstance(project);
        ((Map)result2).put("size", FilePredictionFeature.Companion.numerical(history.size()));
        String string = newFile.getUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newFile.url");
        FileHistoryFeatures fileHistoryFeatures = history.calcHistoryFeatures(string);
        Integer n = fileHistoryFeatures.component1();
        NextFileProbability nextFileProbability = fileHistoryFeatures.component2();
        NextFileProbability biGram = fileHistoryFeatures.component3();
        if (position != null) {
            ((Map)result2).put("position", FilePredictionFeature.Companion.numerical(position.intValue()));
        }
        this.addNGramFeatures((NextFileProbability)uniGram, "uni", result2);
        this.addNGramFeatures(biGram, "bi", result2);
        return result2;
    }

    private final void addNGramFeatures(NextFileProbability probability, String prefix, HashMap<String, FilePredictionFeature> result2) {
        ((Map)result2).put(prefix + "_mle", FilePredictionFeature.Companion.numerical(probability.getMle()));
        ((Map)result2).put(prefix + "_min", FilePredictionFeature.Companion.numerical(probability.getMinMle()));
        ((Map)result2).put(prefix + "_max", FilePredictionFeature.Companion.numerical(probability.getMaxMle()));
        ((Map)result2).put(prefix + "_mle_to_min", FilePredictionFeature.Companion.numerical(probability.getMleToMin()));
        ((Map)result2).put(prefix + "_mle_to_max", FilePredictionFeature.Companion.numerical(probability.getMleToMax()));
    }
}

